/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.currency.command.admin;

import cn.handyplus.currency.api.PlayerCurrencyApi;
import cn.handyplus.currency.constants.CurrencyType;
import cn.handyplus.currency.lib.command.IHandyCommandEvent;
import cn.handyplus.currency.lib.core.MapUtil;
import cn.handyplus.currency.lib.util.AssertUtil;
import cn.handyplus.currency.lib.util.BaseUtil;
import cn.handyplus.currency.lib.util.MessageUtil;
import cn.handyplus.currency.util.CurrencyUtil;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

public class GiveCommand
implements IHandyCommandEvent {
    @Override
    public String command() {
        return "give";
    }

    @Override
    public String permission() {
        return "playerCurrency.give";
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void onCommand(CommandSender sender, Command command, String s, String[] args) {
        AssertUtil.notTrue(args.length < 4, BaseUtil.getMsgNotColor("paramFailureMsg"));
        UUID playerUuid = CurrencyUtil.getPlayerUuid(sender, args[1]);
        if (playerUuid == null) {
            return;
        }
        String type = args[2];
        AssertUtil.isTrue(CurrencyType.exist(type), BaseUtil.getMsgNotColor("typeFailureMsg"));
        Long amount = AssertUtil.isNumericToLong(args[3], BaseUtil.getMsgNotColor("amountFailureMsg"));
        String operatorReason = args.length > 4 ? args[4] : "give";
        boolean rst = PlayerCurrencyApi.give(playerUuid, type, amount, CurrencyUtil.getOperatorName(sender), operatorReason);
        HashMap<String, String> map = MapUtil.newHashMapWithExpectedSize(5);
        map.put("${player}", args[1]);
        map.put("${type}", CurrencyType.getDesc(type));
        map.put("${amount}", String.valueOf(amount));
        map.put("${balance}", PlayerCurrencyApi.look(playerUuid, type).toString());
        map.put("${operatorReason}", operatorReason);
        String giveMsg = BaseUtil.getMsgNotColor("giveMsg", map);
        MessageUtil.sendMessage(sender, rst ? giveMsg : BaseUtil.getMsgNotColor("failureMsg"));
        if (rst) {
            MessageUtil.sendMessage(args[1], BaseUtil.getMsgNotColor("givePlayerMsg", map));
        }
    }
}

