/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.currency.command.admin;

import cn.handyplus.currency.PlayerCurrency;
import cn.handyplus.currency.api.PlayerCurrencyApi;
import cn.handyplus.currency.constants.ImportTypeEnum;
import cn.handyplus.currency.enter.NyEconomyEnter;
import cn.handyplus.currency.hook.PlayerPointsUtil;
import cn.handyplus.currency.hook.VaultUtil;
import cn.handyplus.currency.lib.command.IHandyCommandEvent;
import cn.handyplus.currency.lib.constants.HookPluginEnum;
import cn.handyplus.currency.lib.core.CollUtil;
import cn.handyplus.currency.lib.core.JsonUtil;
import cn.handyplus.currency.lib.core.MapUtil;
import cn.handyplus.currency.lib.core.StrUtil;
import cn.handyplus.currency.lib.util.AssertUtil;
import cn.handyplus.currency.lib.util.BaseUtil;
import cn.handyplus.currency.lib.util.HandyConfigUtil;
import cn.handyplus.currency.lib.util.MessageUtil;
import cn.handyplus.currency.service.NyEconomyService;
import cn.handyplus.currency.util.ConfigUtil;
import cn.handyplus.currency.util.CurrencyUtil;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import me.xanium.gemseconomy.account.Account;
import me.xanium.gemseconomy.currency.Currency;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

public class ImportCommand
implements IHandyCommandEvent {
    @Override
    public String command() {
        return "import";
    }

    @Override
    public String permission() {
        return "playerCurrency.import";
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        AssertUtil.notTrue(args.length < 2, BaseUtil.getMsgNotColor("paramFailureMsg"));
        String importType = args[1];
        ImportTypeEnum importTypeEnum = ImportTypeEnum.getEnum(importType);
        AssertUtil.notNull((Object)importTypeEnum, BaseUtil.getMsgNotColor("paramFailureMsg"));
        MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor("importMsg"));
        switch (importTypeEnum) {
            case NYE: {
                this.importNye(sender);
                break;
            }
            case PLAYER_POINTS: {
                this.importPoints(sender);
                break;
            }
            case VAULT: {
                this.importVault(sender);
                break;
            }
            case GEMS_ECONOMY: {
                this.importGemsEconomy(sender);
                break;
            }
        }
        MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor("succeedMsg"));
    }

    private synchronized void importNye(CommandSender sender) {
        List<NyEconomyEnter> nyEconomyEnterList = NyEconomyService.getInstance().findAll();
        if (CollUtil.isEmpty(nyEconomyEnterList)) {
            MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor("notDataMsg"));
            return;
        }
        HashSet<String> typeSet = new HashSet<String>();
        for (NyEconomyEnter nyEconomyEnter : nyEconomyEnterList) {
            OfflinePlayer offlinePlayer = BaseUtil.getOfflinePlayer(nyEconomyEnter.getUser());
            Map<String, Long> convert = this.convert(nyEconomyEnter.getData());
            for (String type : convert.keySet()) {
                typeSet.add(type);
                PlayerCurrencyApi.set(offlinePlayer.getUniqueId(), type, convert.get(type), CurrencyUtil.getOperatorName(sender), "\u5bfc\u5165NyEconomy\u6570\u636e");
            }
        }
        for (String type : typeSet) {
            HandyConfigUtil.setPathIsNotContains(ConfigUtil.CONFIG, "currency." + type, type, null, "config.yml");
        }
    }

    private synchronized void importPoints(CommandSender sender) {
        if (!PlayerCurrency.PLAYER_POINTS) {
            MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor(HookPluginEnum.PLAYER_POINTS.getFailMsg()));
            return;
        }
        String type = ImportTypeEnum.PLAYER_POINTS.getType();
        for (OfflinePlayer offlinePlayer : Bukkit.getOfflinePlayers()) {
            int playerPoints = PlayerPointsUtil.getPlayerPoints(offlinePlayer.getUniqueId());
            PlayerCurrencyApi.set(offlinePlayer.getUniqueId(), type, Long.valueOf(playerPoints), CurrencyUtil.getOperatorName(sender), "\u5bfc\u5165PlayerPoints\u6570\u636e");
        }
        HandyConfigUtil.setPathIsNotContains(ConfigUtil.CONFIG, "currency." + type, type, null, "config.yml");
    }

    private synchronized void importVault(CommandSender sender) {
        if (!VaultUtil.existEcon().booleanValue()) {
            MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor("vaultFailureMsg"));
            return;
        }
        String type = ImportTypeEnum.VAULT.getType();
        for (OfflinePlayer offlinePlayer : Bukkit.getOfflinePlayers()) {
            double playerVault = VaultUtil.getPlayerVault(offlinePlayer);
            PlayerCurrencyApi.set(offlinePlayer.getUniqueId(), type, (long)playerVault, CurrencyUtil.getOperatorName(sender), "\u5bfc\u5165Vault\u6570\u636e");
        }
        HandyConfigUtil.setPathIsNotContains(ConfigUtil.CONFIG, "currency." + type, type, null, "config.yml");
    }

    private synchronized void importGemsEconomy(CommandSender sender) {
        if (PlayerCurrency.GEMS_ECONOMY == null) {
            MessageUtil.sendMessage(sender, "not fount GemsEconomy");
            return;
        }
        HashSet<String> typeSet = new HashSet<String>();
        List allAccounts = PlayerCurrency.GEMS_ECONOMY.getAccountManager().getAllAccounts();
        for (Account account : allAccounts) {
            Map accountBalances = account.getBalances();
            for (Currency currency : accountBalances.keySet()) {
                String type = StrUtil.isNotEmpty(currency.getPlural()) ? currency.getPlural() : String.valueOf(currency.getUuid());
                typeSet.add(type);
                PlayerCurrencyApi.set(account.getUuid(), type, ((Double)accountBalances.get(currency)).longValue(), CurrencyUtil.getOperatorName(sender), "\u5bfc\u5165GemsEconomy\u6570\u636e");
            }
        }
        for (String type : typeSet) {
            HandyConfigUtil.setPathIsNotContains(ConfigUtil.CONFIG, "currency." + type, type, null, "config.yml");
        }
    }

    private Map<String, Long> convert(String jsonString) {
        JsonObject jsonObject = JsonUtil.toBean(jsonString, JsonObject.class);
        JsonArray currencyList = jsonObject.getAsJsonArray("currencys");
        HashMap<String, Long> map = MapUtil.newHashMapWithExpectedSize(currencyList.size());
        for (int i = 0; i < currencyList.size(); ++i) {
            JsonObject obj = currencyList.get(i).getAsJsonObject();
            String type = obj.get("type").getAsString();
            long count = obj.get("count").getAsLong();
            map.put(type, count);
        }
        return map;
    }
}

