/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.currency.command.admin;

import cn.handyplus.currency.constants.CurrencyType;
import cn.handyplus.currency.enter.PlayerCurrencyLogEnter;
import cn.handyplus.currency.lib.command.IHandyCommandEvent;
import cn.handyplus.currency.lib.core.CollUtil;
import cn.handyplus.currency.lib.core.DateUtil;
import cn.handyplus.currency.lib.core.MapUtil;
import cn.handyplus.currency.lib.db.Page;
import cn.handyplus.currency.lib.util.AssertUtil;
import cn.handyplus.currency.lib.util.BaseUtil;
import cn.handyplus.currency.lib.util.MessageUtil;
import cn.handyplus.currency.service.PlayerCurrencyLogService;
import cn.handyplus.currency.util.CurrencyUtil;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

public class LogCommand
implements IHandyCommandEvent {
    @Override
    public String command() {
        return "log";
    }

    @Override
    public String permission() {
        return "playerCurrency.log";
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void onCommand(CommandSender sender, Command command, String s, String[] args) {
        AssertUtil.notTrue(args.length < 3, BaseUtil.getMsgNotColor("paramFailureMsg"));
        UUID playerUuid = CurrencyUtil.getPlayerUuid(sender, args[1]);
        if (playerUuid == null) {
            return;
        }
        String type = args[2];
        AssertUtil.isTrue(CurrencyType.exist(type), BaseUtil.getMsgNotColor("typeFailureMsg"));
        Integer pageNum = 1;
        if (args.length > 3) {
            pageNum = AssertUtil.isNumericToInt(args[3], BaseUtil.getMsgNotColor("amountFailureMsg"));
            pageNum = pageNum > 0 ? pageNum : 1;
        }
        String oneMsg = ChatColor.GRAY + "_________________/ &e" + args[1] + "(" + pageNum + ")" + ChatColor.GRAY + " \\ _________________ ";
        MessageUtil.sendMessage(sender, oneMsg);
        Page<PlayerCurrencyLogEnter> page = PlayerCurrencyLogService.getInstance().page(playerUuid, type, pageNum, 10);
        if (CollUtil.isEmpty(page.getRecords())) {
            MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor("notDataMsg"));
            return;
        }
        for (PlayerCurrencyLogEnter record : page.getRecords()) {
            HashMap<String, String> map = MapUtil.newHashMapWithExpectedSize(7);
            map.put("${time}", DateUtil.format(record.getOperatorTime(), "yyyy-MM-dd HH:mm:ss"));
            map.put("${name}", record.getOperatorName());
            map.put("${type}", CurrencyType.getDesc(record.getType()));
            map.put("${oldBalance}", record.getOldBalance().toString());
            map.put("${change}", record.getChange().toString());
            map.put("${balance}", record.getBalance().toString());
            map.put("${reason}", record.getOperatorReason());
            String logMsg = BaseUtil.getMsgNotColor("logMsg", map);
            MessageUtil.sendMessage(sender, logMsg);
        }
    }
}

