/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.currency.command.admin;

import cn.handyplus.currency.api.PlayerCurrencyApi;
import cn.handyplus.currency.constants.CurrencyType;
import cn.handyplus.currency.lib.command.IHandyCommandEvent;
import cn.handyplus.currency.lib.core.MapUtil;
import cn.handyplus.currency.lib.util.AssertUtil;
import cn.handyplus.currency.lib.util.BaseUtil;
import cn.handyplus.currency.lib.util.MessageUtil;
import cn.handyplus.currency.util.CurrencyUtil;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

public class LookTotalCommand
implements IHandyCommandEvent {
    @Override
    public String command() {
        return "lookTotal";
    }

    @Override
    public String permission() {
        return "playerCurrency.lookTotal";
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void onCommand(CommandSender sender, Command command, String s, String[] args) {
        AssertUtil.notTrue(args.length < 3, BaseUtil.getMsgNotColor("paramFailureMsg"));
        UUID playerUuid = CurrencyUtil.getPlayerUuid(sender, args[1]);
        if (playerUuid == null) {
            return;
        }
        String type = args[2];
        AssertUtil.isTrue(CurrencyType.exist(type), BaseUtil.getMsgNotColor("typeFailureMsg"));
        Long number = PlayerCurrencyApi.lookTotal(playerUuid, type);
        HashMap<String, String> map = MapUtil.of("${type}", CurrencyType.getDesc(type), "${number}", String.valueOf(number));
        MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor("lookTotalMsg", map));
    }
}

