/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.currency.command.admin;

import cn.handyplus.currency.api.PlayerCurrencyApi;
import cn.handyplus.currency.constants.CurrencyType;
import cn.handyplus.currency.lib.command.IHandyCommandEvent;
import cn.handyplus.currency.lib.core.MapUtil;
import cn.handyplus.currency.lib.util.AssertUtil;
import cn.handyplus.currency.lib.util.BaseUtil;
import cn.handyplus.currency.lib.util.MessageUtil;
import cn.handyplus.currency.util.CurrencyUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class SetAllCommand
implements IHandyCommandEvent {
    @Override
    public String command() {
        return "setALl";
    }

    @Override
    public String permission() {
        return "playerCurrency.setALl";
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void onCommand(CommandSender sender, Command command, String s, String[] args) {
        AssertUtil.notTrue(args.length < 3, BaseUtil.getMsgNotColor("paramFailureMsg"));
        String type = args[1];
        AssertUtil.isTrue(CurrencyType.exist(type), BaseUtil.getMsgNotColor("typeFailureMsg"));
        Long amount = AssertUtil.isNumericToLong(args[2], BaseUtil.getMsgNotColor("amountFailureMsg"));
        String operatorReason = args.length > 3 ? args[3] : "setALl";
        ArrayList<Player> onlinePlayers = new ArrayList<Player>(Bukkit.getOnlinePlayers());
        List<UUID> playerUuidList = onlinePlayers.stream().map(Entity::getUniqueId).collect(Collectors.toList());
        boolean rst = PlayerCurrencyApi.set(playerUuidList, MapUtil.of(type, amount), CurrencyUtil.getOperatorName(sender), operatorReason);
        MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor(rst ? "succeedMsg" : "failureMsg"));
        if (rst) {
            this.sendPlayerTip(onlinePlayers, type, amount, operatorReason);
        }
    }

    private void sendPlayerTip(List<Player> onlinePlayers, String type, Long amount, String operatorReason) {
        for (Player onlinePlayer : onlinePlayers) {
            HashMap<String, String> map = MapUtil.newHashMapWithExpectedSize(4);
            map.put("${type}", CurrencyType.getDesc(type));
            map.put("${amount}", String.valueOf(amount));
            map.put("${balance}", PlayerCurrencyApi.look(onlinePlayer.getUniqueId(), type).toString());
            map.put("${operatorReason}", operatorReason);
            MessageUtil.sendMessage(onlinePlayer, BaseUtil.getMsgNotColor("setPlayerMsg", map));
        }
    }
}

