/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.currency.event;

import java.util.UUID;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.jetbrains.annotations.NotNull;

public class PlayerCurrencyChangeSuccessEvent
extends Event {
    private static final HandlerList HANDLERS = new HandlerList();
    private final UUID playerUuid;
    private final String type;
    private final Long change;
    private Long balance;
    private final String operatorName;
    private final String operatorReason;

    public PlayerCurrencyChangeSuccessEvent(@NotNull UUID playerUuid, @NotNull String type, @NotNull Long change, @NotNull Long balance) {
        super(!Bukkit.isPrimaryThread());
        this.playerUuid = playerUuid;
        this.type = type;
        this.change = change;
        this.balance = balance;
        this.operatorName = null;
        this.operatorReason = null;
    }

    public PlayerCurrencyChangeSuccessEvent(@NotNull UUID playerUuid, @NotNull String type, @NotNull Long change, @NotNull Long balance, String operatorName, String operatorReason) {
        super(!Bukkit.isPrimaryThread());
        this.playerUuid = playerUuid;
        this.type = type;
        this.change = change;
        this.balance = balance;
        this.operatorName = operatorName;
        this.operatorReason = operatorReason;
    }

    public static HandlerList getHandlerList() {
        return HANDLERS;
    }

    @NotNull
    public HandlerList getHandlers() {
        return HANDLERS;
    }

    public static void callEvent(@NotNull UUID playerUuid, @NotNull String type, @NotNull Long change, @NotNull Long balance, String operatorName, String reason) {
        Bukkit.getServer().getPluginManager().callEvent((Event)new PlayerCurrencyChangeSuccessEvent(playerUuid, type, change, balance, operatorName, reason));
    }

    @Generated
    public UUID getPlayerUuid() {
        return this.playerUuid;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public Long getChange() {
        return this.change;
    }

    @Generated
    public Long getBalance() {
        return this.balance;
    }

    @Generated
    public String getOperatorName() {
        return this.operatorName;
    }

    @Generated
    public String getOperatorReason() {
        return this.operatorReason;
    }

    @Generated
    public void setBalance(Long balance) {
        this.balance = balance;
    }
}

