/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.currency.hook;

import cn.handyplus.currency.PlayerCurrency;
import cn.handyplus.currency.api.PlayerCurrencyApi;
import cn.handyplus.currency.lib.util.BaseUtil;
import cn.handyplus.currency.util.CurrencyUtil;
import java.util.ArrayList;
import java.util.List;
import net.milkbowl.vault.economy.AbstractEconomy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.OfflinePlayer;

public class VaultBridge
extends AbstractEconomy {
    private final String currency;

    public VaultBridge(String currency) {
        this.currency = currency;
    }

    public boolean isEnabled() {
        return true;
    }

    public String getName() {
        return PlayerCurrency.INSTANCE.getDescription().getName();
    }

    public boolean hasBankSupport() {
        return false;
    }

    public int fractionalDigits() {
        return 0;
    }

    public String format(double amount) {
        return String.format("%.0f", amount);
    }

    public String currencyNamePlural() {
        return PlayerCurrencyApi.getDesc(this.currency);
    }

    public String currencyNameSingular() {
        return PlayerCurrencyApi.getDesc(this.currency);
    }

    public boolean hasAccount(String playerName) {
        return true;
    }

    public boolean hasAccount(OfflinePlayer player) {
        return true;
    }

    public boolean hasAccount(String playerName, String worldName) {
        return true;
    }

    public boolean hasAccount(OfflinePlayer player, String worldName) {
        return true;
    }

    public double getBalance(String playerName) {
        return this.getBalance(BaseUtil.getOfflinePlayer(playerName));
    }

    public double getBalance(OfflinePlayer player) {
        return PlayerCurrencyApi.look(player.getUniqueId(), this.currency).longValue();
    }

    public double getBalance(String playerName, String world) {
        return this.getBalance(playerName);
    }

    public boolean has(String playerName, double amount) {
        return this.getBalance(playerName) >= amount;
    }

    public boolean has(OfflinePlayer player, double amount) {
        return this.getBalance(player) >= amount;
    }

    public boolean has(String playerName, String worldName, double amount) {
        return this.getBalance(playerName) >= amount;
    }

    public EconomyResponse withdrawPlayer(String playerName, double amount) {
        return this.withdrawPlayer(BaseUtil.getOfflinePlayer(playerName), amount);
    }

    public EconomyResponse withdrawPlayer(OfflinePlayer player, double amount) {
        if (amount < 0.0) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "\u6570\u5b57\u5c0f\u4e8e0");
        }
        boolean result = PlayerCurrencyApi.take(player.getUniqueId(), this.currency, (long)amount, "Vault", CurrencyUtil.getOperatorReason());
        Long balance = PlayerCurrencyApi.look(player.getUniqueId(), this.currency);
        return new EconomyResponse(amount, (double)balance.longValue(), result ? EconomyResponse.ResponseType.SUCCESS : EconomyResponse.ResponseType.FAILURE, "\u4f59\u989d\u4e0d\u8db3");
    }

    public EconomyResponse withdrawPlayer(String playerName, String worldName, double amount) {
        return this.withdrawPlayer(playerName, amount);
    }

    public EconomyResponse withdrawPlayer(OfflinePlayer player, String worldName, double amount) {
        return this.withdrawPlayer(player, amount);
    }

    public EconomyResponse depositPlayer(String playerName, double amount) {
        return this.depositPlayer(BaseUtil.getOfflinePlayer(playerName), amount);
    }

    public EconomyResponse depositPlayer(OfflinePlayer player, double amount) {
        if (amount < 0.0) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "\u6570\u5b57\u5c0f\u4e8e0");
        }
        boolean result = PlayerCurrencyApi.give(player.getUniqueId(), this.currency, (long)amount, "Vault", CurrencyUtil.getOperatorReason());
        Long balance = PlayerCurrencyApi.look(player.getUniqueId(), this.currency);
        return new EconomyResponse(amount, (double)balance.longValue(), result ? EconomyResponse.ResponseType.SUCCESS : EconomyResponse.ResponseType.FAILURE, "\u51fa\u73b0\u5f02\u5e38");
    }

    public EconomyResponse depositPlayer(String playerName, String worldName, double amount) {
        return this.depositPlayer(playerName, amount);
    }

    public EconomyResponse depositPlayer(OfflinePlayer player, String worldName, double amount) {
        return this.depositPlayer(player, amount);
    }

    public EconomyResponse createBank(String name, String player) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "\u76ee\u524d\u6ca1\u6709\u94f6\u884c\u529f\u80fd");
    }

    public EconomyResponse createBank(String name, OfflinePlayer player) {
        return this.createBank(name, player.getName());
    }

    public EconomyResponse deleteBank(String name) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "\u76ee\u524d\u6ca1\u6709\u94f6\u884c\u529f\u80fd");
    }

    public EconomyResponse bankBalance(String name) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "\u76ee\u524d\u6ca1\u6709\u94f6\u884c\u529f\u80fd");
    }

    public EconomyResponse bankHas(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "\u76ee\u524d\u6ca1\u6709\u94f6\u884c\u529f\u80fd");
    }

    public EconomyResponse bankWithdraw(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "\u76ee\u524d\u6ca1\u6709\u94f6\u884c\u529f\u80fd");
    }

    public EconomyResponse bankDeposit(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "\u76ee\u524d\u6ca1\u6709\u94f6\u884c\u529f\u80fd");
    }

    public EconomyResponse isBankOwner(String name, String playerName) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "\u76ee\u524d\u6ca1\u6709\u94f6\u884c\u529f\u80fd");
    }

    public EconomyResponse isBankMember(String name, String playerName) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "\u76ee\u524d\u6ca1\u6709\u94f6\u884c\u529f\u80fd");
    }

    public List<String> getBanks() {
        return new ArrayList<String>();
    }

    public boolean createPlayerAccount(String playerName) {
        return false;
    }

    public boolean createPlayerAccount(OfflinePlayer player) {
        return this.createPlayerAccount(player.getName());
    }

    public boolean createPlayerAccount(String playerName, String worldName) {
        return this.createPlayerAccount(playerName);
    }

    public boolean createPlayerAccount(OfflinePlayer player, String worldName) {
        return this.createPlayerAccount(player.getName());
    }
}

