/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.currency.hook;

import cn.handyplus.currency.PlayerCurrency;
import cn.handyplus.currency.constants.CurrencyType;
import cn.handyplus.currency.hook.VaultBridge;
import cn.handyplus.currency.lib.core.MapUtil;
import cn.handyplus.currency.lib.core.StrUtil;
import cn.handyplus.currency.lib.util.BaseUtil;
import cn.handyplus.currency.lib.util.MessageUtil;
import cn.handyplus.currency.util.ConfigUtil;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.ServicePriority;

public class VaultUtil {
    private static VaultBridge VAULT_BRIDGE;
    private static Economy ECON;

    private VaultUtil() {
    }

    public static void unregister() {
        if (!PlayerCurrency.USE_VAULT) {
            return;
        }
        if (VAULT_BRIDGE != null) {
            Bukkit.getServicesManager().unregister(Economy.class, (Object)VAULT_BRIDGE);
        }
    }

    public static void register() {
        if (!PlayerCurrency.USE_VAULT) {
            return;
        }
        String type = ConfigUtil.CONFIG.getString("vaultBridge");
        if (StrUtil.isNotEmpty(type) && CurrencyType.exist(type)) {
            VAULT_BRIDGE = new VaultBridge(type);
            Bukkit.getServicesManager().register(Economy.class, (Object)VAULT_BRIDGE, (Plugin)PlayerCurrency.INSTANCE, ServicePriority.Highest);
            MessageUtil.sendConsoleMessage(BaseUtil.getMsgNotColor("vaultBridgeMsg", MapUtil.of("${type}", CurrencyType.getDesc(type))));
        } else {
            RegisteredServiceProvider rsp = Bukkit.getServer().getServicesManager().getRegistration(Economy.class);
            if (rsp != null) {
                ECON = (Economy)rsp.getProvider();
            }
        }
    }

    public static Boolean existEcon() {
        return ECON != null;
    }

    public static double getPlayerVault(OfflinePlayer player) {
        if (ECON == null || player == null) {
            return 0.0;
        }
        return ECON.getBalance(player);
    }
}

