/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.currency.lib.constants;

import cn.handyplus.currency.lib.constants.BaseConstants;
import cn.handyplus.currency.lib.constants.VersionCheckEnum;
import cn.handyplus.currency.lib.core.CollUtil;
import cn.handyplus.currency.lib.core.MapUtil;
import cn.handyplus.currency.lib.util.ItemStackUtil;
import cn.handyplus.currency.lib.util.LegacyUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public enum AttributeCompatEnum {
    MAX_HEALTH("MAX_HEALTH", "GENERIC_MAX_HEALTH", "\u751f\u7269\u7684\u6700\u5927\u8840\u91cf"),
    FOLLOW_RANGE("FOLLOW_RANGE", "GENERIC_FOLLOW_RANGE", "\u5f53\u4e00\u4e2a\u751f\u7269\u6b63\u5728\u8ddf\u968f\u5176\u4ed6\u751f\u7269/\u4eba\u7684\u65f6\u5019\u7684\u8ddf\u968f\u8303\u56f4"),
    KNOCKBACK_RESISTANCE("KNOCKBACK_RESISTANCE", "GENERIC_KNOCKBACK_RESISTANCE", "\u5f53\u751f\u7269\u88ab\u653b\u51fb\u7684\u65f6\u5019\u7684\u51fb\u9000\u6297\u6027"),
    MOVEMENT_SPEED("MOVEMENT_SPEED", "GENERIC_MOVEMENT_SPEED", "\u751f\u7269\u7684\u79fb\u52a8\u901f\u5ea6"),
    FLYING_SPEED("FLYING_SPEED", "GENERIC_FLYING_SPEED", "\u5b9e\u4f53\u7684\u98de\u884c\u901f\u5ea6"),
    ATTACK_DAMAGE("ATTACK_DAMAGE", "GENERIC_ATTACK_DAMAGE", "\u5f53\u751f\u7269\u653b\u51fb\u5176\u4ed6\u751f\u7269/\u5b9e\u4f53\u65f6\u6240\u9020\u6210\u7684\u4f24\u5bb3"),
    ATTACK_KNOCKBACK("ATTACK_KNOCKBACK", "GENERIC_ATTACK_KNOCKBACK", "\u751f\u7269\u7684\u653b\u51fb\u51fb\u9000\u529b\u5ea6"),
    ATTACK_SPEED("ATTACK_SPEED", "GENERIC_ATTACK_SPEED", "\u751f\u7269\u7684\u653b\u51fb\u901f\u7387"),
    ARMOR("ARMOR", "GENERIC_ARMOR", "\u62a4\u7532\u7684\u9632\u5fa1\u503c"),
    ARMOR_TOUGHNESS("ARMOR_TOUGHNESS", "GENERIC_ARMOR_TOUGHNESS", "\u62a4\u7532\u7684\u97e7\u6027"),
    FALL_DAMAGE_MULTIPLIER("FALL_DAMAGE_MULTIPLIER", "GENERIC_FALL_DAMAGE_MULTIPLIER", "\u5b9e\u4f53\u7684\u5760\u843d\u4f24\u5bb3\u500d\u589e\u5668"),
    LUCK("LUCK", "GENERIC_LUCK", "\u751f\u7269\u7684\u53ef\u80fd\u7684\u6389\u843d\u7269"),
    MAX_ABSORPTION("MAX_ABSORPTION", "GENERIC_MAX_ABSORPTION", "\u5b9e\u4f53\u7684\u6700\u5927\u5438\u6536\u503c\uff08\u5373\u62a4\u7532\u5438\u6536\uff09"),
    SAFE_FALL_DISTANCE("SAFE_FALL_DISTANCE", "GENERIC_SAFE_FALL_DISTANCE", "\u5b9e\u4f53\u53ef\u4ee5\u5760\u843d\u800c\u4e0d\u53d7\u4f24\u5bb3\u7684\u9ad8\u5ea6"),
    SCALE("SCALE", "GENERIC_SCALE", "\u5b9e\u4f53\u7684\u76f8\u5bf9\u5927\u5c0f"),
    STEP_HEIGHT("STEP_HEIGHT", "GENERIC_STEP_HEIGHT", "\u5b9e\u4f53\u53ef\u4ee5\u8de8\u8d8a\u7684\u9ad8\u5ea6"),
    GRAVITY("GRAVITY", "GENERIC_GRAVITY", "\u65bd\u52a0\u5728\u5b9e\u4f53\u4e0a\u7684\u91cd\u529b"),
    JUMP_STRENGTH("JUMP_STRENGTH", "GENERIC_JUMP_STRENGTH", "\u5b9e\u4f53\u8df3\u8dc3\u7684\u529b\u91cf"),
    BURNING_TIME("BURNING_TIME", "GENERIC_BURNING_TIME", "\u5b9e\u4f53\u5728\u7740\u706b\u540e\u4fdd\u6301\u71c3\u70e7\u7684\u65f6\u95f4"),
    EXPLOSION_KNOCKBACK_RESISTANCE("EXPLOSION_KNOCKBACK_RESISTANCE", "GENERIC_EXPLOSION_KNOCKBACK_RESISTANCE", "\u5bf9\u7206\u70b8\u9020\u6210\u7684\u51fb\u9000\u7684\u6297\u6027"),
    MOVEMENT_EFFICIENCY("MOVEMENT_EFFICIENCY", "GENERIC_MOVEMENT_EFFICIENCY", "\u5728\u56f0\u96be\u5730\u5f62\u4e2d\u7684\u79fb\u52a8\u901f\u5ea6"),
    OXYGEN_BONUS("OXYGEN_BONUS", "GENERIC_OXYGEN_BONUS", "\u6c34\u4e0b\u4f7f\u7528\u7684\u6c27\u6c14"),
    WATER_MOVEMENT_EFFICIENCY("WATER_MOVEMENT_EFFICIENCY", "GENERIC_WATER_MOVEMENT_EFFICIENCY", "\u5728\u6c34\u4e2d\u79fb\u52a8\u7684\u901f\u5ea6"),
    TEMPT_RANGE("TEMPT_RANGE", "GENERIC_TEMPT_RANGE", "\u751f\u7269\u53d7\u8bf1\u5bfc\u8303\u56f4"),
    BLOCK_INTERACTION_RANGE("BLOCK_INTERACTION_RANGE", "PLAYER_BLOCK_INTERACTION_RANGE", "\u73a9\u5bb6\u53ef\u4ee5\u89e6\u53ca\u7684\u65b9\u5757\u8ddd\u79bb"),
    ENTITY_INTERACTION_RANGE("ENTITY_INTERACTION_RANGE", "PLAYER_ENTITY_INTERACTION_RANGE", "\u73a9\u5bb6\u53ef\u4ee5\u89e6\u53ca\u7684\u5b9e\u4f53\u8ddd\u79bb"),
    BLOCK_BREAK_SPEED("BLOCK_BREAK_SPEED", "PLAYER_BLOCK_BREAK_SPEED", "\u73a9\u5bb6\u7834\u574f\u65b9\u5757\u7684\u901f\u5ea6"),
    MINING_EFFICIENCY("MINING_EFFICIENCY", "PLAYER_MINING_EFFICIENCY", "\u6b63\u786e\u5de5\u5177\u7684\u6316\u77ff\u901f\u5ea6"),
    SNEAKING_SPEED("SNEAKING_SPEED", "PLAYER_SNEAKING_SPEED", "\u6f5c\u884c\u901f\u5ea6"),
    SUBMERGED_MINING_SPEED("SUBMERGED_MINING_SPEED", "PLAYER_SUBMERGED_MINING_SPEED", "\u6c34\u4e0b\u6316\u6398\u901f\u5ea6"),
    SWEEPING_DAMAGE_RATIO("SWEEPING_DAMAGE_RATIO", "PLAYER_SWEEPING_DAMAGE_RATIO", "\u6a2a\u626b\u4f24\u5bb3"),
    SPAWN_REINFORCEMENTS("SPAWN_REINFORCEMENTS", "ZOMBIE_SPAWN_REINFORCEMENTS", "\u50f5\u5c38\u589e\u63f4\u7684\u51e0\u7387"),
    WAYPOINT_TRANSMIT_RANGE("WAYPOINT_TRANSMIT_RANGE", "", "\u5b9e\u4f53\u4f20\u9001\u8def\u5f84\u70b9\u7684\u6700\u5927\u4f20\u8f93\u8303\u56f4"),
    WAYPOINT_RECEIVE_RANGE("WAYPOINT_RECEIVE_RANGE", "", "\u5b9e\u4f53\u63a5\u6536\u8def\u5f84\u70b9\u66f4\u65b0\u7684\u6700\u5927\u8303\u56f4");

    private final String newName;
    private final String oldName;
    private final String desc;

    public Attribute resolve() {
        return LegacyUtil.getAttribute(BaseConstants.VERSION_ID < VersionCheckEnum.V_1_21_3.getVersionId() ? this.oldName : this.newName);
    }

    public static AttributeCompatEnum getByName(@NotNull String name) {
        name = name.toUpperCase();
        for (AttributeCompatEnum attributeCompatEnum : AttributeCompatEnum.values()) {
            if (!attributeCompatEnum.getOldName().equalsIgnoreCase(name)) continue;
            return attributeCompatEnum;
        }
        return AttributeCompatEnum.valueOf(name);
    }

    public static void setAttributeModifier(@NotNull Map<EquipmentSlot, Map<String, Double>> slotAttrList, @NotNull ItemStack itemStack) {
        AttributeCompatEnum.modifyAttributes(slotAttrList, itemStack, true);
    }

    public static void addAttributeModifier(@NotNull Map<EquipmentSlot, Map<String, Double>> slotAttrList, @NotNull ItemStack itemStack) {
        AttributeCompatEnum.modifyAttributes(slotAttrList, itemStack, false);
    }

    private static void modifyAttributes(@NotNull Map<EquipmentSlot, Map<String, Double>> slotAttrList, @NotNull ItemStack itemStack, boolean removeOld) {
        if (MapUtil.isEmpty(slotAttrList)) {
            return;
        }
        ItemMeta itemMeta = ItemStackUtil.getItemMeta(itemStack);
        for (Map.Entry<EquipmentSlot, Map<String, Double>> slotEntry : slotAttrList.entrySet()) {
            EquipmentSlot equipmentSlot = slotEntry.getKey();
            Map<String, Double> attrMap = slotEntry.getValue();
            for (Map.Entry<String, Double> attrEntry : attrMap.entrySet()) {
                List<AttributeModifier> addNumberModifiers;
                Collection existingModifiers;
                String attr = attrEntry.getKey();
                Double value = attrEntry.getValue();
                Attribute attribute = AttributeCompatEnum.getByName(attr).resolve();
                if (removeOld) {
                    itemMeta.removeAttributeModifier(attribute);
                }
                if (CollUtil.isNotEmpty(existingModifiers = itemMeta.getAttributeModifiers(attribute)) && CollUtil.isNotEmpty(addNumberModifiers = existingModifiers.stream().filter(mod -> mod.getOperation() == AttributeModifier.Operation.ADD_NUMBER).collect(Collectors.toList()))) {
                    double existingValue = addNumberModifiers.stream().mapToDouble(AttributeModifier::getAmount).sum();
                    addNumberModifiers.forEach(mod -> itemMeta.removeAttributeModifier(attribute, mod));
                    value = value + existingValue;
                }
                value = new BigDecimal(value).setScale(2, RoundingMode.HALF_UP).doubleValue();
                AttributeModifier attributeModifier = LegacyUtil.getAttributeModifier(attr, value, AttributeModifier.Operation.ADD_NUMBER, equipmentSlot);
                itemMeta.addAttributeModifier(attribute, attributeModifier);
            }
        }
        itemStack.setItemMeta(itemMeta);
    }

    @Generated
    public String getNewName() {
        return this.newName;
    }

    @Generated
    public String getOldName() {
        return this.oldName;
    }

    @Generated
    public String getDesc() {
        return this.desc;
    }

    @Generated
    private AttributeCompatEnum(String newName, String oldName, String desc) {
        this.newName = newName;
        this.oldName = oldName;
        this.desc = desc;
    }
}

