/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.currency.lib.expand.adapter;

import cn.handyplus.currency.lib.expand.adapter.BukkitScheduler;
import cn.handyplus.currency.lib.expand.adapter.FoliaScheduler;
import cn.handyplus.currency.lib.expand.adapter.HandyRunnable;
import cn.handyplus.currency.lib.expand.adapter.ServerTypeEnum;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class HandySchedulerUtil {
    protected static Plugin BUKKIT_PLUGIN;
    private static ServerTypeEnum SERVER_TYPE;

    private HandySchedulerUtil() {
    }

    public static void init(@NotNull Plugin plugin) {
        BUKKIT_PLUGIN = plugin;
        SERVER_TYPE = ServerTypeEnum.getServerType();
    }

    public static void runTask(@NotNull Runnable task) {
        if (HandySchedulerUtil.isFolia()) {
            FoliaScheduler.runTask(task);
            return;
        }
        BukkitScheduler.runTask(task);
    }

    public static void runTaskLater(@NotNull Runnable task, long delay) {
        if (HandySchedulerUtil.isFolia()) {
            FoliaScheduler.runTaskLater(task, delay);
            return;
        }
        BukkitScheduler.runTaskLater(task, delay);
    }

    public static void runTaskLater(@NotNull HandyRunnable task, long delay) {
        if (HandySchedulerUtil.isFolia()) {
            FoliaScheduler.runTaskLater(task, delay);
            return;
        }
        BukkitScheduler.runTaskLater(task, delay);
    }

    public static void runTaskTimer(@NotNull Runnable task, long delay, long period) {
        if (HandySchedulerUtil.isFolia()) {
            FoliaScheduler.runTaskTimer(task, delay, period);
            return;
        }
        BukkitScheduler.runTaskTimer(task, delay, period);
    }

    public static void runTaskTimer(@NotNull HandyRunnable task, long delay, long period) {
        if (HandySchedulerUtil.isFolia()) {
            FoliaScheduler.runTaskTimer(task, delay, period);
            return;
        }
        BukkitScheduler.runTaskTimer(task, delay, period);
    }

    public static void runTaskAsynchronously(@NotNull Runnable task) {
        if (HandySchedulerUtil.isFolia()) {
            FoliaScheduler.runTaskAsynchronously(task);
            return;
        }
        BukkitScheduler.runTaskAsynchronously(task);
    }

    public static void runTaskLaterAsynchronously(@NotNull Runnable task, long delay) {
        if (HandySchedulerUtil.isFolia()) {
            FoliaScheduler.runTaskLaterAsynchronously(task, delay);
            return;
        }
        BukkitScheduler.runTaskLaterAsynchronously(task, delay);
    }

    public static void runTaskLaterAsynchronously(@NotNull HandyRunnable task, long delay) {
        if (HandySchedulerUtil.isFolia()) {
            FoliaScheduler.runTaskLaterAsynchronously(task, delay);
            return;
        }
        BukkitScheduler.runTaskLaterAsynchronously(task, delay);
    }

    public static void runTaskTimerAsynchronously(@NotNull Runnable task, long delay, long period) {
        if (HandySchedulerUtil.isFolia()) {
            FoliaScheduler.runTaskTimerAsynchronously(task, delay, period);
            return;
        }
        BukkitScheduler.runTaskTimerAsynchronously(task, delay, period);
    }

    public static void runTaskTimerAsynchronously(@NotNull HandyRunnable task, long delay, long period) {
        if (HandySchedulerUtil.isFolia()) {
            FoliaScheduler.runTaskTimerAsynchronously(task, delay, period);
            return;
        }
        BukkitScheduler.runTaskTimerAsynchronously(task, delay, period);
    }

    public static void cancelTask() {
        if (HandySchedulerUtil.isFolia()) {
            FoliaScheduler.cancelTask();
        } else {
            BukkitScheduler.cancelTask();
        }
    }

    public static boolean isFolia() {
        return ServerTypeEnum.FOLIA.equals((Object)SERVER_TYPE);
    }
}

