/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.currency.listener;

import cn.handyplus.currency.api.PlayerCurrencyApi;
import cn.handyplus.currency.enter.PlayerCurrencyLogEnter;
import cn.handyplus.currency.event.PlayerCurrencyChangeSuccessEvent;
import cn.handyplus.currency.lib.annotation.HandyListener;
import cn.handyplus.currency.lib.expand.adapter.HandySchedulerUtil;
import cn.handyplus.currency.lib.util.BaseUtil;
import cn.handyplus.currency.service.PlayerCurrencyLogService;
import java.util.Date;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

@HandyListener
public class PlayerCurrencyListener
implements Listener {
    @EventHandler
    public void onEvent(PlayerCurrencyChangeSuccessEvent event) {
        HandySchedulerUtil.runTaskAsynchronously(() -> {
            OfflinePlayer offlinePlayer = BaseUtil.getOfflinePlayer(event.getPlayerUuid());
            PlayerCurrencyLogEnter logEnter = new PlayerCurrencyLogEnter();
            logEnter.setPlayerName(offlinePlayer.getName());
            logEnter.setPlayerUuid(offlinePlayer.getUniqueId());
            logEnter.setType(event.getType());
            logEnter.setOldBalance(event.getBalance());
            logEnter.setChange(event.getChange());
            logEnter.setBalance(PlayerCurrencyApi.look(offlinePlayer.getUniqueId(), event.getType()));
            logEnter.setOperatorReason(event.getOperatorReason());
            logEnter.setOperatorName(event.getOperatorName());
            logEnter.setOperatorTime(new Date());
            PlayerCurrencyLogService.getInstance().add(logEnter);
        });
    }
}

