/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.currency.service;

import cn.handyplus.currency.enter.PlayerCurrencyLogEnter;
import cn.handyplus.currency.lib.core.StrUtil;
import cn.handyplus.currency.lib.db.Db;
import cn.handyplus.currency.lib.db.Page;
import java.util.UUID;

public class PlayerCurrencyLogService {
    private PlayerCurrencyLogService() {
    }

    public static PlayerCurrencyLogService getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public void add(PlayerCurrencyLogEnter enter) {
        Db.use(PlayerCurrencyLogEnter.class).execution().insert(enter);
    }

    public Page<PlayerCurrencyLogEnter> page(UUID playerUuid, String type, Integer pageNum, Integer pageSize) {
        Db<PlayerCurrencyLogEnter> use = Db.use(PlayerCurrencyLogEnter.class);
        use.where().eq(PlayerCurrencyLogEnter::getPlayerUuid, playerUuid).eq(StrUtil.isNotEmpty(type), PlayerCurrencyLogEnter::getType, type).limit(pageNum, pageSize).orderByDesc(PlayerCurrencyLogEnter::getOperatorTime);
        return use.execution().page();
    }

    public void deleteByType(String type) {
        Db<PlayerCurrencyLogEnter> db = Db.use(PlayerCurrencyLogEnter.class);
        db.where().eq(PlayerCurrencyLogEnter::getType, type);
        db.execution().delete();
    }

    private static class SingletonHolder {
        private static final PlayerCurrencyLogService INSTANCE = new PlayerCurrencyLogService();

        private SingletonHolder() {
        }
    }
}

