/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.currency.service;

import cn.handyplus.currency.enter.PlayerCurrencyEnter;
import cn.handyplus.currency.lib.core.CollUtil;
import cn.handyplus.currency.lib.core.StrUtil;
import cn.handyplus.currency.lib.db.Db;
import cn.handyplus.currency.lib.db.Page;
import cn.handyplus.currency.lib.db.Tx;
import cn.handyplus.currency.lib.util.BaseUtil;
import cn.handyplus.currency.lib.util.MessageUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.bukkit.OfflinePlayer;

public class PlayerCurrencyService {
    private PlayerCurrencyService() {
    }

    public static PlayerCurrencyService getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public Page<PlayerCurrencyEnter> page(String type, Integer pageNum, Integer pageSize) {
        Db<PlayerCurrencyEnter> db = Db.use(PlayerCurrencyEnter.class);
        db.where().eq(PlayerCurrencyEnter::getType, type).limit(pageNum, pageSize).orderByDesc(PlayerCurrencyEnter::getBalance);
        return db.execution().page();
    }

    public Optional<PlayerCurrencyEnter> findByPlayerUuid(UUID playerUuid, String type) {
        Db<PlayerCurrencyEnter> use = Db.use(PlayerCurrencyEnter.class);
        use.where().eq(PlayerCurrencyEnter::getPlayerUuid, playerUuid).eq(PlayerCurrencyEnter::getType, type);
        return use.execution().selectOne();
    }

    public List<PlayerCurrencyEnter> findByPlayerUuidListAndType(List<UUID> playerUuidList, String type) {
        Db<PlayerCurrencyEnter> use = Db.use(PlayerCurrencyEnter.class);
        use.where().in(PlayerCurrencyEnter::getPlayerUuid, playerUuidList).eq(PlayerCurrencyEnter::getType, type);
        return use.execution().list();
    }

    public List<PlayerCurrencyEnter> findByPlayerUuidAndTypeList(UUID playerUuid, List<String> typeList) {
        Db<PlayerCurrencyEnter> use = Db.use(PlayerCurrencyEnter.class);
        use.where().eq(PlayerCurrencyEnter::getPlayerUuid, playerUuid).in(PlayerCurrencyEnter::getType, typeList);
        return use.execution().list();
    }

    public List<PlayerCurrencyEnter> findAll() {
        return Db.use(PlayerCurrencyEnter.class).execution().list();
    }

    public void deleteByType(String type) {
        Db<PlayerCurrencyEnter> db = Db.use(PlayerCurrencyEnter.class);
        db.where().eq(PlayerCurrencyEnter::getType, type);
        db.execution().delete();
    }

    public boolean give(List<UUID> playerUuidList, Map<String, Long> currencyChangeMap) {
        AtomicBoolean result = new AtomicBoolean(false);
        Tx.use().tx(tx -> {
            for (String type : currencyChangeMap.keySet()) {
                Long amount = (Long)currencyChangeMap.get(type);
                for (UUID playerUuid : playerUuidList) {
                    boolean rst;
                    Db<PlayerCurrencyEnter> use = Db.use(PlayerCurrencyEnter.class);
                    use.update().add(PlayerCurrencyEnter::getBalance, PlayerCurrencyEnter::getBalance, amount).add(PlayerCurrencyEnter::getTotal, PlayerCurrencyEnter::getTotal, amount);
                    use.where().eq(PlayerCurrencyEnter::getPlayerUuid, playerUuid).eq(PlayerCurrencyEnter::getType, type);
                    boolean bl = rst = use.execution(tx.getConn()).update() > 0;
                    if (rst) {
                        result.set(true);
                        continue;
                    }
                    result.set(false);
                    MessageUtil.sendConsoleDebugMessage("\u589e\u52a0\u5931\u8d25,\u4e8b\u7269\u56de\u6eda,\u53c2\u6570,\u7c7b\u578b:" + type + ",playerUuid" + playerUuid + ",amount+" + amount);
                    throw new RuntimeException("\u589e\u52a0\u5931\u8d25,\u4e8b\u7269\u56de\u6eda...");
                }
            }
        });
        return result.get();
    }

    public boolean set(List<UUID> playerUuidList, Map<String, Long> currencyChangeMap) {
        AtomicBoolean result = new AtomicBoolean(false);
        Tx.use().tx(tx -> {
            for (String type : currencyChangeMap.keySet()) {
                Long amount = (Long)currencyChangeMap.get(type);
                for (UUID playerUuid : playerUuidList) {
                    boolean rst;
                    Db<PlayerCurrencyEnter> use = Db.use(PlayerCurrencyEnter.class);
                    use.update().set(PlayerCurrencyEnter::getBalance, amount);
                    use.where().eq(PlayerCurrencyEnter::getPlayerUuid, playerUuid).eq(PlayerCurrencyEnter::getType, type);
                    boolean bl = rst = use.execution().update() > 0;
                    if (rst) {
                        result.set(true);
                        continue;
                    }
                    result.set(false);
                    MessageUtil.sendConsoleDebugMessage("\u8bbe\u7f6e\u5931\u8d25,\u4e8b\u7269\u56de\u6eda,\u53c2\u6570,\u7c7b\u578b:" + type + ",playerUuid" + playerUuid + ",amount+" + amount);
                    throw new RuntimeException("\u8bbe\u7f6e\u5931\u8d25,\u4e8b\u7269\u56de\u6eda...");
                }
            }
        });
        return result.get();
    }

    public boolean take(List<UUID> playerUuidList, Map<String, Long> currencyChangeMap) {
        AtomicBoolean result = new AtomicBoolean(false);
        Tx.use().tx(tx -> {
            for (String type : currencyChangeMap.keySet()) {
                Long amount = (Long)currencyChangeMap.get(type);
                for (UUID playerUuid : playerUuidList) {
                    boolean rst;
                    Db<PlayerCurrencyEnter> use = Db.use(PlayerCurrencyEnter.class);
                    use.update().subtract(PlayerCurrencyEnter::getBalance, PlayerCurrencyEnter::getBalance, amount);
                    use.where().eq(PlayerCurrencyEnter::getPlayerUuid, playerUuid).eq(PlayerCurrencyEnter::getType, type).ge(PlayerCurrencyEnter::getBalance, amount);
                    boolean bl = rst = use.execution(tx.getConn()).update() > 0;
                    if (rst) {
                        result.set(true);
                        continue;
                    }
                    result.set(false);
                    MessageUtil.sendConsoleDebugMessage("\u6263\u9664\u5931\u8d25,\u4e8b\u7269\u56de\u6eda,\u53c2\u6570,\u7c7b\u578b:" + type + ",playerUuid" + playerUuid + ",amount+" + amount);
                    throw new RuntimeException("\u6263\u9664\u5931\u8d25,\u4e8b\u7269\u56de\u6eda...");
                }
            }
        });
        return result.get();
    }

    public List<PlayerCurrencyEnter> getOrInit(List<UUID> playerUuidList, String type) {
        List<PlayerCurrencyEnter> playerCurrencyEnterList = this.findByPlayerUuidListAndType(playerUuidList, type);
        this.init(playerUuidList, type, playerCurrencyEnterList);
        return playerCurrencyEnterList;
    }

    private void init(List<UUID> playerUuidList, String type, List<PlayerCurrencyEnter> playerCurrencyEnterList) {
        Map<UUID, PlayerCurrencyEnter> playerCurrencyEnterListMap = playerCurrencyEnterList.stream().collect(Collectors.toMap(PlayerCurrencyEnter::getPlayerUuid, s -> s));
        ArrayList<PlayerCurrencyEnter> enterList = new ArrayList<PlayerCurrencyEnter>();
        for (UUID playerUuid : playerUuidList) {
            if (playerCurrencyEnterListMap.containsKey(playerUuid)) continue;
            OfflinePlayer offlinePlayer = BaseUtil.getOfflinePlayer(playerUuid);
            PlayerCurrencyEnter economyEnter = new PlayerCurrencyEnter();
            economyEnter.setType(type);
            economyEnter.setPlayerName(StrUtil.isNotEmpty(offlinePlayer.getName()) ? offlinePlayer.getName() : "\u672a\u77e5\u73a9\u5bb6");
            economyEnter.setPlayerUuid(playerUuid);
            economyEnter.setBalance(0L);
            economyEnter.setTotal(0L);
            enterList.add(economyEnter);
        }
        if (CollUtil.isNotEmpty(enterList)) {
            Db.use(PlayerCurrencyEnter.class).execution().insertBatch(enterList);
        }
    }

    private static class SingletonHolder {
        private static final PlayerCurrencyService INSTANCE = new PlayerCurrencyService();

        private SingletonHolder() {
        }
    }
}

