/*
 * Decompiled with CFR 0.152.
 */
package com.conquest.hearthfire.client.gui.screens.inventory;

import com.conquest.hearthfire.world.inventory.ListeningContainerMenu;
import java.util.List;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1860;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_465;

@Environment(value=EnvType.CLIENT)
public abstract class AbstractRecipeSelectionScreen<T extends ListeningContainerMenu, R extends class_1860<?>>
extends class_465<T> {
    private final class_2960 backgroundTexture;
    private final Function<T, List<R>> recipesGetter;
    private final Function<T, Integer> numRecipesGetter;
    private final Function<T, Boolean> hasIngredientChecker;
    private final Function<T, Integer> selectedRecipeIndexGetter;
    private final SoundProvider soundProvider;
    private float scrollOffs;
    private boolean scrolling;
    private int startIndex;
    private boolean displayRecipes;

    protected AbstractRecipeSelectionScreen(T menu, class_1661 inventory, class_2561 component, class_2960 backgroundTexture, Function<T, List<R>> recipesGetter, Function<T, Integer> numRecipesGetter, Function<T, Boolean> hasIngredientChecker, Function<T, Integer> selectedRecipeIndexGetter, SoundProvider soundProvider) {
        super(menu, inventory, component);
        this.backgroundTexture = backgroundTexture;
        this.recipesGetter = recipesGetter;
        this.numRecipesGetter = numRecipesGetter;
        this.hasIngredientChecker = hasIngredientChecker;
        this.selectedRecipeIndexGetter = selectedRecipeIndexGetter;
        this.soundProvider = soundProvider;
        ((ListeningContainerMenu)((Object)menu)).registerUpdateListener(this::containerChanged);
        --this.field_25268;
    }

    public void method_25394(class_332 guiGraphics, int i, int j, float f) {
        super.method_25394(guiGraphics, i, j, f);
        this.method_2380(guiGraphics, i, j);
    }

    protected void method_2389(class_332 guiGraphics, float f, int i, int j) {
        this.method_25420(guiGraphics);
        int k = this.field_2776;
        int l = this.field_2800;
        guiGraphics.method_25302(this.backgroundTexture, k, l, 0, 0, this.field_2792, this.field_2779);
        int m = (int)(41.0f * this.scrollOffs);
        guiGraphics.method_25302(this.backgroundTexture, k + 119, l + 15 + m, 176 + (this.isScrollBarActive() ? 0 : 12), 0, 12, 15);
        int n = this.field_2776 + 52;
        int o = this.field_2800 + 14;
        int p = this.startIndex + 12;
        this.renderButtons(guiGraphics, i, j, n, o, p);
        this.renderRecipes(guiGraphics, n, o, p);
    }

    protected void method_2380(class_332 guiGraphics, int i, int j) {
        super.method_2380(guiGraphics, i, j);
        if (this.displayRecipes) {
            int k = this.field_2776 + 52;
            int l = this.field_2800 + 14;
            int m = this.startIndex + 12;
            List<R> list = this.recipesGetter.apply((ListeningContainerMenu)this.field_2797);
            for (int n = this.startIndex; n < m && n < this.numRecipesGetter.apply((ListeningContainerMenu)this.field_2797); ++n) {
                int o = n - this.startIndex;
                int p = k + o % 4 * 16;
                int q = l + o / 4 * 18 + 2;
                if (i < p || i >= p + 16 || j < q || j >= q + 18) continue;
                guiGraphics.method_51446(this.field_22793, ((class_1860)list.get(n)).method_8110(this.field_22787.field_1687.method_30349()), i, j);
            }
        }
    }

    private void renderButtons(class_332 guiGraphics, int i, int j, int k, int l, int m) {
        for (int n = this.startIndex; n < m && n < this.numRecipesGetter.apply((ListeningContainerMenu)this.field_2797); ++n) {
            int o = n - this.startIndex;
            int p = k + o % 4 * 16;
            int q = o / 4;
            int r = l + q * 18 + 2;
            int s = this.field_2779;
            if (n == this.selectedRecipeIndexGetter.apply((ListeningContainerMenu)this.field_2797)) {
                s += 18;
            } else if (i >= p && j >= r && i < p + 16 && j < r + 18) {
                s += 36;
            }
            guiGraphics.method_25302(this.backgroundTexture, p, r - 1, 0, s, 16, 18);
        }
    }

    private void renderRecipes(class_332 guiGraphics, int i, int j, int k) {
        List<R> list = this.recipesGetter.apply((ListeningContainerMenu)this.field_2797);
        for (int l = this.startIndex; l < k && l < this.numRecipesGetter.apply((ListeningContainerMenu)this.field_2797); ++l) {
            int m = l - this.startIndex;
            int n = i + m % 4 * 16;
            int o = m / 4;
            int p = j + o * 18 + 2;
            guiGraphics.method_51427(((class_1860)list.get(l)).method_8110(this.field_22787.field_1687.method_30349()), n, p);
        }
    }

    public boolean method_25402(double d, double e, int i) {
        this.scrolling = false;
        if (this.displayRecipes) {
            int j = this.field_2776 + 52;
            int k = this.field_2800 + 14;
            int l = this.startIndex + 12;
            for (int m = this.startIndex; m < l; ++m) {
                int n = m - this.startIndex;
                double f = d - (double)(j + n % 4 * 16);
                double g = e - (double)(k + n / 4 * 18);
                if (!(f >= 0.0 && g >= 0.0 && f < 16.0 && g < 18.0 && ((ListeningContainerMenu)this.field_2797).method_7604((class_1657)this.field_22787.field_1724, m))) continue;
                class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)this.soundProvider.getSelectSound(), (float)1.0f));
                this.field_22787.field_1761.method_2900(((ListeningContainerMenu)this.field_2797).field_7763, m);
                return true;
            }
            j = this.field_2776 + 119;
            k = this.field_2800 + 9;
            if (d >= (double)j && d < (double)(j + 12) && e >= (double)k && e < (double)(k + 54)) {
                this.scrolling = true;
            }
        }
        return super.method_25402(d, e, i);
    }

    public boolean method_25403(double d, double e, int i, double f, double g) {
        if (this.scrolling && this.isScrollBarActive()) {
            int j = this.field_2800 + 14;
            int k = j + 54;
            this.scrollOffs = ((float)e - (float)j - 7.5f) / ((float)(k - j) - 15.0f);
            this.scrollOffs = class_3532.method_15363((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)this.getOffscreenRows()) + 0.5) * 4;
            return true;
        }
        return super.method_25403(d, e, i, f, g);
    }

    public boolean method_25401(double d, double e, double f) {
        if (this.isScrollBarActive()) {
            int i = this.getOffscreenRows();
            float g = (float)f / (float)i;
            this.scrollOffs = class_3532.method_15363((float)(this.scrollOffs - g), (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)i) + 0.5) * 4;
        }
        return true;
    }

    private boolean isScrollBarActive() {
        return this.displayRecipes && this.numRecipesGetter.apply((ListeningContainerMenu)this.field_2797) > 12;
    }

    protected int getOffscreenRows() {
        return (this.numRecipesGetter.apply((ListeningContainerMenu)this.field_2797) + 4 - 1) / 4 - 3;
    }

    private void containerChanged() {
        this.displayRecipes = this.hasIngredientChecker.apply((ListeningContainerMenu)this.field_2797);
        if (!this.displayRecipes) {
            this.scrollOffs = 0.0f;
            this.startIndex = 0;
        }
    }

    @FunctionalInterface
    public static interface SoundProvider {
        public class_3414 getSelectSound();
    }
}

