/*
 * Decompiled with CFR 0.152.
 */
package com.conquest.hearthfire.compat;

import com.conquest.hearthfire.compat.jei.ChurningCategory;
import com.conquest.hearthfire.compat.jei.SmithingCategory;
import com.conquest.hearthfire.compat.jei.WeavingCategory;
import com.conquest.hearthfire.compat.jei.WoodCuttingCategory;
import com.conquest.hearthfire.compat.jei.WoodWorkingCategory;
import com.conquest.hearthfire.compat.jei.recipes.ChurningRecipeType;
import com.conquest.hearthfire.compat.jei.recipes.ChurningRecipes;
import com.conquest.hearthfire.world.item.crafting.RecipeTypes;
import com.conquest.hearthfire.world.level.block.BlockRegistry;
import java.util.List;
import java.util.Objects;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.class_1863;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    @NotNull
    public class_2960 getPluginUid() {
        return new class_2960("hearthfire", "jei_plugin");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new WoodCuttingCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new WoodWorkingCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new ChurningCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new WeavingCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new SmithingCategory(guiHelper)});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        class_1863 recipeManager = Objects.requireNonNull(class_310.method_1551().field_1687.method_8433());
        List woodcuttingRecipes = recipeManager.method_30027(RecipeTypes.WOODCUTTING);
        registration.addRecipes(WoodCuttingCategory.WOODCUTTING, woodcuttingRecipes);
        List woodworkingRecipes = recipeManager.method_30027(RecipeTypes.WOODWORKING);
        registration.addRecipes(WoodWorkingCategory.WOODWORKING, woodworkingRecipes);
        List<ChurningRecipeType> churningRecipes = ChurningRecipes.getRecipes();
        registration.addRecipes(ChurningCategory.CHURNING, churningRecipes);
        List weavingRecipes = recipeManager.method_30027(RecipeTypes.WEAVING);
        registration.addRecipes(WeavingCategory.WEAVING, weavingRecipes);
        List smithingRecipes = recipeManager.method_30027(RecipeTypes.SMITHING);
        registration.addRecipes(SmithingCategory.SMITHING, smithingRecipes);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst((class_1935)BlockRegistry.SAWHORSE, new RecipeType[]{WoodCuttingCategory.WOODCUTTING});
        registration.addRecipeCatalyst((class_1935)BlockRegistry.CARPENTRY_TABLE, new RecipeType[]{WoodWorkingCategory.WOODWORKING});
        registration.addRecipeCatalyst((class_1935)BlockRegistry.BUTTER_CHURN, new RecipeType[]{ChurningCategory.CHURNING});
        registration.addRecipeCatalyst((class_1935)BlockRegistry.TREADLE_LOOM, new RecipeType[]{WeavingCategory.WEAVING});
        registration.addRecipeCatalyst((class_1935)BlockRegistry.STAKE_ANVIL, new RecipeType[]{SmithingCategory.SMITHING});
    }
}

