/*
 * Decompiled with CFR 0.152.
 */
package com.conquest.hearthfire.data.models;

import com.conquest.hearthfire.data.models.BlockStateProvider;
import com.conquest.hearthfire.data.models.model.BarrelType;
import com.conquest.hearthfire.data.models.model.Category;
import com.conquest.hearthfire.data.models.model.DisplayConfig;
import com.conquest.hearthfire.data.models.model.ModelTemplates;
import com.conquest.hearthfire.data.models.model.Parent;
import com.conquest.hearthfire.data.models.model.TextureMappings;
import com.conquest.hearthfire.data.models.model.TextureSlots;
import com.conquest.hearthfire.world.level.block.BlockRegistry;
import com.conquest.hearthfire.world.level.block.state.properties.BlockStateProperties;
import com.conquest.hearthfire.world.level.block.state.properties.HorizontalConnection;
import com.conquest.hearthfire.world.level.block.state.properties.Part;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricModelProvider;
import net.minecraft.class_1792;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2741;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4918;
import net.minecraft.class_4922;
import net.minecraft.class_4925;
import net.minecraft.class_4926;
import net.minecraft.class_4935;
import net.minecraft.class_4936;
import net.minecraft.class_4940;
import net.minecraft.class_4941;
import net.minecraft.class_4944;
import net.minecraft.class_4945;
import net.minecraft.class_7923;

public abstract class BlockModelProvider
extends FabricModelProvider {
    public BlockModelProvider(FabricDataOutput output) {
        super(output);
    }

    private static void delegateItemModel(class_4910 generator, class_2248 block, class_2960 resourceLocation) {
        generator.field_22831.accept(class_4941.method_25840((class_1792)block.method_8389()), new class_4940(resourceLocation));
        if (!BlockRegistry.hasItem(block)) {
            throw new IllegalStateException("Block '" + String.valueOf(class_7923.field_41175.method_10221((Object)block)) + "' does not have a registered item and cannot delegate item model.");
        }
    }

    public static void createSimpleFlatItemModel(class_4910 generator, class_2248 block, Category category, String parent, String resourceLocation) {
        class_1792 item = block.method_8389();
        ModelTemplates.FLAT_ITEM.method_25852(class_4941.method_25840((class_1792)item), class_4944.method_25895((class_2960)TextureMappings.getTextureFromDirectResource(block, category, parent, resourceLocation)), generator.field_22831);
    }

    public static void createBlock(class_4910 generator, class_2248 block) {
        class_2960 resourceLocation = class_4941.method_25842((class_2248)block);
        generator.field_22830.accept(BlockStateProvider.createBlock(block, resourceLocation));
        BlockModelProvider.delegateItemModel(generator, block, resourceLocation);
    }

    public static void createOBJBlock(class_4910 generator, class_2248 block, Parent parent, Category category, String group) {
        String string = class_7923.field_41175.method_10221((Object)block).method_12832();
        class_2960 all = TextureMappings.getTextureFromDirectResource(block, category, group, string);
        class_2960 resourceLocation = ModelTemplates.createOBJTemplate(string, parent, "", class_4945.field_23010, class_4945.field_23012).create(block, new class_4944().method_25868(class_4945.field_23010, all).method_25868(class_4945.field_23012, all), (BiConsumer<class_2960, Supplier<JsonElement>>)generator.field_22831);
        generator.field_22830.accept(BlockStateProvider.createBlock(block, resourceLocation));
        generator.method_25623(block, resourceLocation);
    }

    public static void createOBJBlock(class_4910 generator, class_2248 block, class_2248 parentBlock, Parent parent, Category category, String group) {
        class_2960 all = TextureMappings.getTextureFromDirectResource(block, category, group, class_7923.field_41175.method_10221((Object)block).method_12832());
        class_2960 resourceLocation = ModelTemplates.createOBJTemplate(class_7923.field_41175.method_10221((Object)parentBlock).method_12832(), parent, "", class_4945.field_23010, class_4945.field_23012).create(block, new class_4944().method_25868(class_4945.field_23010, all).method_25868(class_4945.field_23012, all), (BiConsumer<class_2960, Supplier<JsonElement>>)generator.field_22831);
        generator.field_22830.accept(BlockStateProvider.createBlock(block, resourceLocation));
        generator.method_25623(block, resourceLocation);
    }

    public static void createBlockWithoutItem(class_4910 generator, class_2248 block) {
        class_2960 resourceLocation = class_4941.method_25842((class_2248)block);
        generator.field_22830.accept(BlockStateProvider.createBlock(block, resourceLocation));
        generator.method_25540(block);
    }

    public static void createBlockWithFlatItem(class_4910 generator, class_2248 block) {
        class_2960 resourceLocation = class_4941.method_25842((class_2248)block);
        generator.field_22830.accept(BlockStateProvider.createBlock(block, resourceLocation));
        generator.method_25537(block.method_8389());
    }

    public static void createAirBlock(class_4910 generator, class_2248 block) {
        class_2960 resourceLocation = new class_2960("hearthfire", "block/air_block");
        generator.field_22830.accept(BlockStateProvider.createBlock(block, resourceLocation));
        generator.method_25540(block);
    }

    public static void createHorizontalDirectionalBlock(class_4910 generator, class_2248 block) {
        class_2960 resourceLocation = class_4941.method_25842((class_2248)block);
        BlockModelProvider.horizontalDirectionalBlockWithItem(generator, block, resourceLocation);
    }

    public static void createRotatedVariantsBlock(class_4910 generator, class_2248 block) {
        class_2960 resourceLocation = class_4941.method_25842((class_2248)block);
        generator.field_22830.accept(BlockStateProvider.createRotatedVariants(block, resourceLocation));
        generator.method_25623(block, resourceLocation);
    }

    public static void createTopBottomAttachedBlock(class_4910 generator, class_2248 block) {
        class_2960 resourceLocation1 = class_4941.method_25843((class_2248)block, (String)"_bottom");
        class_2960 resourceLocation2 = class_4941.method_25843((class_2248)block, (String)"_top");
        generator.field_22830.accept(BlockStateProvider.createDirectionalHalfBlock(block, resourceLocation1, resourceLocation2));
        generator.method_25623(block, resourceLocation2);
    }

    public static void createFiveWayDirectionalBlock(class_4910 generator, class_2248 block) {
        class_2960 resourceLocation = class_4941.method_25842((class_2248)block);
        generator.field_22830.accept(BlockStateProvider.createFiveWayDirectionalBlock(block, resourceLocation));
        generator.method_25623(block, resourceLocation);
    }

    public static void createHorizontalConnectedDirectionalBlock(class_4910 generator, class_2248 block) {
        class_2960 single = class_4941.method_25842((class_2248)block);
        class_2960 left = class_4941.method_25843((class_2248)block, (String)"_left");
        class_2960 middle = class_4941.method_25843((class_2248)block, (String)"_middle");
        class_2960 right = class_4941.method_25843((class_2248)block, (String)"_right");
        generator.field_22830.accept(BlockStateProvider.createHorizontalConnectedDirectionalBlock(block, single, left, middle, right));
        generator.method_25623(block, single);
    }

    public static void createThreeVariantsBlock(class_4910 generator, class_2248 block) {
        class_2960 resourceLocation1 = class_4941.method_25843((class_2248)block, (String)"1");
        class_2960 resourceLocation2 = class_4941.method_25843((class_2248)block, (String)"2");
        class_2960 resourceLocation3 = class_4941.method_25843((class_2248)block, (String)"3");
        generator.field_22830.accept(class_4925.method_25769((class_2248)block).method_25775(BlockStateProvider.createHorizontalFacingDispatch()).method_25775((class_4926)class_4926.method_25783((class_2769)BlockStateProperties.VARIANT).method_25793((Comparable)Integer.valueOf(1), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)resourceLocation1)).method_25793((Comparable)Integer.valueOf(2), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)resourceLocation2)).method_25793((Comparable)Integer.valueOf(3), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)resourceLocation3))));
        generator.method_25623(block, resourceLocation1);
    }

    public static void createWardrobe(class_4910 generator, class_2248 block) {
        class_2960 top = TextureMappings.wardrobe(block, "_top");
        class_2960 bottom = TextureMappings.wardrobe(block, "_bottom");
        class_2960 sideLower = TextureMappings.wardrobe(block, "_lower_side");
        class_2960 sideUpper = TextureMappings.wardrobe(block, "_upper_side");
        class_2960 frontLowerLeft = TextureMappings.wardrobe(block, "_lower_left");
        class_2960 frontUpperLeft = TextureMappings.wardrobe(block, "_upper_left");
        class_2960 frontLowerRight = TextureMappings.wardrobe(block, "_lower_right");
        class_2960 frontUpperRight = TextureMappings.wardrobe(block, "_upper_right");
        class_2960 backLower = TextureMappings.wardrobe(block, "_lower_back");
        class_2960 backUpper = TextureMappings.wardrobe(block, "_upper_back");
        class_4944 lowerLeftMapping = new class_4944().method_25868(class_4945.field_23015, top).method_25868(class_4945.field_23014, bottom).method_25868(class_4945.field_23018, sideLower).method_25868(class_4945.field_23016, frontLowerLeft).method_25868(class_4945.field_23017, backLower);
        class_4944 lowerRightMapping = new class_4944().method_25868(class_4945.field_23015, top).method_25868(class_4945.field_23014, bottom).method_25868(class_4945.field_23018, sideLower).method_25868(class_4945.field_23016, frontLowerRight).method_25868(class_4945.field_23017, backLower);
        class_4944 upperLeftMapping = new class_4944().method_25868(class_4945.field_23015, top).method_25868(class_4945.field_23018, sideUpper).method_25868(class_4945.field_23016, frontUpperLeft).method_25868(class_4945.field_23017, backUpper);
        class_4944 upperRightMapping = new class_4944().method_25868(class_4945.field_23015, top).method_25868(class_4945.field_23018, sideUpper).method_25868(class_4945.field_23016, frontUpperRight).method_25868(class_4945.field_23017, backUpper);
        class_4944 inventoryMapping = new class_4944().method_25868(class_4945.field_23015, top).method_25868(class_4945.field_23014, bottom).method_25868(TextureSlots.SIDE1, sideLower).method_25868(TextureSlots.SIDE2, sideUpper).method_25868(TextureSlots.FRONT1, frontLowerLeft).method_25868(TextureSlots.FRONT2, frontUpperLeft).method_25868(TextureSlots.BACK1, backLower).method_25868(TextureSlots.BACK2, backUpper);
        class_2960 lowerLeft = ModelTemplates.createTopBottomSideFrontBack("template_wardrobe_lower_left", "_lower_left").method_25846(block, lowerLeftMapping, generator.field_22831);
        class_2960 lowerRight = ModelTemplates.createTopBottomSideFrontBack("template_wardrobe_lower_right", "_lower_right").method_25846(block, lowerRightMapping, generator.field_22831);
        class_2960 upperLeft = ModelTemplates.createTemplate("template_wardrobe_upper_left", "_upper_left", class_4945.field_23015, class_4945.field_23018, class_4945.field_23016, class_4945.field_23017).method_25846(block, upperLeftMapping, generator.field_22831);
        class_2960 upperRight = ModelTemplates.createTemplate("template_wardrobe_upper_right", "_upper_right", class_4945.field_23015, class_4945.field_23018, class_4945.field_23016, class_4945.field_23017).method_25846(block, upperRightMapping, generator.field_22831);
        class_2960 inventory = ModelTemplates.createTemplate("template_wardrobe_inventory", "_inventory", class_4945.field_23015, class_4945.field_23014, TextureSlots.SIDE1, TextureSlots.SIDE2, TextureSlots.FRONT1, TextureSlots.FRONT2, TextureSlots.BACK1, TextureSlots.BACK2).method_25846(block, inventoryMapping, generator.field_22831);
        generator.field_22830.accept(BlockStateProvider.createHingedTallBlock(block, lowerLeft, upperLeft, lowerRight, upperRight));
        BlockModelProvider.delegateItemModel(generator, block, inventory);
    }

    public static void createCabinet(class_4910 generator) {
        class_2248 block = BlockRegistry.FANCY_CABINET;
        class_2960 bottomModel = class_4941.method_25843((class_2248)block, (String)"_bottom");
        class_2960 middleModel = class_4941.method_25843((class_2248)block, (String)"_middle");
        class_2960 topModel = class_4941.method_25843((class_2248)block, (String)"_top");
        generator.field_22830.accept(BlockStateProvider.createVerticalConnectedDirectionalBlock(block, topModel, bottomModel, middleModel, topModel));
        BlockModelProvider.delegateItemModel(generator, block, topModel);
    }

    public static void createCabinet(class_4910 generator, class_2248 block) {
        class_2960 frontSingle = TextureMappings.cabinet(block, "_front_single");
        class_2960 frontLower = TextureMappings.cabinet(block, "_front_lower");
        class_2960 frontMiddle = TextureMappings.cabinet(block, "_front_middle");
        class_2960 frontUpper = TextureMappings.cabinet(block, "_front_upper");
        BlockModelProvider.verticalConnectedDirectionalFurniture(generator, block, block, "cabinet", frontSingle, frontLower, frontMiddle, frontUpper);
    }

    public static void createCloset(class_4910 generator, class_2248 block, class_2248 parentBlock) {
        class_2960 frontSingle = TextureMappings.closet(block, "_front_single");
        class_2960 frontLower = TextureMappings.closet(block, "_front_lower");
        class_2960 frontMiddle = TextureMappings.closet(block, "_front_middle");
        class_2960 frontUpper = TextureMappings.closet(block, "_front_upper");
        BlockModelProvider.verticalConnectedDirectionalFurniture(generator, block, parentBlock, "closet", frontSingle, frontLower, frontMiddle, frontUpper);
    }

    public static void createCupboard(class_4910 generator, class_2248 block, class_2248 parentBlock) {
        class_2960 frontSingle = TextureMappings.cupboard(block, "_front_upper");
        class_2960 frontLower = TextureMappings.cupboard(block, "_front_lower");
        class_2960 frontMiddle = TextureMappings.cabinet(parentBlock, "_front_middle");
        class_2960 frontUpper = TextureMappings.cupboard(block, "_front_upper");
        BlockModelProvider.verticalConnectedDirectionalFurniture(generator, block, parentBlock, "cupboard", frontSingle, frontLower, frontMiddle, frontUpper);
    }

    public static void createBookcase(class_4910 generator, class_2248 block, class_2248 parentBlock) {
        class_2960 frontSingle = TextureMappings.cabinet(parentBlock, "_front_single");
        class_2960 frontLower = TextureMappings.cabinet(parentBlock, "_front_lower");
        class_2960 frontMiddle = TextureMappings.cabinet(parentBlock, "_front_middle");
        class_2960 frontUpper = TextureMappings.cabinet(parentBlock, "_front_upper");
        BlockModelProvider.verticalConnectedDirectionalFurniture(generator, block, parentBlock, "bookcase", frontSingle, frontLower, frontMiddle, frontUpper);
    }

    public static void createDresser(class_4910 generator) {
        class_2248 block = BlockRegistry.FANCY_DRESSER;
        class_2960 resourceLocation = class_4941.method_25842((class_2248)block);
        BlockModelProvider.horizontalDirectionalBlockWithItem(generator, block, resourceLocation);
    }

    public static void createDresser(class_4910 generator, class_2248 block, class_2248 parentBlock) {
        class_2960 side = TextureMappings.dresser(block, "_side");
        class_2960 front = TextureMappings.dresser(block, "_front");
        class_2960 back = TextureMappings.dresser(block, "_back");
        BlockModelProvider.horizontalDirectionalFurniture(generator, block, parentBlock, "dresser", side, front, back);
    }

    public static void createDrawer(class_4910 generator, class_2248 block, class_2248 parentBlock) {
        class_2960 side = TextureMappings.drawer(block, "_side");
        class_2960 front = TextureMappings.drawer(block, "_front");
        class_2960 back = TextureMappings.drawer(block, "_back");
        BlockModelProvider.horizontalDirectionalFurniture(generator, block, parentBlock, "drawer", side, front, back);
    }

    public static void createDrawer(class_4910 generator) {
        class_2248 block = BlockRegistry.FANCY_DRAWER;
        class_2960 resourceLocation = class_4941.method_25842((class_2248)block);
        BlockModelProvider.horizontalDirectionalBlockWithItem(generator, block, resourceLocation);
    }

    public static void createEndTable(class_4910 generator, class_2248 block, class_2248 parentBlock) {
        class_2960 side = TextureMappings.endTable(block, "_side");
        class_2960 front = TextureMappings.endTable(block, "_front");
        class_2960 back = TextureMappings.endTable(block, "_back");
        BlockModelProvider.horizontalDirectionalFurniture(generator, block, parentBlock, "end_table", side, front, back);
    }

    public static void createSideTable(class_4910 generator, class_2248 block) {
        class_2960 side = TextureMappings.sideTable(block, "_side");
        class_2960 top = TextureMappings.sideTable(block, "_top");
        class_4944 textureMapping = new class_4944().method_25868(class_4945.field_23015, top).method_25868(class_4945.field_23018, side);
        class_2960 resourceLocation = ModelTemplates.createTemplate("template_side_table", "", class_4945.field_23015, class_4945.field_23018).method_25846(block, textureMapping, generator.field_22831);
        generator.field_22830.accept(BlockStateProvider.createBlock(block, resourceLocation));
        BlockModelProvider.delegateItemModel(generator, block, resourceLocation);
    }

    private static void verticalConnectedDirectionalFurniture(class_4910 generator, class_2248 block, class_2248 parentBlock, String string, class_2960 frontSingle, class_2960 frontLower, class_2960 frontMiddle, class_2960 frontUpper) {
        class_2960 top = TextureMappings.cabinet(parentBlock, "_top");
        class_2960 bottom = TextureMappings.cabinet(parentBlock, "_bottom");
        class_2960 side = TextureMappings.cabinet(parentBlock, "_side");
        class_2960 sideMiddle = TextureMappings.cabinet(parentBlock, "_side_middle");
        class_2960 back = TextureMappings.cabinet(parentBlock, "_back");
        class_2960 backMiddle = TextureMappings.cabinet(parentBlock, "_back_middle");
        class_4944 singleMapping = new class_4944().method_25868(class_4945.field_23015, top).method_25868(class_4945.field_23014, bottom).method_25868(class_4945.field_23018, side).method_25868(class_4945.field_23016, frontSingle).method_25868(class_4945.field_23017, back);
        class_4944 bottomMapping = new class_4944().method_25868(class_4945.field_23015, top).method_25868(class_4945.field_23014, bottom).method_25868(class_4945.field_23018, side).method_25868(class_4945.field_23016, frontLower).method_25868(class_4945.field_23017, back);
        class_4944 middleMapping = new class_4944().method_25868(class_4945.field_23015, top).method_25868(class_4945.field_23014, bottom).method_25868(class_4945.field_23018, sideMiddle).method_25868(class_4945.field_23016, frontMiddle).method_25868(class_4945.field_23017, backMiddle);
        class_4944 topMapping = new class_4944().method_25868(class_4945.field_23015, top).method_25868(class_4945.field_23014, bottom).method_25868(class_4945.field_23018, side).method_25868(class_4945.field_23016, frontUpper).method_25868(class_4945.field_23017, back);
        class_2960 singleModel = ModelTemplates.createTopBottomSideFrontBack("template_" + string, "").method_25846(block, singleMapping, generator.field_22831);
        class_2960 bottomModel = ModelTemplates.createTopBottomSideFrontBack("template_" + string + "_bottom", "_bottom").method_25846(block, bottomMapping, generator.field_22831);
        class_2960 middleModel = ModelTemplates.createTopBottomSideFrontBack("template_" + string + "_middle", "_middle").method_25846(block, middleMapping, generator.field_22831);
        class_2960 topModel = ModelTemplates.createTopBottomSideFrontBack("template_" + string + "_top", "_top").method_25846(block, topMapping, generator.field_22831);
        generator.field_22830.accept(BlockStateProvider.createVerticalConnectedDirectionalBlock(block, singleModel, bottomModel, middleModel, topModel));
        BlockModelProvider.delegateItemModel(generator, block, singleModel);
    }

    private static void horizontalDirectionalFurniture(class_4910 generator, class_2248 block, class_2248 parentBlock, String string, class_2960 side, class_2960 front, class_2960 back) {
        class_2960 top = TextureMappings.cabinet(parentBlock, "_top");
        class_2960 bottom = TextureMappings.cabinet(parentBlock, "_bottom");
        class_4944 textureMapping = new class_4944().method_25868(class_4945.field_23015, top).method_25868(class_4945.field_23014, bottom).method_25868(class_4945.field_23018, side).method_25868(class_4945.field_23016, front).method_25868(class_4945.field_23017, back);
        class_2960 resourceLocation = ModelTemplates.createTopBottomSideFrontBack("template_" + string, "").method_25846(block, textureMapping, generator.field_22831);
        BlockModelProvider.horizontalDirectionalBlockWithItem(generator, block, resourceLocation);
    }

    private static void horizontalDirectionalBlockWithItem(class_4910 generator, class_2248 block, class_2960 resourceLocation) {
        generator.field_22830.accept(BlockStateProvider.createHorizontalDirectionalBlock(block, resourceLocation));
        BlockModelProvider.delegateItemModel(generator, block, resourceLocation);
    }

    public static void createSofa(class_4910 generator, class_2248 block) {
        class_2960 top1 = TextureMappings.sofa(block, "_top1");
        class_2960 top2 = TextureMappings.sofa(block, "_top2");
        class_2960 bottom = TextureMappings.sofa(block, "_bottom");
        class_2960 side1 = TextureMappings.sofa(block, "_side1");
        class_2960 side2 = TextureMappings.sofa(block, "_side2");
        class_2960 front = TextureMappings.sofa(block, "_front");
        class_2960 back = TextureMappings.sofa(block, "_back");
        class_4944 singleMapping = new class_4944().method_25868(class_4945.field_23015, top1).method_25868(class_4945.field_23014, bottom).method_25868(class_4945.field_23018, side1).method_25868(class_4945.field_23016, front).method_25868(class_4945.field_23017, back);
        class_4944 sideMapping = new class_4944().method_25868(TextureSlots.TOP1, top1).method_25868(TextureSlots.TOP2, top2).method_25868(class_4945.field_23014, bottom).method_25868(TextureSlots.SIDE1, side1).method_25868(TextureSlots.SIDE2, side2).method_25868(class_4945.field_23016, front).method_25868(class_4945.field_23017, back);
        class_4944 middleMapping = new class_4944().method_25868(class_4945.field_23015, top2).method_25868(class_4945.field_23014, bottom).method_25868(TextureSlots.SIDE1, side1).method_25868(TextureSlots.SIDE2, side2).method_25868(class_4945.field_23016, front).method_25868(class_4945.field_23017, back);
        class_2960 singleModel = ModelTemplates.createTopBottomSideFrontBack("template_rustic_sofa", "").method_25846(block, singleMapping, generator.field_22831);
        class_2960 leftModel = ModelTemplates.createTemplate("template_rustic_sofa_left", "_left", TextureSlots.TOP1, TextureSlots.TOP2, class_4945.field_23014, TextureSlots.SIDE1, TextureSlots.SIDE2, class_4945.field_23016, class_4945.field_23017).method_25846(block, sideMapping, generator.field_22831);
        class_2960 middleModel = ModelTemplates.createTemplate("template_rustic_sofa_middle", "_middle", class_4945.field_23015, class_4945.field_23014, TextureSlots.SIDE1, TextureSlots.SIDE2, class_4945.field_23016, class_4945.field_23017).method_25846(block, middleMapping, generator.field_22831);
        class_2960 rightModel = ModelTemplates.createTemplate("template_rustic_sofa_right", "_right", TextureSlots.TOP1, TextureSlots.TOP2, class_4945.field_23014, TextureSlots.SIDE1, TextureSlots.SIDE2, class_4945.field_23016, class_4945.field_23017).method_25846(block, sideMapping, generator.field_22831);
        BlockModelProvider.horizontalConnectedDirectional(generator, block, singleModel, leftModel, middleModel, rightModel);
    }

    public static void createDaybed(class_4910 generator, class_2248 block) {
        class_2960 topLeft = TextureMappings.daybed(block, "_top_left");
        class_2960 topMiddle = TextureMappings.daybed(block, "_top_middle");
        class_2960 topRight = TextureMappings.daybed(block, "_top_right");
        class_2960 bottom = TextureMappings.daybed(block, "_bottom");
        class_2960 side = TextureMappings.daybed(block, "_side");
        class_2960 front = TextureMappings.daybed(block, "_front");
        class_2960 back = TextureMappings.daybed(block, "_back");
        class_2960 pillow = TextureMappings.daybed(block, "_pillow");
        class_4944 singleMapping = new class_4944().method_25868(class_4945.field_23015, topMiddle).method_25868(class_4945.field_23014, bottom).method_25868(class_4945.field_23018, side).method_25868(class_4945.field_23016, front).method_25868(class_4945.field_23017, back);
        class_4944 leftMapping = new class_4944().method_25868(class_4945.field_23015, topLeft).method_25868(class_4945.field_23014, bottom).method_25868(class_4945.field_23018, side).method_25868(class_4945.field_23016, front).method_25868(class_4945.field_23017, back).method_25868(TextureSlots.PILLOW, pillow);
        class_4944 middleMapping = new class_4944().method_25868(class_4945.field_23015, topMiddle).method_25868(class_4945.field_23014, bottom).method_25868(class_4945.field_23018, side).method_25868(class_4945.field_23016, front).method_25868(class_4945.field_23017, back);
        class_4944 rightMapping = new class_4944().method_25868(class_4945.field_23015, topRight).method_25868(class_4945.field_23014, bottom).method_25868(class_4945.field_23018, side).method_25868(class_4945.field_23016, front).method_25868(class_4945.field_23017, back).method_25868(TextureSlots.PILLOW, pillow);
        class_2960 singleModel = ModelTemplates.createTopBottomSideFrontBack("template_chinese_daybed", "").method_25846(block, singleMapping, generator.field_22831);
        class_2960 leftModel = ModelTemplates.createTemplate("template_chinese_daybed_left", "_left", class_4945.field_23015, class_4945.field_23014, class_4945.field_23018, class_4945.field_23016, class_4945.field_23017, TextureSlots.PILLOW).method_25846(block, leftMapping, generator.field_22831);
        class_2960 middleModel = ModelTemplates.createTopBottomSideFrontBack("template_chinese_daybed_middle", "_middle").method_25846(block, middleMapping, generator.field_22831);
        class_2960 rightModel = ModelTemplates.createTemplate("template_chinese_daybed_right", "_right", class_4945.field_23015, class_4945.field_23014, class_4945.field_23018, class_4945.field_23016, class_4945.field_23017, TextureSlots.PILLOW).method_25846(block, rightMapping, generator.field_22831);
        BlockModelProvider.horizontalConnectedDirectional(generator, block, singleModel, leftModel, middleModel, rightModel);
    }

    public static void createBench(class_4910 generator, class_2248 block) {
        class_2960 top = TextureMappings.bench(block, "_top");
        class_2960 side = TextureMappings.bench(block, "_side");
        class_2960 front1 = TextureMappings.bench(block, "_front1");
        class_2960 front2 = TextureMappings.bench(block, "_front2");
        class_2960 back = TextureMappings.bench(block, "_back");
        class_4944 singleMapping = new class_4944().method_25868(class_4945.field_23015, top).method_25868(class_4945.field_23018, side).method_25868(class_4945.field_23017, back);
        class_4944 sideMapping = new class_4944().method_25868(class_4945.field_23015, top).method_25868(class_4945.field_23018, side).method_25868(class_4945.field_23016, front1).method_25868(class_4945.field_23017, back);
        class_4944 middleMapping = new class_4944().method_25868(class_4945.field_23015, top).method_25868(class_4945.field_23018, side).method_25868(class_4945.field_23016, front2).method_25868(class_4945.field_23017, back);
        class_2960 singleModel = ModelTemplates.createTemplate("template_rustic_bench", "", class_4945.field_23015, class_4945.field_23018, class_4945.field_23017).method_25846(block, singleMapping, generator.field_22831);
        class_2960 leftModel = ModelTemplates.createTemplate("template_rustic_bench_left", "_left", class_4945.field_23015, class_4945.field_23018, class_4945.field_23016, class_4945.field_23017).method_25846(block, sideMapping, generator.field_22831);
        class_2960 middleModel = ModelTemplates.createTemplate("template_rustic_bench_middle", "_middle", class_4945.field_23015, class_4945.field_23018, class_4945.field_23016, class_4945.field_23017).method_25846(block, middleMapping, generator.field_22831);
        class_2960 rightModel = ModelTemplates.createTemplate("template_rustic_bench_right", "_right", class_4945.field_23015, class_4945.field_23018, class_4945.field_23016, class_4945.field_23017).method_25846(block, sideMapping, generator.field_22831);
        BlockModelProvider.horizontalConnectedDirectional(generator, block, singleModel, leftModel, middleModel, rightModel);
    }

    private static void horizontalConnectedDirectional(class_4910 generator, class_2248 block, class_2960 singleModel, class_2960 leftModel, class_2960 middleModel, class_2960 rightModel) {
        generator.field_22830.accept(BlockStateProvider.createHorizontalConnectedDirectionalBlock(block, singleModel, leftModel, middleModel, rightModel));
        BlockModelProvider.delegateItemModel(generator, block, singleModel);
    }

    public static void createGothicArmChair(class_4910 generator, class_2248 block) {
        class_2960 top = TextureMappings.furniture(block, "gothic_arm_chair", "_top");
        class_2960 bottom = TextureMappings.furniture(block, "gothic_arm_chair", "_bottom");
        class_2960 side = TextureMappings.furniture(block, "gothic_arm_chair", "_side");
        class_2960 front = TextureMappings.furniture(block, "gothic_arm_chair", "_front");
        class_2960 back = TextureMappings.furniture(block, "gothic_arm_chair", "_back");
        class_4944 lowerMapping = new class_4944().method_25868(class_4945.field_23015, top).method_25868(class_4945.field_23014, bottom).method_25868(class_4945.field_23018, side).method_25868(class_4945.field_23016, front);
        class_4944 upperMapping = new class_4944().method_25868(class_4945.field_23018, side).method_25868(class_4945.field_23016, front).method_25868(class_4945.field_23017, back);
        class_4944 itemMapping = lowerMapping.method_25868(class_4945.field_23017, back);
        class_2960 lowerModel = ModelTemplates.createTemplate("template_gothic_arm_chair_lower", "_lower", class_4945.field_23015, class_4945.field_23014, class_4945.field_23018, class_4945.field_23016).method_25846(block, lowerMapping, generator.field_22831);
        class_2960 upperModel = ModelTemplates.createTemplate("template_gothic_arm_chair_upper", "_upper", class_4945.field_23018, class_4945.field_23016, class_4945.field_23017).method_25846(block, upperMapping, generator.field_22831);
        class_2960 itemModel = ModelTemplates.createTemplate("template_gothic_arm_chair_inventory", "_inventory", class_4945.field_23015, class_4945.field_23014, class_4945.field_23018, class_4945.field_23016, class_4945.field_23017).method_25846(block, itemMapping, generator.field_22831);
        BlockModelProvider.tallBlockWithItem(generator, block, lowerModel, upperModel, itemModel);
    }

    public static void createRusticSideChair(class_4910 generator, class_2248 block) {
        class_2960 top = TextureMappings.furniture(block, "rustic_side_chair", "_top");
        class_2960 bottom = TextureMappings.furniture(block, "rustic_side_chair", "_bottom");
        class_2960 side = TextureMappings.furniture(block, "rustic_side_chair", "_side");
        class_2960 front = TextureMappings.furniture(block, "rustic_side_chair", "_front");
        class_4944 lowerMapping = new class_4944().method_25868(class_4945.field_23015, top).method_25868(class_4945.field_23014, bottom).method_25868(class_4945.field_23018, side).method_25868(class_4945.field_23016, front);
        class_4944 upperMapping = new class_4944().method_25868(class_4945.field_23018, side).method_25868(class_4945.field_23016, front);
        class_2960 lowerModel = ModelTemplates.createTemplate("template_rustic_side_chair_lower", "_lower", class_4945.field_23015, class_4945.field_23014, class_4945.field_23018, class_4945.field_23016).method_25846(block, lowerMapping, generator.field_22831);
        class_2960 upperModel = ModelTemplates.createTemplate("template_rustic_side_chair_upper", "upper", class_4945.field_23018, class_4945.field_23016).method_25846(block, upperMapping, generator.field_22831);
        class_2960 itemModel = ModelTemplates.createTemplate("template_rustic_side_chair_inventory", "_inventory", class_4945.field_23015, class_4945.field_23014, class_4945.field_23018, class_4945.field_23016).method_25846(block, lowerMapping, generator.field_22831);
        BlockModelProvider.tallBlockWithItem(generator, block, lowerModel, upperModel, itemModel);
    }

    public static void createRusticThroneChair(class_4910 generator, class_2248 block) {
        class_2960 top = TextureMappings.furniture(block, "rustic_throne_chair", "_top");
        class_2960 bottom = TextureMappings.furniture(block, "rustic_throne_chair", "_bottom");
        class_2960 side = TextureMappings.furniture(block, "rustic_throne_chair", "_side");
        class_2960 front = TextureMappings.furniture(block, "rustic_throne_chair", "_front");
        class_2960 back = TextureMappings.furniture(block, "rustic_throne_chair", "_back");
        class_4944 upperMapping = new class_4944().method_25868(class_4945.field_23018, side).method_25868(class_4945.field_23016, front).method_25868(class_4945.field_23017, back);
        class_4944 lowerMapping = upperMapping.method_25868(class_4945.field_23015, top).method_25868(class_4945.field_23014, bottom);
        class_2960 lowerModel = ModelTemplates.createTopBottomSideFrontBack("template_rustic_throne_chair_lower", "_lower").method_25846(block, lowerMapping, generator.field_22831);
        class_2960 upperModel = ModelTemplates.createTemplate("template_rustic_throne_chair_upper", "_upper", class_4945.field_23018, class_4945.field_23016, class_4945.field_23017).method_25846(block, upperMapping, generator.field_22831);
        class_2960 itemModel = ModelTemplates.createTopBottomSideFrontBack("template_rustic_throne_chair_inventory", "_inventory").method_25846(block, lowerMapping, generator.field_22831);
        BlockModelProvider.tallBlockWithItem(generator, block, lowerModel, upperModel, itemModel);
    }

    public static void createFancyChair(class_4910 generator) {
        class_2248 block = BlockRegistry.FANCY_CHAIR;
        class_2960 lowerModel = class_4941.method_25843((class_2248)block, (String)"_lower");
        class_2960 upperModel = class_4941.method_25843((class_2248)block, (String)"_upper");
        class_2960 itemModel = class_4941.method_25843((class_2248)block, (String)"_inventory");
        BlockModelProvider.tallBlockWithItem(generator, block, lowerModel, upperModel, itemModel);
    }

    private static void tallBlockWithItem(class_4910 generator, class_2248 block, class_2960 lowerModel, class_2960 upperModel, class_2960 itemModel) {
        generator.field_22830.accept(BlockStateProvider.createDirectionalTallBlock(block, lowerModel, upperModel));
        generator.method_25623(block, itemModel);
    }

    public static void createThreeLeggedChair(class_4910 generator) {
        class_2248 block = BlockRegistry.THREE_LEGGED_CHAIR;
        class_2960 top = TextureMappings.furniture(block, "chair", "_top");
        class_2960 side = TextureMappings.furniture(block, "chair", "_side");
        class_4944 textureMapping = new class_4944().method_25868(class_4945.field_23015, top).method_25868(class_4945.field_23018, side).method_25868(class_4945.field_23012, top);
        class_2960 resourceLocation = ModelTemplates.createOBJTemplate("three_legged_chair", "", class_4945.field_23012, class_4945.field_23015, class_4945.field_23018).create(block, textureMapping, (BiConsumer<class_2960, Supplier<JsonElement>>)generator.field_22831);
        BlockModelProvider.horizontalDirectionalBlockWithItem(generator, block, resourceLocation);
    }

    public static void createStove(class_4910 generator) {
        class_2248 block = BlockRegistry.STOVE;
        class_2960 resourceLocation1 = TextureMappings.decoration(block, "stove", "");
        class_4944 textureMapping = new class_4944().method_25868(class_4945.field_23011, resourceLocation1).method_25868(class_4945.field_23012, resourceLocation1);
        class_2960 resourceLocation2 = ModelTemplates.createOBJTemplate("stove", "", class_4945.field_23011, class_4945.field_23012).create(block, textureMapping, (BiConsumer<class_2960, Supplier<JsonElement>>)generator.field_22831);
        generator.field_22830.accept(BlockStateProvider.createHorizontalDirectionalBlock(block, resourceLocation2));
        generator.method_25623(block, resourceLocation2);
    }

    public static void createBathtub(class_4910 generator) {
        class_2248 block = BlockRegistry.RUSTIC_BATHTUB;
        class_4944 textureMapping = new class_4944().method_25868(class_4945.field_23011, class_4944.method_25866((class_2248)class_2246.field_10382, (String)"_still"));
        class_2960 head = class_4941.method_25843((class_2248)block, (String)"_head");
        class_2960 foot = class_4941.method_25843((class_2248)block, (String)"_foot");
        class_2960 headLayer = ModelTemplates.createOBJTemplate("rustic_bathtub", "_head_layer", class_4945.field_23011).create(block, textureMapping, (BiConsumer<class_2960, Supplier<JsonElement>>)generator.field_22831);
        class_2960 footLayer = ModelTemplates.createOBJTemplate("rustic_bathtub", "_foot_layer", class_4945.field_23011).create(block, textureMapping, (BiConsumer<class_2960, Supplier<JsonElement>>)generator.field_22831);
        class_4922 multiPart = class_4922.method_25758((class_2248)block);
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            int i = switch (direction) {
                case class_2350.field_11034 -> 90;
                case class_2350.field_11035 -> 180;
                case class_2350.field_11039 -> 270;
                default -> 0;
            };
            multiPart.method_25760(class_4918.method_35870((class_4918[])new class_4918[]{class_4918.method_25744().method_25751((class_2769)BlockStateProperties.HORIZONTAL_FACING, (Comparable)direction), class_4918.method_25744().method_25751(BlockStateProperties.PART, (Comparable)((Object)Part.HEAD))}), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)head).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.values()[i / 90]));
            multiPart.method_25760(class_4918.method_35870((class_4918[])new class_4918[]{class_4918.method_25744().method_25751((class_2769)BlockStateProperties.HORIZONTAL_FACING, (Comparable)direction), class_4918.method_25744().method_25751(BlockStateProperties.PART, (Comparable)((Object)Part.HEAD)), class_4918.method_25744().method_25751((class_2769)BlockStateProperties.EMPTY, (Comparable)Boolean.valueOf(false))}), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)headLayer).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.values()[i / 90]));
            multiPart.method_25760(class_4918.method_35870((class_4918[])new class_4918[]{class_4918.method_25744().method_25751((class_2769)BlockStateProperties.HORIZONTAL_FACING, (Comparable)direction), class_4918.method_25744().method_25751(BlockStateProperties.PART, (Comparable)((Object)Part.FOOT))}), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)foot).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.values()[i / 90]));
            multiPart.method_25760(class_4918.method_35870((class_4918[])new class_4918[]{class_4918.method_25744().method_25751((class_2769)BlockStateProperties.HORIZONTAL_FACING, (Comparable)direction), class_4918.method_25744().method_25751(BlockStateProperties.PART, (Comparable)((Object)Part.FOOT)), class_4918.method_25744().method_25751((class_2769)BlockStateProperties.EMPTY, (Comparable)Boolean.valueOf(false))}), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)footLayer).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.values()[i / 90]));
        }
        generator.field_22830.accept(multiPart);
        generator.method_25537(block.method_8389());
    }

    public static void createWashingTub(class_4910 generator) {
        class_2248 block = BlockRegistry.WOODEN_WASHING_TUB;
        class_2960 side = TextureMappings.decoration(block, "wooden_washing_tub", "_side");
        class_2960 inside = TextureMappings.decoration(block, "wooden_washing_tub", "_inside");
        class_2960 bottom = TextureMappings.decoration(block, "wooden_washing_tub", "_bottom");
        class_2960 layer = class_4944.method_25866((class_2248)class_2246.field_10382, (String)"_still");
        class_4944 textureMapping1 = new class_4944().method_25868(class_4945.field_23018, side).method_25868(class_4945.field_27791, inside).method_25868(class_4945.field_23014, bottom).method_25868(class_4945.field_23012, side);
        class_4944 textureMapping2 = new class_4944().method_25868(class_4945.field_23011, layer);
        class_2960 resourceLocation1 = ModelTemplates.createOBJTemplate("wooden_washing_tub", "", class_4945.field_23012, class_4945.field_23018, class_4945.field_27791, class_4945.field_23014).create(block, textureMapping1, (BiConsumer<class_2960, Supplier<JsonElement>>)generator.field_22831);
        class_2960 resourceLocation2 = ModelTemplates.createOBJTemplate("wooden_washing_tub", "_layer", class_4945.field_23011).create(block, textureMapping2, (BiConsumer<class_2960, Supplier<JsonElement>>)generator.field_22831);
        generator.field_22830.accept(class_4922.method_25758((class_2248)block).method_25763(class_4935.method_25824().method_25828(class_4936.field_22887, (Object)resourceLocation1)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)BlockStateProperties.FILL, (Comparable)Boolean.valueOf(true)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)resourceLocation2)));
        generator.method_25623(block, resourceLocation1);
    }

    public static void createTailorMirror(class_4910 generator) {
        class_2248 block = BlockRegistry.TAILOR_MIRROR;
        class_2960 side = TextureMappings.decoration(block, "mirror", "_side");
        class_2960 lowerFront = TextureMappings.decoration(block, "mirror", "_lower_front");
        class_2960 lowerBack = TextureMappings.decoration(block, "mirror", "_lower_back");
        class_2960 upperFront = TextureMappings.decoration(block, "mirror", "_upper_front");
        class_2960 upperBack = TextureMappings.decoration(block, "mirror", "_upper_back");
        class_4944 lowerMapping = new class_4944().method_25868(class_4945.field_23018, side).method_25868(class_4945.field_23016, lowerFront).method_25868(class_4945.field_23017, lowerBack).method_25868(class_4945.field_23012, lowerBack);
        class_4944 upperMapping = new class_4944().method_25868(class_4945.field_23018, side).method_25868(class_4945.field_23016, upperFront).method_25868(class_4945.field_23017, upperBack).method_25868(class_4945.field_23012, upperBack);
        class_4944 itemMapping = new class_4944().method_25868(class_4945.field_23018, side).method_25868(TextureSlots.FRONT1, lowerFront).method_25868(TextureSlots.FRONT2, upperFront).method_25868(TextureSlots.BACK1, lowerBack).method_25868(TextureSlots.BACK2, upperBack);
        class_2960 lowerModel = ModelTemplates.createOBJTemplate("tailor_mirror", "_lower", class_4945.field_23018, class_4945.field_23016, class_4945.field_23017, class_4945.field_23012).create(block, lowerMapping, (BiConsumer<class_2960, Supplier<JsonElement>>)generator.field_22831);
        class_2960 upperModel = ModelTemplates.createOBJTemplate("tailor_mirror", "_upper", class_4945.field_23018, class_4945.field_23016, class_4945.field_23017, class_4945.field_23012).create(block, upperMapping, (BiConsumer<class_2960, Supplier<JsonElement>>)generator.field_22831);
        class_2960 itemModel = ModelTemplates.createOBJTemplate("tailor_mirror", Parent.TALL_BLOCK, "_inventory", class_4945.field_23018, TextureSlots.FRONT1, TextureSlots.FRONT2, TextureSlots.BACK1, TextureSlots.BACK2).create(block, itemMapping, (BiConsumer<class_2960, Supplier<JsonElement>>)generator.field_22831);
        BlockModelProvider.tallBlockWithItem(generator, block, lowerModel, upperModel, itemModel);
    }

    public static void createClothesHangingPole(class_4910 generator) {
        class_2248 block = BlockRegistry.CLOTHES_HANGING_POLE;
        class_2960 lower1 = class_4941.method_25843((class_2248)block, (String)"_lower1");
        class_2960 lower2 = class_4941.method_25843((class_2248)block, (String)"_lower2");
        class_2960 lower3 = class_4941.method_25843((class_2248)block, (String)"_lower3");
        class_2960 upper1 = class_4941.method_25843((class_2248)block, (String)"_upper1");
        class_2960 upper2 = class_4941.method_25843((class_2248)block, (String)"_upper2");
        class_2960 upper3 = class_4941.method_25843((class_2248)block, (String)"_upper3");
        class_2960 inventory = class_4941.method_25843((class_2248)block, (String)"_inventory");
        generator.field_22830.accept(class_4925.method_25769((class_2248)block).method_25775((class_4926)class_4926.method_25784(BlockStateProperties.DOUBLE_BLOCK_HALF, (class_2769)BlockStateProperties.TOGGLE).method_25797((Comparable)class_2756.field_12607, (Comparable)Boolean.valueOf(false), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)lower1)).method_25798((Comparable)class_2756.field_12607, (Comparable)Boolean.valueOf(true), Arrays.asList(BlockStateProvider.createRotatedVariants(lower2, lower3))).method_25797((Comparable)class_2756.field_12609, (Comparable)Boolean.valueOf(false), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)upper1)).method_25798((Comparable)class_2756.field_12609, (Comparable)Boolean.valueOf(true), Arrays.asList(BlockStateProvider.createRotatedVariants(upper2, upper3)))));
        generator.method_25623(block, inventory);
    }

    public static void createLogBench(class_4910 generator) {
        class_2248 block = BlockRegistry.LOG_BENCH;
        class_2960 resourceLocation1 = class_4941.method_25843((class_2248)block, (String)"_end");
        class_2960 resourceLocation2 = class_4941.method_25843((class_2248)block, (String)"_middle");
        class_2960 resourceLocation3 = class_4941.method_25843((class_2248)block, (String)"_inventory");
        generator.field_22830.accept(BlockStateProvider.createHorizontalConnectedDirectionalBlock(block, resourceLocation1, resourceLocation1, resourceLocation2, resourceLocation1));
        BlockModelProvider.delegateItemModel(generator, block, resourceLocation3);
    }

    public static void createStoneBench(class_4910 generator, class_2248 block) {
        class_2960 top = TextureMappings.decoration(block, "stone_bench", "_top");
        class_2960 side = TextureMappings.decoration(block, "stone_bench", "_side");
        class_2960 edge = TextureMappings.decoration(block, "stone_bench", "_edge");
        class_4944 textureMapping = new class_4944().method_25868(class_4945.field_23015, top).method_25868(class_4945.field_23018, side).method_25868(class_4945.field_23032, edge);
        class_2960 singleModel = ModelTemplates.createTemplate("template_stone_bench_single", "", class_4945.field_23015, class_4945.field_23018, class_4945.field_23032).method_25846(block, textureMapping, generator.field_22831);
        class_2960 leftModel = ModelTemplates.createTemplate("template_stone_bench_left", "_left", class_4945.field_23015, class_4945.field_23018, class_4945.field_23032).method_25846(block, textureMapping, generator.field_22831);
        class_2960 middleModel = ModelTemplates.createTemplate("template_stone_bench_middle", "_middle", class_4945.field_23015, class_4945.field_23018, class_4945.field_23032).method_25846(block, textureMapping, generator.field_22831);
        class_2960 rightModel = ModelTemplates.createTemplate("template_stone_bench_right", "_right", class_4945.field_23015, class_4945.field_23018, class_4945.field_23032).method_25846(block, textureMapping, generator.field_22831);
        BlockModelProvider.horizontalConnectedDirectional(generator, block, singleModel, leftModel, middleModel, rightModel);
    }

    public static void createCheeseWheel(class_4910 generator, class_2248 block) {
        String model = class_7923.field_41175.method_10221((Object)block).method_12832();
        String baseModel = model.endsWith("_wheel") ? model.substring(0, model.length() - "_wheel".length()) : model;
        class_2960 top = TextureMappings.getTextureFromDirectResource(block, Category.FOOD, "cheese", baseModel + "_top");
        class_2960 side = TextureMappings.getTextureFromDirectResource(block, Category.FOOD, "cheese", baseModel + "_side");
        class_4944 textureMapping = new class_4944().method_25868(class_4945.field_23015, top).method_25868(class_4945.field_23018, side).method_25868(class_4945.field_23012, top);
        String[] suffixes = new String[]{"_one_stack", "_two_stacks", "_three_stacks", "_four_stacks"};
        ArrayList<class_2960> models = new ArrayList<class_2960>(suffixes.length);
        for (String suffix : suffixes) {
            class_2960 resourceLocation = ModelTemplates.createOBJTemplate(model, suffix, class_4945.field_23015, class_4945.field_23018, class_4945.field_23012).create(block, textureMapping, (BiConsumer<class_2960, Supplier<JsonElement>>)generator.field_22831);
            models.add(resourceLocation);
        }
        generator.field_22830.accept(BlockStateProvider.createFourStackBlock(block, models));
        generator.method_25537(block.method_8389());
    }

    public static void createCutCheese(class_4910 generator, class_2248 block) {
        String model = class_7923.field_41175.method_10221((Object)block).method_12832();
        String baseModel = model.startsWith("cut_") ? model.substring(4) : model;
        class_2960 top1 = TextureMappings.getTextureFromDirectResource(block, Category.FOOD, "cheese", baseModel + "_top");
        class_2960 side = TextureMappings.getTextureFromDirectResource(block, Category.FOOD, "cheese", baseModel + "_side");
        class_2960 top2 = TextureMappings.getTextureFromDirectResource(block, Category.DECORATION, "cookware", "large_cutting_board_top");
        class_2960 bottom = TextureMappings.getTextureFromDirectResource(block, Category.DECORATION, "cookware", "large_cutting_board_bottom");
        class_4944 textureMapping = new class_4944().method_25868(TextureSlots.TOP1, top1).method_25868(TextureSlots.TOP2, top2).method_25868(class_4945.field_23014, bottom).method_25868(class_4945.field_23018, side).method_25868(class_4945.field_23012, top1);
        String[] suffixes = new String[]{"", "_slice1", "_slice2", "_slice3", "_slice4", "_slice5", "_slice6", "_slice7"};
        ArrayList<class_2960> models = new ArrayList<class_2960>(suffixes.length);
        for (String suffix : suffixes) {
            class_2960 resourceLocation = ModelTemplates.createOBJTemplate(model, suffix, TextureSlots.TOP1, TextureSlots.TOP2, class_4945.field_23014, class_4945.field_23018, class_4945.field_23012).create(block, textureMapping, (BiConsumer<class_2960, Supplier<JsonElement>>)generator.field_22831);
            models.add(resourceLocation);
        }
        generator.field_22830.accept(BlockStateProvider.createSevenBiteBlock(block, models));
        generator.method_25537(block.method_8389());
    }

    public static void curdCheese(class_4910 generator) {
        class_2248 block = BlockRegistry.CURD_CHEESE;
        class_2960 top = TextureMappings.food(block, "cheese", "");
        class_2960 side = TextureMappings.decoration(BlockRegistry.COPPER_BOWL, "cookware", "");
        class_4944 textureMapping = new class_4944().method_25868(class_4945.field_23015, top).method_25868(class_4945.field_23018, side).method_25868(class_4945.field_23012, top);
        class_2960 model = ModelTemplates.createOBJTemplate("curd_cheese", Parent.SMALL_BLOCK, "", class_4945.field_23015, class_4945.field_23018, class_4945.field_23012).create(block, textureMapping, (BiConsumer<class_2960, Supplier<JsonElement>>)generator.field_22831);
        generator.field_22830.accept(BlockStateProvider.createBlock(block, model));
        generator.method_25537(block.method_8389());
    }

    public static void createFourBiteFood(class_4910 generator, class_2248 block) {
        List<class_2960> resourceLocations = List.of(class_4941.method_25843((class_2248)block, (String)""), class_4941.method_25843((class_2248)block, (String)"_bite1"), class_4941.method_25843((class_2248)block, (String)"_bite2"), class_4941.method_25843((class_2248)block, (String)"_bite3"), class_4941.method_25843((class_2248)block, (String)"_bite4"));
        generator.field_22830.accept(BlockStateProvider.createFourBiteBlock(block, resourceLocations));
        generator.method_25623(block, resourceLocations.get(0));
    }

    public static void createJar(class_4910 generator, class_2248 block) {
        List<class_2960> resourceLocations = List.of(class_4941.method_25843((class_2248)block, (String)"_one_jar"), class_4941.method_25843((class_2248)block, (String)"_two_jars"), class_4941.method_25843((class_2248)block, (String)"_three_jars"), class_4941.method_25843((class_2248)block, (String)"_four_jars"), class_4941.method_25843((class_2248)block, (String)"_five_jars"), class_4941.method_25843((class_2248)block, (String)"_on_shelf_one_jar"), class_4941.method_25843((class_2248)block, (String)"_on_shelf_two_jars"), class_4941.method_25843((class_2248)block, (String)"_on_shelf_three_jars"), class_4941.method_25843((class_2248)block, (String)"_on_shelf_four_jars"), class_4941.method_25843((class_2248)block, (String)"_on_shelf_five_jars"));
        generator.field_22830.accept(BlockStateProvider.createFiveWayDirectionalFiveStackBlock(block, resourceLocations));
        generator.method_25623(block, resourceLocations.get(4));
    }

    public static void createJamJar(class_4910 generator, class_2248 block) {
        class_4944 textureMapping = new class_4944().method_25868(class_4945.field_23010, TextureMappings.food(block, "jam_jar", ""));
        String[] suffixes = new String[]{"_one_jar", "_two_jars", "_three_jars", "_four_jars", "_five_jars", "_on_shelf_one_jar", "_on_shelf_two_jars", "_on_shelf_three_jars", "_on_shelf_four_jars", "_on_shelf_five_jars"};
        ArrayList<class_2960> models = new ArrayList<class_2960>(suffixes.length);
        for (String suffix : suffixes) {
            class_2960 resourceLocation = ModelTemplates.createTemplate("template_jam_jar" + suffix, suffix, class_4945.field_23010).method_25846(block, textureMapping, generator.field_22831);
            models.add(resourceLocation);
        }
        generator.field_22830.accept(BlockStateProvider.createFiveWayDirectionalFiveStackBlock(block, models));
        BlockModelProvider.delegateItemModel(generator, block, (class_2960)models.get(0));
    }

    public static void createHangingFood(class_4910 generator, class_2248 block) {
        String path = class_7923.field_41175.method_10221((Object)block).method_12832();
        class_4944 textureMapping = new class_4944().method_25868(class_4945.field_23011, TextureMappings.food(block, "hanging_food", ""));
        class_2960 model = ModelTemplates.createTemplate("template_cross", "", class_4945.field_23011).method_25846(block, textureMapping, generator.field_22831);
        generator.field_22830.accept(BlockStateProvider.createBlock(block, model));
        BlockModelProvider.createSimpleFlatItemModel(generator, block, Category.FOOD, "hanging_food", path);
    }

    public static void createDoubleHangingFood(class_4910 generator, class_2248 block) {
        String path = class_7923.field_41175.method_10221((Object)block).method_12832();
        class_2960 top = TextureMappings.food(block, "hanging_food", "_top");
        class_2960 bottom = TextureMappings.food(block, "hanging_food", "_bottom");
        class_4944 textureMapping = new class_4944().method_25868(class_4945.field_23015, top).method_25868(class_4945.field_23014, bottom);
        class_2960 model = ModelTemplates.createTemplate("template_double_cross", "", class_4945.field_23015, class_4945.field_23014).method_25846(block, textureMapping, generator.field_22831);
        generator.field_22830.accept(BlockStateProvider.createBlock(block, model));
        BlockModelProvider.createSimpleFlatItemModel(generator, block, Category.FOOD, "hanging_food", path + "_bottom");
    }

    public static void createCrop(class_4910 generator, class_2248 block) {
        String[] suffixes = new String[]{"_stage0", "_stage1", "_stage2", "_stage3"};
        ArrayList<class_2960> models = new ArrayList<class_2960>(suffixes.length);
        for (String suffix : suffixes) {
            class_4944 textureMapping = new class_4944().method_25868(class_4945.field_23011, TextureMappings.getTextureFromCategoryFolder(block, Category.PLANTS, "parsley", suffix));
            class_2960 resourceLocation = ModelTemplates.createTemplate("template_parsley", suffix, class_4945.field_23011).method_25846(block, textureMapping, generator.field_22831);
            models.add(resourceLocation);
        }
        generator.field_22830.accept(BlockStateProvider.createCropBlock(block, models));
        generator.method_25540(block);
    }

    public static void createKeg(class_4910 generator) {
        class_2248 block = BlockRegistry.KEG;
        class_2960 top = TextureMappings.storage(block, "keg", "_top");
        class_2960 bottom = TextureMappings.storage(block, "keg", "_bottom");
        class_2960 side = TextureMappings.storage(block, "keg", "_side");
        class_2960 inside = TextureMappings.storage(block, "keg", "_inside");
        class_2960 front = TextureMappings.storage(block, "keg", "_stand");
        class_4944 textureMapping1 = new class_4944().method_25868(class_4945.field_23014, bottom).method_25868(class_4945.field_23018, side).method_25868(class_4945.field_27791, inside).method_25868(class_4945.field_23012, side);
        class_4944 textureMapping2 = textureMapping1.method_25868(class_4945.field_23015, top);
        class_4944 textureMapping3 = textureMapping1.method_25868(class_4945.field_23016, front);
        class_4944 textureMapping4 = textureMapping1.method_25868(class_4945.field_23015, top).method_25868(class_4945.field_23016, front);
        class_2960 verticalEmptyModel = ModelTemplates.createOBJTemplate("keg", "_empty", class_4945.field_23014, class_4945.field_23018, class_4945.field_27791, class_4945.field_23012).create(block, textureMapping1, (BiConsumer<class_2960, Supplier<JsonElement>>)generator.field_22831);
        class_2960 verticalModel = ModelTemplates.createOBJTemplate("keg", "", class_4945.field_23015, class_4945.field_23014, class_4945.field_23018, class_4945.field_27791, class_4945.field_23012).create(block, textureMapping2, (BiConsumer<class_2960, Supplier<JsonElement>>)generator.field_22831);
        class_2960 horizontalEmptyModel = ModelTemplates.createOBJTemplate("keg", "_horizontal_empty", class_4945.field_23014, class_4945.field_23018, class_4945.field_27791, class_4945.field_23016, class_4945.field_23012).create(block, textureMapping3, (BiConsumer<class_2960, Supplier<JsonElement>>)generator.field_22831);
        class_2960 horizontalModel = ModelTemplates.createOBJTemplate("keg", "_horizontal", class_4945.field_23015, class_4945.field_23014, class_4945.field_23018, class_4945.field_27791, class_4945.field_23016, class_4945.field_23012).create(block, textureMapping4, (BiConsumer<class_2960, Supplier<JsonElement>>)generator.field_22831);
        generator.field_22830.accept(class_4925.method_25769((class_2248)block).method_25775((class_4926)class_4926.method_25784((class_2769)BlockStateProperties.FACING, (class_2769)BlockStateProperties.EMPTY).method_25797((Comparable)class_2350.field_11033, (Comparable)Boolean.valueOf(false), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)verticalModel).method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22892)).method_25797((Comparable)class_2350.field_11036, (Comparable)Boolean.valueOf(false), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)verticalModel)).method_25797((Comparable)class_2350.field_11043, (Comparable)Boolean.valueOf(false), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)horizontalModel)).method_25797((Comparable)class_2350.field_11034, (Comparable)Boolean.valueOf(false), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)horizontalModel).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891)).method_25797((Comparable)class_2350.field_11035, (Comparable)Boolean.valueOf(false), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)horizontalModel).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892)).method_25797((Comparable)class_2350.field_11039, (Comparable)Boolean.valueOf(false), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)horizontalModel).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893)).method_25797((Comparable)class_2350.field_11033, (Comparable)Boolean.valueOf(true), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)verticalEmptyModel).method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22892)).method_25797((Comparable)class_2350.field_11036, (Comparable)Boolean.valueOf(true), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)verticalEmptyModel)).method_25797((Comparable)class_2350.field_11043, (Comparable)Boolean.valueOf(true), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)horizontalEmptyModel)).method_25797((Comparable)class_2350.field_11034, (Comparable)Boolean.valueOf(true), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)horizontalEmptyModel).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891)).method_25797((Comparable)class_2350.field_11035, (Comparable)Boolean.valueOf(true), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)horizontalEmptyModel).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892)).method_25797((Comparable)class_2350.field_11039, (Comparable)Boolean.valueOf(true), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)horizontalEmptyModel).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893))));
        BlockModelProvider.delegateItemModel(generator, block, verticalModel);
    }

    public static void createBarrel(class_4910 generator, class_2248 block, BarrelType type) {
        class_2960 top = TextureMappings.storage(block, "barrel", "_top");
        class_2960 bottom = TextureMappings.storage(block, "barrel", "_bottom");
        class_2960 side = TextureMappings.storage(block, "barrel", "_side");
        class_4944 textureMapping = new class_4944().method_25868(class_4945.field_23015, top).method_25868(class_4945.field_23014, bottom).method_25868(class_4945.field_23018, side).method_25868(class_4945.field_23012, top);
        class_2960 model = ModelTemplates.createOBJTemplate(type.method_15434(), "", class_4945.field_23015, class_4945.field_23014, class_4945.field_23018, class_4945.field_23012).create(block, textureMapping, (BiConsumer<class_2960, Supplier<JsonElement>>)generator.field_22831);
        class_2960 emptyModel = ModelTemplates.createOBJTemplate(type.method_15434(), "_empty", class_4945.field_23015, class_4945.field_23014, class_4945.field_23018, class_4945.field_23012).create(block, textureMapping, (BiConsumer<class_2960, Supplier<JsonElement>>)generator.field_22831);
        generator.field_22830.accept(BlockStateProvider.createBarrel(block, model, emptyModel));
        BlockModelProvider.delegateItemModel(generator, block, model);
    }

    public static void createBarrel(class_4910 generator) {
        class_2248 block = BlockRegistry.BROKEN_BARREL;
        class_2248 parent = BlockRegistry.RUSTY_BARREL;
        class_2960 top = TextureMappings.storage(parent, "barrel", "_top");
        class_2960 bottom = TextureMappings.storage(parent, "barrel", "_bottom");
        class_2960 side = TextureMappings.storage(parent, "barrel", "_side");
        class_4944 textureMapping = new class_4944().method_25868(class_4945.field_23015, top).method_25868(class_4945.field_23014, bottom).method_25868(class_4945.field_23018, side).method_25868(class_4945.field_23012, top);
        class_2960 resourceLocation1 = ModelTemplates.createOBJTemplate("broken_barrel", "_down", class_4945.field_23015, class_4945.field_23014, class_4945.field_23018, class_4945.field_23012).create(block, textureMapping, (BiConsumer<class_2960, Supplier<JsonElement>>)generator.field_22831);
        class_2960 resourceLocation2 = ModelTemplates.createOBJTemplate("broken_barrel", "_up", class_4945.field_23015, class_4945.field_23014, class_4945.field_23018, class_4945.field_23012).create(block, textureMapping, (BiConsumer<class_2960, Supplier<JsonElement>>)generator.field_22831);
        class_2960 resourceLocation3 = ModelTemplates.createOBJTemplate("broken_barrel", "_horizontal", class_4945.field_23015, class_4945.field_23014, class_4945.field_23018, class_4945.field_23012).create(block, textureMapping, (BiConsumer<class_2960, Supplier<JsonElement>>)generator.field_22831);
        generator.field_22830.accept(class_4925.method_25769((class_2248)block).method_25775((class_4926)class_4926.method_25783((class_2769)BlockStateProperties.FACING).method_25793((Comparable)class_2350.field_11033, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)resourceLocation1)).method_25793((Comparable)class_2350.field_11036, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)resourceLocation2)).method_25793((Comparable)class_2350.field_11043, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)resourceLocation3)).method_25793((Comparable)class_2350.field_11034, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)resourceLocation3).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891)).method_25793((Comparable)class_2350.field_11035, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)resourceLocation3).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892)).method_25793((Comparable)class_2350.field_11039, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)resourceLocation3).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893))));
        BlockModelProvider.delegateItemModel(generator, block, resourceLocation2);
    }

    public static void createTallBarrel(class_4910 generator) {
        class_2248 block = BlockRegistry.TALL_BARREL;
        class_2960 top = TextureMappings.storage(block, "tall_barrel", "_top");
        class_2960 bottom = TextureMappings.storage(block, "tall_barrel", "_bottom");
        class_2960 upper = TextureMappings.storage(block, "tall_barrel", "_upper");
        class_2960 lower = TextureMappings.storage(block, "tall_barrel", "_lower");
        class_4944 textureMapping1 = new class_4944().method_25868(class_4945.field_23014, bottom).method_25868(TextureSlots.LOWER, lower).method_25868(class_4945.field_23012, lower);
        class_4944 textureMapping2 = new class_4944().method_25868(class_4945.field_23015, top).method_25868(TextureSlots.LOWER, lower).method_25868(TextureSlots.UPPER, upper).method_25868(class_4945.field_23012, upper);
        class_4944 textureMapping3 = textureMapping2.method_25868(class_4945.field_23014, bottom);
        class_2960 lowerModel = ModelTemplates.createOBJTemplate("tall_barrel", "_lower", class_4945.field_23014, TextureSlots.LOWER, class_4945.field_23012).create(block, textureMapping1, (BiConsumer<class_2960, Supplier<JsonElement>>)generator.field_22831);
        class_2960 upperModel = ModelTemplates.createOBJTemplate("tall_barrel", "_upper", class_4945.field_23015, TextureSlots.LOWER, TextureSlots.UPPER, class_4945.field_23012).create(block, textureMapping2, (BiConsumer<class_2960, Supplier<JsonElement>>)generator.field_22831);
        class_2960 itemModel = ModelTemplates.createOBJTemplate("tall_barrel", "_inventory", class_4945.field_23015, class_4945.field_23014, TextureSlots.LOWER, TextureSlots.UPPER, class_4945.field_23012).create(block, textureMapping3, (BiConsumer<class_2960, Supplier<JsonElement>>)generator.field_22831);
        generator.field_22830.accept(BlockStateProvider.createTallBlock(block, lowerModel, upperModel));
        BlockModelProvider.delegateItemModel(generator, block, itemModel);
    }

    public static void createSmallBarrel(class_4910 generator) {
        class_2248 block = BlockRegistry.SMALL_BARREL;
        class_2960 top = TextureMappings.storage(block, "small_barrel", "_top");
        class_2960 side1 = TextureMappings.storage(block, "small_barrel", "_side1");
        class_2960 side2 = TextureMappings.storage(block, "small_barrel", "_side2");
        class_4944 textureMapping = new class_4944().method_25868(class_4945.field_23015, top).method_25868(TextureSlots.SIDE1, side1).method_25868(TextureSlots.SIDE2, side2).method_25868(class_4945.field_23012, top);
        class_2960 resourceLocation1 = ModelTemplates.createOBJTemplate("small_barrel", "_one_barrel", class_4945.field_23015, TextureSlots.SIDE1, class_4945.field_23012).create(block, textureMapping, (BiConsumer<class_2960, Supplier<JsonElement>>)generator.field_22831);
        class_2960 resourceLocation2 = ModelTemplates.createOBJTemplate("small_barrel", "_two_barrels", class_4945.field_23015, TextureSlots.SIDE1, TextureSlots.SIDE2, class_4945.field_23012).create(block, textureMapping, (BiConsumer<class_2960, Supplier<JsonElement>>)generator.field_22831);
        class_2960 resourceLocation3 = ModelTemplates.createOBJTemplate("small_barrel", "_three_barrels", class_4945.field_23015, TextureSlots.SIDE1, TextureSlots.SIDE2, class_4945.field_23012).create(block, textureMapping, (BiConsumer<class_2960, Supplier<JsonElement>>)generator.field_22831);
        class_2960 resourceLocation4 = ModelTemplates.createOBJTemplate("small_barrel", "_four_barrels", class_4945.field_23015, TextureSlots.SIDE1, TextureSlots.SIDE2, class_4945.field_23012).create(block, textureMapping, (BiConsumer<class_2960, Supplier<JsonElement>>)generator.field_22831);
        class_2960 resourceLocation5 = ModelTemplates.createOBJTemplate("small_barrel", "_four_barrels_alt", class_4945.field_23015, TextureSlots.SIDE1, TextureSlots.SIDE2, class_4945.field_23012).create(block, textureMapping, (BiConsumer<class_2960, Supplier<JsonElement>>)generator.field_22831);
        generator.field_22830.accept(class_4925.method_25769((class_2248)block).method_25775((class_4926)class_4926.method_25783((class_2769)BlockStateProperties.STACK_4).method_25793((Comparable)Integer.valueOf(1), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)resourceLocation1)).method_25794((Comparable)Integer.valueOf(2), Arrays.asList(BlockStateProvider.createRotatedVariants(resourceLocation2))).method_25794((Comparable)Integer.valueOf(3), Arrays.asList(BlockStateProvider.createRotatedVariants(resourceLocation3))).method_25794((Comparable)Integer.valueOf(4), Arrays.asList(BlockStateProvider.createRotatedVariants(resourceLocation4, resourceLocation5)))));
        BlockModelProvider.delegateItemModel(generator, block, resourceLocation5);
    }

    public static void createButterChurn(class_4910 generator) {
        class_2248 block = BlockRegistry.BUTTER_CHURN;
        class_2960 top = TextureMappings.storage(block, "butter_churn", "_top");
        class_2960 bottom = TextureMappings.storage(block, "butter_churn", "_bottom");
        class_2960 side = TextureMappings.storage(block, "butter_churn", "_side");
        class_2960 other = TextureMappings.storage(block, "butter_churn", "_stick");
        class_4944 textureMapping1 = new class_4944().method_25868(class_4945.field_23015, top).method_25868(class_4945.field_23014, bottom).method_25868(class_4945.field_23018, side).method_25868(class_4945.field_23012, side);
        class_4944 textureMapping2 = new class_4944().method_25868(class_4945.field_23015, top).method_25868(class_4945.field_23014, bottom).method_25868(class_4945.field_23018, side).method_25868(TextureSlots.OTHER, other);
        class_2960 model = ModelTemplates.createOBJTemplate("butter_churn", "", class_4945.field_23015, class_4945.field_23014, class_4945.field_23018, class_4945.field_23012).create(block, textureMapping1, (BiConsumer<class_2960, Supplier<JsonElement>>)generator.field_22831);
        class_2960 itemModel = ModelTemplates.createOBJTemplate("butter_churn", "_inventory", class_4945.field_23015, class_4945.field_23014, class_4945.field_23018, TextureSlots.OTHER).create(block, textureMapping2, (BiConsumer<class_2960, Supplier<JsonElement>>)generator.field_22831);
        generator.field_22830.accept(BlockStateProvider.createHorizontalDirectionalBlock(block, model));
        BlockModelProvider.delegateItemModel(generator, block, itemModel);
    }

    public static void createHangingBarrel(class_4910 generator) {
        class_2248 block = BlockRegistry.HANGING_BARREL;
        class_2960 top = TextureMappings.storage(block, "hanging_barrel", "_top");
        class_2960 bottom = TextureMappings.storage(block, "hanging_barrel", "_bottom");
        class_2960 side = TextureMappings.storage(block, "hanging_barrel", "_side");
        class_2960 other = TextureMappings.getTextureFromDirectResource(block, Category.MISCELLANEOUS, "rope", "thin_knotted_rope");
        class_4944 textureMapping = new class_4944().method_25868(class_4945.field_23015, top).method_25868(class_4945.field_23014, bottom).method_25868(class_4945.field_23018, side).method_25868(TextureSlots.OTHER, other).method_25868(class_4945.field_23012, top);
        class_2960 model = ModelTemplates.createOBJTemplate("hanging_barrel", Parent.TALL_BLOCK, "", class_4945.field_23015, class_4945.field_23014, class_4945.field_23018, TextureSlots.OTHER, class_4945.field_23012).create(block, textureMapping, (BiConsumer<class_2960, Supplier<JsonElement>>)generator.field_22831);
        generator.field_22830.accept(BlockStateProvider.createHorizontalDirectionalBlock(block, model));
        BlockModelProvider.delegateItemModel(generator, block, model);
    }

    public static void createWoodenBucket(class_4910 generator) {
        class_2248 block = BlockRegistry.WOODEN_BUCKET;
        class_2960 bottom = TextureMappings.storage(block, "wooden_bucket", "_bottom");
        class_2960 side = TextureMappings.storage(block, "wooden_bucket", "_side");
        class_2960 inside = TextureMappings.storage(block, "wooden_bucket", "_inside");
        class_4944 textureMapping = new class_4944().method_25868(class_4945.field_23014, bottom).method_25868(class_4945.field_23018, side).method_25868(class_4945.field_27791, inside).method_25868(class_4945.field_23012, side);
        class_2960 model = ModelTemplates.createOBJTemplate("wooden_bucket", "", class_4945.field_23014, class_4945.field_23018, class_4945.field_27791, class_4945.field_23012).create(block, textureMapping, (BiConsumer<class_2960, Supplier<JsonElement>>)generator.field_22831);
        generator.field_22830.accept(BlockStateProvider.createBlock(block, model));
        BlockModelProvider.delegateItemModel(generator, block, model);
    }

    public static void createLayeredWoodenBucket(class_4910 generator, class_2248 block) {
        class_2248 waterBucket = BlockRegistry.WATER_BUCKET;
        class_2960 texture = block == waterBucket ? class_4944.method_25866((class_2248)class_2246.field_10382, (String)"_still") : TextureMappings.storage(block, "wooden_bucket", "");
        class_4944 textureMapping = new class_4944().method_25868(class_4945.field_23011, texture).method_25868(class_4945.field_23012, texture);
        class_2960 resourceLocation1 = ModelTemplates.createOBJTemplate("wooden_bucket", "_layer1", class_4945.field_23011).create(block, textureMapping, (BiConsumer<class_2960, Supplier<JsonElement>>)generator.field_22831);
        class_2960 resourceLocation2 = ModelTemplates.createOBJTemplate("wooden_bucket", "_layer2", class_4945.field_23011).create(block, textureMapping, (BiConsumer<class_2960, Supplier<JsonElement>>)generator.field_22831);
        class_2960 resourceLocation3 = ModelTemplates.createOBJTemplate("wooden_bucket", "_layer3", class_4945.field_23011).create(block, textureMapping, (BiConsumer<class_2960, Supplier<JsonElement>>)generator.field_22831);
        class_2960 resourceLocation4 = ModelTemplates.createOBJTemplate("wooden_bucket", "_layer4", class_4945.field_23011).create(block, textureMapping, (BiConsumer<class_2960, Supplier<JsonElement>>)generator.field_22831);
        class_2960 resourceLocation5 = class_4941.method_25842((class_2248)BlockRegistry.WOODEN_BUCKET);
        generator.field_22830.accept(class_4922.method_25758((class_2248)block).method_25763(class_4935.method_25824().method_25828(class_4936.field_22887, (Object)resourceLocation5)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)BlockStateProperties.LEVEL_BUCKET, (Comparable)Integer.valueOf(1)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)resourceLocation1)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)BlockStateProperties.LEVEL_BUCKET, (Comparable)Integer.valueOf(2)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)resourceLocation2)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)BlockStateProperties.LEVEL_BUCKET, (Comparable)Integer.valueOf(3)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)resourceLocation3)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)BlockStateProperties.LEVEL_BUCKET, (Comparable)Integer.valueOf(4)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)resourceLocation4)));
        generator.method_25540(block);
    }

    public static void createLargeBucket(class_4910 generator, class_2248 block) {
        class_2960 texture = TextureMappings.storage(block, "large_bucket", "");
        class_4944 textureMapping = new class_4944().method_25868(class_4945.field_23011, texture).method_25868(class_4945.field_23012, texture);
        class_2960 model = ModelTemplates.createOBJTemplate("large_bucket", "", class_4945.field_23011, class_4945.field_23012).create(block, textureMapping, (BiConsumer<class_2960, Supplier<JsonElement>>)generator.field_22831);
        generator.field_22830.accept(BlockStateProvider.createBlock(block, model));
        BlockModelProvider.delegateItemModel(generator, block, model);
    }

    public static void createLargeBucket(class_4910 generator) {
        class_2248 block = BlockRegistry.LARGE_WOODEN_BUCKET_WITH_CLOTH;
        class_2960 texture = TextureMappings.storage(block, "large_bucket", "");
        class_2960 top = TextureMappings.storage(block, "large_bucket", "_top");
        class_2960 side = TextureMappings.storage(block, "large_bucket", "_detail");
        class_4944 textureMapping = new class_4944().method_25868(class_4945.field_23011, texture).method_25868(class_4945.field_23015, top).method_25868(class_4945.field_23018, side).method_25868(class_4945.field_23012, texture);
        class_2960 model = ModelTemplates.createOBJTemplate("large_bucket_with_content", "", class_4945.field_23011, class_4945.field_23015, class_4945.field_23018, class_4945.field_23012).create(block, textureMapping, (BiConsumer<class_2960, Supplier<JsonElement>>)generator.field_22831);
        generator.field_22830.accept(BlockStateProvider.createBlock(block, model));
        BlockModelProvider.delegateItemModel(generator, block, model);
    }

    public static void createWickerBasket(class_4910 generator, class_2248 block) {
        class_2960 top = TextureMappings.storage(block, "wicker_basket", "_top");
        class_2960 bottom = TextureMappings.storage(block, "wicker_basket", "_bottom");
        class_2960 side = TextureMappings.storage(block, "wicker_basket", "_side");
        class_4944 textureMapping = new class_4944().method_25868(class_4945.field_23015, top).method_25868(class_4945.field_23014, bottom).method_25868(class_4945.field_23018, side).method_25868(class_4945.field_23012, side);
        class_2960 model = ModelTemplates.createTemplate("template_wicker_basket", "", class_4945.field_23015, class_4945.field_23014, class_4945.field_23018, class_4945.field_23012).method_25846(block, textureMapping, generator.field_22831);
        generator.field_22830.accept(BlockStateProvider.createBlock(block, model));
        BlockModelProvider.delegateItemModel(generator, block, model);
    }

    public static void createWoodenCrate(class_4910 generator) {
        class_2248 block = BlockRegistry.WOODEN_CRATE;
        class_2960 resourceLocation1 = class_4941.method_25842((class_2248)block);
        class_2960 resourceLocation2 = class_4941.method_25843((class_2248)block, (String)"_double");
        generator.field_22830.accept(BlockStateProvider.createDirectionalTwoStackBlock(block, resourceLocation1, resourceLocation2));
        BlockModelProvider.delegateItemModel(generator, block, resourceLocation1);
    }

    public static void createWoodenCrate(class_4910 generator, class_2248 block) {
        class_2248 block1 = BlockRegistry.WOODEN_CRATE;
        class_2960 top = TextureMappings.storage(block, "wooden_crate", "");
        class_2960 bottom = TextureMappings.storage(block1, "wooden_crate", "_bottom");
        class_2960 side = TextureMappings.storage(block1, "wooden_crate", "_side");
        class_2960 front = TextureMappings.storage(block1, "wooden_crate", "_front");
        class_4944 textureMapping = new class_4944().method_25868(class_4945.field_23015, top).method_25868(class_4945.field_23014, bottom).method_25868(class_4945.field_23018, side).method_25868(class_4945.field_23016, front);
        class_2960 resourceLocation1 = ModelTemplates.createTemplate("template_wooden_crate", "", class_4945.field_23015, class_4945.field_23014, class_4945.field_23018, class_4945.field_23016).method_25846(block, textureMapping, generator.field_22831);
        class_2960 resourceLocation2 = ModelTemplates.createTemplate("template_wooden_crate_double", "_double", class_4945.field_23015, class_4945.field_23014, class_4945.field_23018, class_4945.field_23016).method_25846(block, textureMapping, generator.field_22831);
        generator.field_22830.accept(BlockStateProvider.createDirectionalTwoStackBlock(block, resourceLocation1, resourceLocation2));
        BlockModelProvider.delegateItemModel(generator, block, resourceLocation1);
    }

    public static void createEmptyLargeCrate(class_4910 generator) {
        class_2248 block = BlockRegistry.EMPTY_LARGE_CRATE;
        class_2960 resourceLocation1 = class_4941.method_25842((class_2248)block);
        class_2960 resourceLocation2 = class_4941.method_25843((class_2248)block, (String)"_alt");
        generator.field_22830.accept(BlockStateProvider.createRotatedVariants(block, resourceLocation1, resourceLocation2));
        BlockModelProvider.delegateItemModel(generator, block, resourceLocation1);
    }

    public static void createSack(class_4910 generator) {
        class_2248 block = BlockRegistry.SACK;
        class_2960 texture = TextureMappings.getTextureFromDirectResource(block, Category.STORAGE, "sack");
        class_4944 textureMapping = new class_4944().method_25868(class_4945.field_23011, texture).method_25868(class_4945.field_23012, texture);
        class_2960 model = ModelTemplates.createOBJTemplate("sack", Parent.SMALL_BLOCK, "", class_4945.field_23011, class_4945.field_23012).create(block, textureMapping, (BiConsumer<class_2960, Supplier<JsonElement>>)generator.field_22831);
        generator.field_22830.accept(BlockStateProvider.createBlock(block, model));
        BlockModelProvider.delegateItemModel(generator, block, model);
    }

    public static void createBurlapSack(class_4910 generator) {
        class_2248 block = BlockRegistry.BURLAP_SACK;
        class_2960 bottom = TextureMappings.storage(block, "burlap_sack", "_bottom");
        class_2960 side = TextureMappings.storage(block, "burlap_sack", "_side");
        class_4944 textureMapping = new class_4944().method_25868(class_4945.field_23014, bottom).method_25868(class_4945.field_23018, side).method_25868(class_4945.field_23012, side);
        class_2960 resourceLocation1 = ModelTemplates.createOBJTemplate("burlap_sack", "_one_sack", class_4945.field_23014, class_4945.field_23018, class_4945.field_23012).create(block, textureMapping, (BiConsumer<class_2960, Supplier<JsonElement>>)generator.field_22831);
        class_2960 resourceLocation2 = ModelTemplates.createOBJTemplate("burlap_sack", "_one_sack_horizontal", class_4945.field_23014, class_4945.field_23018, class_4945.field_23012).create(block, textureMapping, (BiConsumer<class_2960, Supplier<JsonElement>>)generator.field_22831);
        class_2960 resourceLocation3 = ModelTemplates.createOBJTemplate("burlap_sack", "_two_sacks", class_4945.field_23014, class_4945.field_23018, class_4945.field_23012).create(block, textureMapping, (BiConsumer<class_2960, Supplier<JsonElement>>)generator.field_22831);
        class_2960 resourceLocation4 = ModelTemplates.createOBJTemplate("burlap_sack", "_two_sacks_horizontal", class_4945.field_23014, class_4945.field_23018, class_4945.field_23012).create(block, textureMapping, (BiConsumer<class_2960, Supplier<JsonElement>>)generator.field_22831);
        generator.field_22830.accept(BlockStateProvider.createBurlapSack(block, resourceLocation1, resourceLocation2, resourceLocation3, resourceLocation4));
        BlockModelProvider.delegateItemModel(generator, block, resourceLocation1);
    }

    public static void createBurlapSack(class_4910 generator, class_2248 block) {
        class_2248 block1 = BlockRegistry.BURLAP_SACK;
        class_2960 top = TextureMappings.storage(block, "burlap_sack", "");
        class_2960 bottom = TextureMappings.storage(block1, "burlap_sack", "_bottom");
        class_2960 side = TextureMappings.storage(block1, "burlap_sack", "_side");
        class_4944 textureMapping = new class_4944().method_25868(class_4945.field_23015, top).method_25868(class_4945.field_23014, bottom).method_25868(class_4945.field_23018, side).method_25868(class_4945.field_23012, side);
        class_2960 resourceLocation = ModelTemplates.createOBJTemplate("burlap_sack_with_content", "", class_4945.field_23015, class_4945.field_23014, class_4945.field_23018, class_4945.field_23012).create(block, textureMapping, (BiConsumer<class_2960, Supplier<JsonElement>>)generator.field_22831);
        generator.field_22830.accept(BlockStateProvider.createHorizontalDirectionalBlock(block, resourceLocation));
        BlockModelProvider.delegateItemModel(generator, block, resourceLocation);
    }

    public static void createCookware(class_4910 generator, class_2248 block) {
        BlockModelProvider.createCookware(generator, block, block, false);
    }

    public static void createCookware(class_4910 generator, class_2248 block, class_2248 parent) {
        BlockModelProvider.createCookware(generator, block, parent, false);
    }

    public static void createCauldron(class_4910 generator) {
        class_2248 block = BlockRegistry.CAST_IRON_CAULDRON;
        BlockModelProvider.createCookware(generator, block, block, true);
    }

    public static void createCookware(class_4910 generator, class_2248 block, class_2248 parent, Boolean bl) {
        class_2960 resourceLocation1 = class_7923.field_41175.method_10221((Object)block);
        class_2960 resourceLocation2 = class_7923.field_41175.method_10221((Object)parent);
        String path1 = resourceLocation1.method_12832();
        String path2 = resourceLocation2.method_12832();
        String path3 = bl != false ? resourceLocation2.method_12832() : "cast_iron_cookware";
        class_2960 top = TextureMappings.getTextureFromDirectResource(block, Category.DECORATION, "cookware", path2 + "_top");
        class_2960 side = TextureMappings.getTextureFromDirectResource(block, Category.DECORATION, "cookware", path2 + "_side");
        class_2960 bottom = TextureMappings.getTextureFromDirectResource(block, Category.DECORATION, "cookware", path3 + "_bottom");
        class_2960 layer = TextureMappings.getTextureFromDirectResource(block, Category.DECORATION, "cookware", "cast_iron_cookware_top");
        class_4944 textureMapping1 = new class_4944().method_25868(class_4945.field_23015, top).method_25868(class_4945.field_23014, bottom).method_25868(class_4945.field_23018, side).method_25868(class_4945.field_23012, top);
        class_4944 textureMapping2 = textureMapping1.method_25868(TextureSlots.LAYER, layer);
        class_2960 resourceLocation3 = ModelTemplates.createOBJTemplate(path1, Parent.SMALL_BLOCK, "", class_4945.field_23015, class_4945.field_23014, class_4945.field_23018, class_4945.field_23012).create(block, textureMapping1, (BiConsumer<class_2960, Supplier<JsonElement>>)generator.field_22831);
        class_2960 resourceLocation4 = ModelTemplates.createOBJTemplate(path1, "_filled", class_4945.field_23015, class_4945.field_23014, class_4945.field_23018, TextureSlots.LAYER, class_4945.field_23012).create(block, textureMapping2, (BiConsumer<class_2960, Supplier<JsonElement>>)generator.field_22831);
        generator.field_22830.accept(class_4925.method_25769((class_2248)block).method_25775(BlockStateProvider.createBooleanModelDispatch(BlockStateProperties.TOGGLE, resourceLocation3, resourceLocation4)));
        BlockModelProvider.delegateItemModel(generator, block, resourceLocation3);
    }

    public static void createCookware(class_4910 generator, class_2248 block, String resourceLocation) {
        class_2960 texture = TextureMappings.decoration(block, "cookware", "");
        class_4944 textureMapping = new class_4944().method_25868(class_4945.field_23011, texture).method_25868(class_4945.field_23012, texture);
        class_2960 model = ModelTemplates.createOBJTemplate(resourceLocation, Parent.SMALL_BLOCK, "", class_4945.field_23011, class_4945.field_23012).create(block, textureMapping, (BiConsumer<class_2960, Supplier<JsonElement>>)generator.field_22831);
        generator.field_22830.accept(BlockStateProvider.createBlock(block, model));
        BlockModelProvider.delegateItemModel(generator, block, model);
    }

    public static void createWallShelf(class_4910 generator) {
        class_2248 block = BlockRegistry.OLD_WOOD_WALL_SHELF;
        List<class_2960> resourceLocations = List.of(class_4941.method_25843((class_2248)block, (String)""), class_4941.method_25843((class_2248)block, (String)"_left"), class_4941.method_25843((class_2248)block, (String)"_middle"), class_4941.method_25843((class_2248)block, (String)"_right"), class_4941.method_25843((class_2248)block, (String)"_top"), class_4941.method_25843((class_2248)block, (String)"_top_left"), class_4941.method_25843((class_2248)block, (String)"_top_middle"), class_4941.method_25843((class_2248)block, (String)"_top_right"));
        generator.field_22830.accept(BlockStateProvider.createWallShelf(block, resourceLocations));
        generator.method_25623(block, resourceLocations.get(4));
    }

    public static void createHandCart(class_4910 generator) {
        class_2248 block = BlockRegistry.HAND_CART;
        class_2960 all = TextureMappings.getTextureFromDirectResource(block, Category.DECORATION, "hand_cart");
        class_4944 textureMapping = new class_4944().method_25868(class_4945.field_23010, all).method_25868(class_4945.field_23012, all);
        class_2960 headModel = ModelTemplates.createOBJTemplate("hand_cart", "_head", class_4945.field_23010, class_4945.field_23012).create(block, textureMapping, (BiConsumer<class_2960, Supplier<JsonElement>>)generator.field_22831);
        class_2960 footModel = ModelTemplates.createOBJTemplate("hand_cart", "_foot", class_4945.field_23010, class_4945.field_23012).create(block, textureMapping, (BiConsumer<class_2960, Supplier<JsonElement>>)generator.field_22831);
        class_2960 inventory = ModelTemplates.createOBJTemplate("hand_cart", Parent.LARGE_BLOCK, "_inventory", class_4945.field_23010).create(block, textureMapping, (BiConsumer<class_2960, Supplier<JsonElement>>)generator.field_22831);
        generator.field_22830.accept(BlockStateProvider.createDirectionalTwoPartBlock(block, headModel, footModel));
        BlockModelProvider.delegateItemModel(generator, block, inventory);
    }

    public static void createTrestle(class_4910 generator, class_2248 block) {
        boolean flag = block == BlockRegistry.TRESTLE;
        class_2960 all = TextureMappings.getTextureFromDirectResource(block, Category.DECORATION, "trestle", "trestle");
        class_4944 textureMapping = new class_4944().method_25868(class_4945.field_23010, all).method_25868(class_4945.field_23012, all);
        class_2960 resourceLocation1 = flag ? ModelTemplates.createOBJTemplate("trestle", "", class_4945.field_23010, class_4945.field_23012).create(block, textureMapping, (BiConsumer<class_2960, Supplier<JsonElement>>)generator.field_22831) : class_4941.method_25842((class_2248)block);
        class_2960 resourceLocation2 = flag ? ModelTemplates.createOBJTemplate("trestle", "_tilted", class_4945.field_23010, class_4945.field_23012).create(block, textureMapping, (BiConsumer<class_2960, Supplier<JsonElement>>)generator.field_22831) : class_4941.method_25843((class_2248)block, (String)"_tilted");
        generator.field_22830.accept(class_4925.method_25769((class_2248)block).method_25775((class_4926)class_4926.method_25783(BlockStateProperties.AXIS).method_25793((Comparable)class_2350.class_2351.field_11048, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)resourceLocation1)).method_25794((Comparable)class_2350.class_2351.field_11052, Arrays.asList(class_4910.method_25584((class_2960)resourceLocation2))).method_25793((Comparable)class_2350.class_2351.field_11051, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)resourceLocation1).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891))));
        BlockModelProvider.delegateItemModel(generator, block, resourceLocation1);
    }

    public static void createWoodworkingSupplies(class_4910 generator) {
        class_2248 block = BlockRegistry.WOODWORKING_SUPPLIES;
        class_2960 texture1 = TextureMappings.getTextureFromDirectResource(block, Category.DECORATION, "tools", "carpentry_clamp");
        class_2960 texture2 = TextureMappings.getTextureFromDirectResource(block, Category.DECORATION, "tools", "hand_planer");
        class_2960 texture3 = TextureMappings.getTextureFromDirectResource(block, Category.DECORATION, "tools", "hammer");
        class_2960 texture4 = TextureMappings.getTextureFromDirectResource(block, Category.DECORATION, "tools", "nails");
        class_2960 texture5 = TextureMappings.getTextureFromDirectResource(block, Category.MISCELLANEOUS, "scroll", "scroll_holder_paper");
        class_2960 particle = class_4944.method_25860((class_2248)class_2246.field_10161);
        class_4944 textureMapping = new class_4944().method_25868(TextureSlots.TEXTURE1, texture1).method_25868(TextureSlots.TEXTURE2, texture2).method_25868(TextureSlots.TEXTURE3, texture3).method_25868(TextureSlots.TEXTURE4, texture4).method_25868(TextureSlots.TEXTURE5, texture5).method_25868(class_4945.field_23012, particle);
        class_2960 model = ModelTemplates.createOBJTemplate("woodworking_supplies", DisplayConfig.woodworkingSupplies(), "", TextureSlots.TEXTURE1, TextureSlots.TEXTURE2, TextureSlots.TEXTURE3, TextureSlots.TEXTURE4, TextureSlots.TEXTURE5, class_4945.field_23012).create(block, textureMapping, (BiConsumer<class_2960, Supplier<JsonElement>>)generator.field_22831);
        generator.field_22830.accept(BlockStateProvider.createHorizontalDirectionalBlock(block, model));
        BlockModelProvider.delegateItemModel(generator, block, model);
    }

    public static void createWheel(class_4910 generator, class_2248 block) {
        String path = class_7923.field_41175.method_10221((Object)block).method_12832();
        class_2960 side = TextureMappings.getTextureFromDirectResource(block, Category.DECORATION, "wheel", "wheel");
        class_2960 front = TextureMappings.getTextureFromDirectResource(block, Category.DECORATION, "wheel", "wheel_rims");
        class_2960 particle = class_4944.method_25860((class_2248)class_2246.field_10161);
        class_4944 textureMapping = new class_4944().method_25868(class_4945.field_23018, side).method_25868(class_4945.field_23016, front).method_25868(class_4945.field_23012, particle);
        class_2960 model = ModelTemplates.createOBJTemplate(path, "", class_4945.field_23018, class_4945.field_23016, class_4945.field_23012).create(block, textureMapping, (BiConsumer<class_2960, Supplier<JsonElement>>)generator.field_22831);
        generator.field_22830.accept(BlockStateProvider.createFiveWayDirectionalBlock(block, model));
        generator.method_25623(block, model);
    }

    public static void createWheel(class_4910 generator, class_2248 block, class_2248 parent) {
        String path = class_7923.field_41175.method_10221((Object)block).method_12832();
        class_2960 side = TextureMappings.getTextureFromDirectResource(block, Category.DECORATION, "wheel", "wheel");
        class_2960 front = TextureMappings.getTextureFromDirectResource(block, Category.DECORATION, "wheel", "wheel_rims");
        class_2960 particle = class_4944.method_25860((class_2248)class_2246.field_10161);
        class_4944 textureMapping = new class_4944().method_25868(class_4945.field_23018, side).method_25868(class_4945.field_23016, front).method_25868(class_4945.field_23012, particle);
        class_2960 model1 = ModelTemplates.createOBJTemplate(path, "1", class_4945.field_23018, class_4945.field_23016, class_4945.field_23012).create(block, textureMapping, (BiConsumer<class_2960, Supplier<JsonElement>>)generator.field_22831);
        class_2960 model2 = ModelTemplates.createOBJTemplate(path, "2", class_4945.field_23018, class_4945.field_23016, class_4945.field_23012).create(block, textureMapping, (BiConsumer<class_2960, Supplier<JsonElement>>)generator.field_22831);
        class_2960 inventory = class_4941.method_25842((class_2248)parent);
        generator.field_22830.accept(class_4925.method_25769((class_2248)block).method_25775(BlockStateProvider.createHorizontalFacingDispatch()).method_25775(BlockStateProvider.createBooleanModelDispatch(BlockStateProperties.TOGGLE, model1, model2)));
        generator.method_25623(block, inventory);
    }

    public static void createTimbers(class_4910 generator, class_2248 block) {
        String[] suffixes = new String[]{"_one_stack", "_two_stacks", "_three_stacks", "_four_stacks", "_five_stacks"};
        class_4944 textureMapping = new class_4944().method_25868(class_4945.field_23010, TextureMappings.decoration(block, "timbers", ""));
        List<class_2960> models = BlockModelProvider.getResourceLocations(generator, block, textureMapping, suffixes, "template_timbers", class_4945.field_23010);
        generator.field_22830.accept(BlockStateProvider.createDirectionalFiveStackBlock(block, models));
        BlockModelProvider.delegateItemModel(generator, block, models.get(0));
    }

    public static void createWovenSilkPile(class_4910 generator) {
        class_2248 block = BlockRegistry.WOVEN_SILK_PILE;
        List<class_2960> models = List.of(class_4941.method_25843((class_2248)block, (String)"_one_stack1"), class_4941.method_25843((class_2248)block, (String)"_one_stack2"), class_4941.method_25843((class_2248)block, (String)"_two_stacks"), class_4941.method_25843((class_2248)block, (String)"_three_stacks"), class_4941.method_25843((class_2248)block, (String)"_four_stacks"), class_4941.method_25843((class_2248)block, (String)"_five_stacks"), class_4941.method_25843((class_2248)block, (String)"_six_stacks"));
        generator.field_22830.accept(class_4925.method_25769((class_2248)block).method_25775(BlockStateProvider.createHorizontalFacingDispatch()).method_25775((class_4926)class_4926.method_25783((class_2769)BlockStateProperties.STACK_6).method_25794((Comparable)Integer.valueOf(1), Arrays.asList(BlockStateProvider.createVariants(models.get(0), models.get(1)))).method_25793((Comparable)Integer.valueOf(2), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)models.get(2))).method_25793((Comparable)Integer.valueOf(3), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)models.get(3))).method_25793((Comparable)Integer.valueOf(4), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)models.get(4))).method_25793((Comparable)Integer.valueOf(5), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)models.get(5))).method_25793((Comparable)Integer.valueOf(6), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)models.get(6)))));
        generator.method_25623(block, models.get(6));
    }

    public static void createBurlapPile(class_4910 generator) {
        class_2248 block = BlockRegistry.BURLAP_PILE;
        class_2960 top = TextureMappings.getTextureFromDirectResource(block, Category.DECORATION, "burlap_pile");
        class_2960 side = TextureMappings.getTextureFromDirectResource(block, Category.DECORATION, "old_wood");
        String[] suffixes = new String[]{"_one_stack", "_two_stacks", "_three_stacks", "_four_stacks", "_five_stacks", "_six_stacks"};
        class_4944 textureMapping = new class_4944().method_25868(class_4945.field_23015, top).method_25868(class_4945.field_23018, side).method_25868(class_4945.field_23012, top);
        List<class_2960> models = BlockModelProvider.getResourceLocations(generator, block, textureMapping, suffixes, class_4945.field_23015, class_4945.field_23018, class_4945.field_23012);
        generator.field_22830.accept(BlockStateProvider.createDirectionalSixStackBlock(block, models));
        BlockModelProvider.delegateItemModel(generator, block, models.get(5));
    }

    public static void createHangingRug(class_4910 generator, class_2248 block) {
        class_2960 upper = TextureMappings.decoration(block, "hanging_rug", "_upper");
        class_2960 lower = TextureMappings.decoration(block, "hanging_rug", "_lower");
        class_2960 edge = TextureMappings.decoration(block, "hanging_rug", "_edge");
        class_2960 side = TextureMappings.getTextureFromDirectResource(block, Category.DECORATION, "treadle_loom", "treadle_loom_base");
        class_4944 textureMapping1 = new class_4944().method_25868(class_4945.field_23011, lower).method_25868(class_4945.field_23032, edge);
        class_4944 textureMapping2 = new class_4944().method_25868(class_4945.field_23011, upper).method_25868(class_4945.field_23018, side);
        String[] suffixes1 = new String[]{"_lower", "_lower_left", "_lower_middle", "_lower_right"};
        String[] suffixes2 = new String[]{"_upper", "_upper_left", "_upper_middle", "_upper_right"};
        List<class_2960> models1 = BlockModelProvider.getResourceLocations(generator, block, textureMapping1, suffixes1, "template_hanging_rug", class_4945.field_23011, class_4945.field_23032);
        List<class_2960> models2 = BlockModelProvider.getResourceLocations(generator, block, textureMapping2, suffixes2, "template_hanging_rug", class_4945.field_23011, class_4945.field_23018);
        generator.field_22830.accept(BlockStateProvider.createHorizontalConnectedTallBlock(block, models1, models2));
        BlockModelProvider.delegateItemModel(generator, block, models2.get(0));
    }

    public static void createHarrow(class_4910 generator, class_2248 block) {
        String string = class_7923.field_41175.method_10221((Object)block).method_12832();
        class_2960 texture = TextureMappings.getTextureFromDirectResource(block, Category.DECORATION, "harrow");
        class_4944 textureMapping = new class_4944().method_25868(class_4945.field_23010, texture).method_25868(class_4945.field_23012, texture);
        class_2960 headModel = ModelTemplates.createOBJTemplate(string, "_head", class_4945.field_23010, class_4945.field_23012).create(block, textureMapping, (BiConsumer<class_2960, Supplier<JsonElement>>)generator.field_22831);
        class_2960 footModel = ModelTemplates.createOBJTemplate(string, "_foot", class_4945.field_23010, class_4945.field_23012).create(block, textureMapping, (BiConsumer<class_2960, Supplier<JsonElement>>)generator.field_22831);
        class_2960 inventory = ModelTemplates.createOBJTemplate(string, Parent.LARGE_BLOCK, "_inventory", class_4945.field_23010).create(block, textureMapping, (BiConsumer<class_2960, Supplier<JsonElement>>)generator.field_22831);
        generator.field_22830.accept(BlockStateProvider.createDirectionalTwoPartBlock(block, headModel, footModel));
        BlockModelProvider.delegateItemModel(generator, block, inventory);
    }

    public static void createWoodTrough(class_4910 generator) {
        class_2248 block = BlockRegistry.WOOD_TROUGH;
        class_4944 textureMapping = BlockModelProvider.woodTroughTextureMapping(block);
        String[] suffixes = new String[]{"", "_left", "_middle", "_right"};
        List<class_2960> models = BlockModelProvider.getResourceLocations(generator, block, textureMapping, suffixes, class_4945.field_23015, class_4945.field_23018, class_4945.field_23013, class_4945.field_23012);
        generator.field_22830.accept(BlockStateProvider.createHorizontalConnectedDirectionalBlock(block, models.get(0), models.get(1), models.get(2), models.get(3)));
        generator.method_25623(block, models.get(0));
    }

    public static void createWoodTrough(class_4910 generator, class_2248 block) {
        class_2248 parent = BlockRegistry.WOOD_TROUGH;
        boolean flag = block == BlockRegistry.WATER_TROUGH;
        class_2960 layer = TextureMappings.getTextureFromDirectResource(block, Category.DECORATION, "wood_trough", "wood_trough_layer");
        class_2960 waterLayer = class_4944.method_25866((class_2248)class_2246.field_10382, (String)"_still");
        class_4944 textureMapping1 = BlockModelProvider.woodTroughTextureMapping(block);
        class_4944 textureMapping2 = flag ? new class_4944().method_25868(class_4945.field_23010, waterLayer) : new class_4944().method_25868(class_4945.field_23010, layer);
        class_4944 textureMapping3 = flag ? textureMapping1.method_25868(class_4945.field_23010, waterLayer) : textureMapping1.method_25868(class_4945.field_23010, layer);
        String[] suffixes = new String[]{"", "_left", "_middle", "_right"};
        List<class_2960> baseModels = List.of(class_4941.method_25843((class_2248)parent, (String)""), class_4941.method_25843((class_2248)parent, (String)"_left"), class_4941.method_25843((class_2248)parent, (String)"_middle"), class_4941.method_25843((class_2248)parent, (String)"_right"));
        List<class_2960> layerModels = BlockModelProvider.getResourceLocations(generator, block, textureMapping2, suffixes, class_4945.field_23010);
        class_2960 inventory = ModelTemplates.createOBJTemplate(class_7923.field_41175.method_10221((Object)block).method_12832(), "_inventory", class_4945.field_23015, class_4945.field_23018, class_4945.field_23013, class_4945.field_23010).create(block, textureMapping3, (BiConsumer<class_2960, Supplier<JsonElement>>)generator.field_22831);
        class_4922 multiPart = class_4922.method_25758((class_2248)block);
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            int i = switch (direction) {
                case class_2350.field_11034 -> 90;
                case class_2350.field_11035 -> 180;
                case class_2350.field_11039 -> 270;
                default -> 0;
            };
            multiPart.method_25760(class_4918.method_35870((class_4918[])new class_4918[]{class_4918.method_25744().method_25751((class_2769)BlockStateProperties.HORIZONTAL_FACING, (Comparable)direction).method_25751(BlockStateProperties.HORIZONTAL_CONNECTION, (Comparable)((Object)HorizontalConnection.SINGLE))}), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)baseModels.get(0)).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.values()[i / 90]));
            multiPart.method_25760(class_4918.method_35870((class_4918[])new class_4918[]{class_4918.method_25744().method_25751((class_2769)BlockStateProperties.HORIZONTAL_FACING, (Comparable)direction).method_25751(BlockStateProperties.HORIZONTAL_CONNECTION, (Comparable)((Object)HorizontalConnection.SINGLE))}), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)layerModels.get(0)).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.values()[i / 90]));
            multiPart.method_25760(class_4918.method_35870((class_4918[])new class_4918[]{class_4918.method_25744().method_25751((class_2769)BlockStateProperties.HORIZONTAL_FACING, (Comparable)direction).method_25751(BlockStateProperties.HORIZONTAL_CONNECTION, (Comparable)((Object)HorizontalConnection.LEFT))}), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)baseModels.get(1)).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.values()[i / 90]));
            multiPart.method_25760(class_4918.method_35870((class_4918[])new class_4918[]{class_4918.method_25744().method_25751((class_2769)BlockStateProperties.HORIZONTAL_FACING, (Comparable)direction).method_25751(BlockStateProperties.HORIZONTAL_CONNECTION, (Comparable)((Object)HorizontalConnection.LEFT))}), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)layerModels.get(1)).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.values()[i / 90]));
            multiPart.method_25760(class_4918.method_35870((class_4918[])new class_4918[]{class_4918.method_25744().method_25751((class_2769)BlockStateProperties.HORIZONTAL_FACING, (Comparable)direction).method_25751(BlockStateProperties.HORIZONTAL_CONNECTION, (Comparable)((Object)HorizontalConnection.MIDDLE))}), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)baseModels.get(2)).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.values()[i / 90]));
            multiPart.method_25760(class_4918.method_35870((class_4918[])new class_4918[]{class_4918.method_25744().method_25751((class_2769)BlockStateProperties.HORIZONTAL_FACING, (Comparable)direction).method_25751(BlockStateProperties.HORIZONTAL_CONNECTION, (Comparable)((Object)HorizontalConnection.MIDDLE))}), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)layerModels.get(2)).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.values()[i / 90]));
            multiPart.method_25760(class_4918.method_35870((class_4918[])new class_4918[]{class_4918.method_25744().method_25751((class_2769)BlockStateProperties.HORIZONTAL_FACING, (Comparable)direction).method_25751(BlockStateProperties.HORIZONTAL_CONNECTION, (Comparable)((Object)HorizontalConnection.RIGHT))}), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)baseModels.get(3)).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.values()[i / 90]));
            multiPart.method_25760(class_4918.method_35870((class_4918[])new class_4918[]{class_4918.method_25744().method_25751((class_2769)BlockStateProperties.HORIZONTAL_FACING, (Comparable)direction).method_25751(BlockStateProperties.HORIZONTAL_CONNECTION, (Comparable)((Object)HorizontalConnection.RIGHT))}), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)layerModels.get(3)).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.values()[i / 90]));
        }
        generator.field_22830.accept(multiPart);
        generator.method_25623(block, inventory);
    }

    private static class_4944 woodTroughTextureMapping(class_2248 block) {
        class_2960 top = TextureMappings.getTextureFromDirectResource(block, Category.DECORATION, "wood_trough", "wood_trough_top");
        class_2960 side = TextureMappings.getTextureFromDirectResource(block, Category.DECORATION, "wood_trough", "wood_trough_side");
        class_2960 end = TextureMappings.getTextureFromDirectResource(block, Category.DECORATION, "wood_trough", "wood_trough_end");
        return new class_4944().method_25868(class_4945.field_23015, top).method_25868(class_4945.field_23018, side).method_25868(class_4945.field_23013, end).method_25868(class_4945.field_23012, top);
    }

    public static void createFeedingTrough(class_4910 generator, class_2248 block) {
        class_2960 top = TextureMappings.getTextureFromDirectResource(block, Category.DECORATION, "wood_trough", "feeding_trough_top");
        class_2960 bottom = TextureMappings.getTextureFromDirectResource(block, Category.DECORATION, "wood_trough", "feeding_trough_bottom");
        class_2960 side = TextureMappings.getTextureFromDirectResource(block, Category.DECORATION, "wood_trough", "feeding_trough_side");
        class_2960 front = TextureMappings.getTextureFromDirectResource(block, Category.DECORATION, "wood_trough", "feeding_trough_front");
        class_2960 layer = TextureMappings.getTextureFromDirectResource(block, Category.DECORATION, "wood_trough", "feeding_trough_layer");
        class_4944 textureMapping = new class_4944().method_25868(class_4945.field_23015, top).method_25868(class_4945.field_23014, bottom).method_25868(class_4945.field_23018, side).method_25868(class_4945.field_23016, front).method_25868(TextureSlots.LAYER, layer).method_25868(class_4945.field_23012, top);
        String[] suffixes = new String[]{"1", "_left1", "_middle1", "_right1", "2", "_left2", "_middle2", "_right2"};
        List<class_2960> models = BlockModelProvider.getResourceLocations(generator, block, textureMapping, suffixes, class_4945.field_23015, class_4945.field_23014, class_4945.field_23018, class_4945.field_23016, TextureSlots.LAYER, class_4945.field_23012);
        generator.field_22830.accept(BlockStateProvider.createHorizontalConnectedToggleBlock(block, models));
        generator.method_25623(block, models.get(0));
    }

    public static void createHayBundle(class_4910 generator) {
        class_2248 block = BlockRegistry.HAY_BUNDLE;
        class_2960 top = class_4944.method_25866((class_2248)class_2246.field_10359, (String)"_top");
        class_2960 side = class_4944.method_25866((class_2248)class_2246.field_10359, (String)"_side");
        class_2960 end = TextureMappings.getTextureFromDirectResource(block, Category.MISCELLANEOUS, "hay_block_end");
        class_4944 textureMapping = new class_4944().method_25868(class_4945.field_23015, top).method_25868(class_4945.field_23018, side).method_25868(class_4945.field_23013, end).method_25868(class_4945.field_23012, side);
        String[] suffixes = new String[]{"_one_bundle", "_two_bundles", "_three_bundles", "_four_bundles"};
        List<class_2960> models = BlockModelProvider.getResourceLocations(generator, block, textureMapping, suffixes, class_4945.field_23015, class_4945.field_23018, class_4945.field_23013, class_4945.field_23012);
        generator.field_22830.accept(BlockStateProvider.createFourStackBlock(block, models));
        generator.method_25623(block, models.get(3));
    }

    public static void createWinePress(class_4910 generator) {
        class_2248 block = BlockRegistry.WINE_PRESS;
        class_2960 texture = TextureMappings.decoration(block, "wine_press", "");
        class_2960 top = TextureMappings.decoration(block, "wine_press", "_top");
        class_2960 particle = class_4944.method_25860((class_2248)class_2246.field_10161);
        class_4944 textureMapping = new class_4944().method_25868(class_4945.field_23015, top).method_25868(class_4945.field_23011, texture).method_25868(class_4945.field_23012, particle);
        class_2960 model1 = ModelTemplates.createOBJTemplate("wine_press", "", class_4945.field_23011, class_4945.field_23015, class_4945.field_23012).create(block, textureMapping, (BiConsumer<class_2960, Supplier<JsonElement>>)generator.field_22831);
        class_2960 model2 = ModelTemplates.createOBJTemplate("wine_press", "_on_table", class_4945.field_23011, class_4945.field_23015, class_4945.field_23012).create(block, textureMapping, (BiConsumer<class_2960, Supplier<JsonElement>>)generator.field_22831);
        generator.field_22830.accept(class_4925.method_25769((class_2248)block).method_25775(BlockStateProvider.createHorizontalFacingDispatch()).method_25775((class_4926)class_4926.method_25783((class_2769)BlockStateProperties.ON_TABLE).method_25793((Comparable)Boolean.valueOf(false), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)model1)).method_25793((Comparable)Boolean.valueOf(true), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)model2))));
        generator.method_25623(block, model1);
    }

    public static void createBottle(class_4910 generator, class_2248 block) {
        class_2960 all = TextureMappings.decoration(block, "bottles", "");
        class_4944 textureMapping = new class_4944().method_25868(class_4945.field_23010, all).method_25868(class_4945.field_23012, all);
        String[] suffixes = new String[]{"_one_bottle", "_two_bottles", "_three_bottles", "_four_bottles"};
        List<class_2960> models = BlockModelProvider.getResourceLocations(generator, block, Parent.SMALL_BLOCK, textureMapping, suffixes, class_4945.field_23010, class_4945.field_23012);
        generator.field_22830.accept(BlockStateProvider.createFourStackBlock(block, models));
        generator.method_25623(block, models.get(0));
    }

    public static void createGrille(class_4910 generator) {
        class_2248 block = BlockRegistry.GRILLE;
        class_2960 model1 = class_4941.method_25843((class_2248)block, (String)"");
        class_2960 model2 = class_4941.method_25843((class_2248)block, (String)"_off");
        generator.field_22830.accept(class_4925.method_25769((class_2248)block).method_25775(class_4910.method_25599()).method_25775((class_4926)class_4926.method_25783((class_2769)class_2741.field_12548).method_25793((Comparable)Boolean.valueOf(true), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)model1)).method_25793((Comparable)Boolean.valueOf(false), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)model2))));
        generator.method_25623(block, model1);
    }

    public static void createWashboard(class_4910 generator) {
        class_2248 block = BlockRegistry.WASHBOARD;
        class_2960 model1 = class_4941.method_25843((class_2248)block, (String)"");
        class_2960 model2 = class_4941.method_25843((class_2248)block, (String)"_toggled");
        generator.field_22830.accept(class_4925.method_25769((class_2248)block).method_25775(BlockStateProvider.createHorizontalFacingDispatch()).method_25775((class_4926)class_4926.method_25783((class_2769)BlockStateProperties.TOGGLE).method_25793((Comparable)Boolean.valueOf(false), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)model1)).method_25793((Comparable)Boolean.valueOf(true), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)model2))));
        generator.method_25623(block, model1);
    }

    public static void createEasel(class_4910 generator, class_2248 block) {
        String parent = class_7923.field_41175.method_10221((Object)block).method_12832();
        class_2960 texture = TextureMappings.getTextureFromDirectResource(block, Category.DECORATION, "easel");
        class_4944 textureMapping = new class_4944().method_25868(class_4945.field_23011, texture).method_25868(class_4945.field_23012, texture);
        class_2960 model1 = ModelTemplates.createOBJTemplate(parent, Parent.TALL_BLOCK, "", class_4945.field_23011, class_4945.field_23012).create(block, textureMapping, (BiConsumer<class_2960, Supplier<JsonElement>>)generator.field_22831);
        class_2960 model2 = new class_2960("hearthfire", "block/air_block");
        BlockModelProvider.tallBlockWithItem(generator, block, model1, model2, model1);
    }

    public static void createLectern(class_4910 generator) {
        class_2248 block = BlockRegistry.LECTERN;
        class_2960 model1 = class_4941.method_25843((class_2248)block, (String)"_lower");
        class_2960 model2 = class_4941.method_25843((class_2248)block, (String)"_upper");
        class_2960 model3 = class_4941.method_25843((class_2248)block, (String)"_cloth");
        class_2960 model4 = class_4941.method_25843((class_2248)block, (String)"_book");
        class_2960 inventory = class_4941.method_25843((class_2248)block, (String)"_inventory");
        class_4922 multiPart = class_4922.method_25758((class_2248)block);
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            int i = switch (direction) {
                case class_2350.field_11034 -> 90;
                case class_2350.field_11035 -> 180;
                case class_2350.field_11039 -> 270;
                default -> 0;
            };
            multiPart.method_25760(class_4918.method_35870((class_4918[])new class_4918[]{class_4918.method_25744().method_25751((class_2769)BlockStateProperties.HORIZONTAL_FACING, (Comparable)direction).method_25751(BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)class_2756.field_12607)}), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)model1).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.values()[i / 90]));
            multiPart.method_25760(class_4918.method_35870((class_4918[])new class_4918[]{class_4918.method_25744().method_25751((class_2769)BlockStateProperties.HORIZONTAL_FACING, (Comparable)direction).method_25751(BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)class_2756.field_12609)}), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)model2).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.values()[i / 90]));
            multiPart.method_25760(class_4918.method_35870((class_4918[])new class_4918[]{class_4918.method_25744().method_25751((class_2769)BlockStateProperties.HORIZONTAL_FACING, (Comparable)direction).method_25751(BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)class_2756.field_12607).method_25751((class_2769)BlockStateProperties.TOGGLE, (Comparable)Boolean.valueOf(true))}), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)model3).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.values()[i / 90]));
            multiPart.method_25760(class_4918.method_35870((class_4918[])new class_4918[]{class_4918.method_25744().method_25751((class_2769)BlockStateProperties.HORIZONTAL_FACING, (Comparable)direction).method_25751(BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)class_2756.field_12609).method_25751((class_2769)BlockStateProperties.TOGGLE, (Comparable)Boolean.valueOf(true))}), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)model4).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.values()[i / 90]));
        }
        generator.field_22830.accept(multiPart);
        generator.method_25623(block, inventory);
    }

    public static void createScrollPile(class_4910 generator) {
        class_2248 block = BlockRegistry.SCROLL_PILE;
        List<class_2960> models = List.of(class_4941.method_25843((class_2248)block, (String)"_one_scroll1"), class_4941.method_25843((class_2248)block, (String)"_one_scroll2"), class_4941.method_25843((class_2248)block, (String)"_one_scroll3"), class_4941.method_25843((class_2248)block, (String)"_one_scroll4"), class_4941.method_25843((class_2248)block, (String)"_one_scroll5"), class_4941.method_25843((class_2248)block, (String)"_one_scroll6"), class_4941.method_25843((class_2248)block, (String)"_two_scrolls1"), class_4941.method_25843((class_2248)block, (String)"_two_scrolls2"), class_4941.method_25843((class_2248)block, (String)"_two_scrolls3"), class_4941.method_25843((class_2248)block, (String)"_two_scrolls4"), class_4941.method_25843((class_2248)block, (String)"_three_scrolls1"), class_4941.method_25843((class_2248)block, (String)"_three_scrolls2"), class_4941.method_25843((class_2248)block, (String)"_three_scrolls3"), class_4941.method_25843((class_2248)block, (String)"_four_scrolls1"), class_4941.method_25843((class_2248)block, (String)"_four_scrolls2"), class_4941.method_25843((class_2248)block, (String)"_four_scrolls3"), class_4941.method_25843((class_2248)block, (String)"_four_scrolls4"));
        generator.field_22830.accept(class_4925.method_25769((class_2248)block).method_25775((class_4926)class_4926.method_25783((class_2769)BlockStateProperties.STACK_4).method_25794((Comparable)Integer.valueOf(1), Arrays.asList(class_4935.method_25824().method_25828(class_4936.field_22887, (Object)models.get(0)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)models.get(1)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)models.get(2)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)models.get(3)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)models.get(4)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)models.get(5)))).method_25794((Comparable)Integer.valueOf(2), Arrays.asList(class_4935.method_25824().method_25828(class_4936.field_22887, (Object)models.get(6)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)models.get(7)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)models.get(8)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)models.get(9)))).method_25794((Comparable)Integer.valueOf(3), Arrays.asList(class_4935.method_25824().method_25828(class_4936.field_22887, (Object)models.get(10)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)models.get(11)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)models.get(12)))).method_25794((Comparable)Integer.valueOf(4), Arrays.asList(class_4935.method_25824().method_25828(class_4936.field_22887, (Object)models.get(13)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)models.get(14)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)models.get(15)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)models.get(16))))));
        BlockModelProvider.delegateItemModel(generator, block, models.get(3));
    }

    public static void createBookPile(class_4910 generator) {
        class_2248 block = BlockRegistry.PILE_OF_BOOKS;
        List<class_2960> models = List.of(class_4941.method_25843((class_2248)block, (String)"_one_book"), class_4941.method_25843((class_2248)block, (String)"_two_books"), class_4941.method_25843((class_2248)block, (String)"_three_books"), class_4941.method_25843((class_2248)block, (String)"_four_books"), class_4941.method_25843((class_2248)block, (String)"_five_books"), class_4941.method_25843((class_2248)block, (String)"_six_books"), class_4941.method_25843((class_2248)block, (String)"_seven_books"), class_4941.method_25843((class_2248)block, (String)"_eight_books"));
        generator.field_22830.accept(BlockStateProvider.createDirectionalEightStackBlock(block, models));
        BlockModelProvider.delegateItemModel(generator, block, models.get(0));
    }

    public static void createRowOfBooks(class_4910 generator) {
        class_2248 block = BlockRegistry.ROW_OF_BOOKS;
        List<class_2960> models = List.of(class_4941.method_25843((class_2248)block, (String)"1"), class_4941.method_25843((class_2248)block, (String)"2"), class_4941.method_25843((class_2248)block, (String)"3"), class_4941.method_25843((class_2248)block, (String)"4"), class_4941.method_25843((class_2248)block, (String)"_toggled1"), class_4941.method_25843((class_2248)block, (String)"_toggled2"), class_4941.method_25843((class_2248)block, (String)"_toggled3"), class_4941.method_25843((class_2248)block, (String)"_toggled4"), class_4941.method_25843((class_2248)block, (String)"_on_shelf1"), class_4941.method_25843((class_2248)block, (String)"_on_shelf2"), class_4941.method_25843((class_2248)block, (String)"_on_shelf_toggled1"), class_4941.method_25843((class_2248)block, (String)"_on_shelf_toggled2"));
        generator.field_22830.accept(class_4925.method_25769((class_2248)block).method_25775(BlockStateProvider.createHorizontalFacingDispatch()).method_25775((class_4926)class_4926.method_25784((class_2769)BlockStateProperties.TOGGLE, (class_2769)BlockStateProperties.ON_SHELF).method_25798((Comparable)Boolean.valueOf(false), (Comparable)Boolean.valueOf(false), Arrays.asList(class_4935.method_25824().method_25828(class_4936.field_22887, (Object)models.get(0)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)models.get(1)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)models.get(2)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)models.get(3)))).method_25798((Comparable)Boolean.valueOf(true), (Comparable)Boolean.valueOf(false), Arrays.asList(class_4935.method_25824().method_25828(class_4936.field_22887, (Object)models.get(4)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)models.get(5)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)models.get(6)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)models.get(7)))).method_25798((Comparable)Boolean.valueOf(false), (Comparable)Boolean.valueOf(true), Arrays.asList(class_4935.method_25824().method_25828(class_4936.field_22887, (Object)models.get(8)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)models.get(9)))).method_25798((Comparable)Boolean.valueOf(true), (Comparable)Boolean.valueOf(true), Arrays.asList(class_4935.method_25824().method_25828(class_4936.field_22887, (Object)models.get(10)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)models.get(11))))));
        generator.method_25623(block, models.get(0));
    }

    public static void createHangingFlowerBasket(class_4910 generator, class_2248 block) {
        class_2960 resourceLocation = class_4941.method_25842((class_2248)block);
        generator.field_22830.accept(BlockStateProvider.createRotatedVariants(block, resourceLocation));
        generator.method_25540(block);
    }

    public static void createHangingFlowerBasketAlt(class_4910 generator, class_2248 block) {
        class_2960 resourceLocation1 = class_4941.method_25842((class_2248)block);
        class_2960 resourceLocation2 = class_4941.method_25843((class_2248)block, (String)"_alt");
        generator.field_22830.accept(BlockStateProvider.createRotatedVariants(block, resourceLocation1, resourceLocation2));
        generator.method_25540(block);
    }

    public static void createTargetDummy(class_4910 generator) {
        class_2248 block = BlockRegistry.TARGET_DUMMY;
        class_2960 resourceLocation1 = class_4941.method_25843((class_2248)block, (String)"_lower");
        class_2960 resourceLocation2 = class_4941.method_25843((class_2248)block, (String)"_upper");
        class_2960 resourceLocation3 = class_4941.method_25843((class_2248)block, (String)"_inventory");
        generator.field_22830.accept(BlockStateProvider.createDirectionalTallBlock(block, resourceLocation1, resourceLocation2));
        generator.method_25623(block, resourceLocation3);
    }

    public static void createRoundTargetDummy(class_4910 generator) {
        class_2248 block = BlockRegistry.ROUND_TARGET_DUMMY;
        class_2960 top = TextureMappings.getTextureFromDirectResource(block, Category.DECORATION, "target_dummy", "shot_arrows");
        class_2960 bottom = TextureMappings.getTextureFromDirectResource(block, Category.DECORATION, "target_dummy", "round_target_dummy_post");
        class_2960 front = TextureMappings.getTextureFromDirectResource(block, Category.DECORATION, "target_dummy", "round_target_dummy_front");
        class_2960 back = TextureMappings.getTextureFromDirectResource(block, Category.DECORATION, "target_dummy", "round_target_dummy_back");
        class_4944 textureMapping = new class_4944().method_25868(class_4945.field_23015, top).method_25868(class_4945.field_23014, bottom).method_25868(class_4945.field_23016, front).method_25868(class_4945.field_23017, back).method_25868(class_4945.field_23012, front);
        class_2960 model1 = ModelTemplates.createOBJTemplate("round_target_dummy", "", class_4945.field_23014, class_4945.field_23016, class_4945.field_23017, class_4945.field_23012).create(block, textureMapping, (BiConsumer<class_2960, Supplier<JsonElement>>)generator.field_22831);
        class_2960 model2 = ModelTemplates.createOBJTemplate("round_target_dummy", "_toggled", class_4945.field_23015, class_4945.field_23014, class_4945.field_23016, class_4945.field_23017, class_4945.field_23012).create(block, textureMapping, (BiConsumer<class_2960, Supplier<JsonElement>>)generator.field_22831);
        generator.field_22830.accept(class_4925.method_25769((class_2248)block).method_25775(BlockStateProvider.createHorizontalFacingDispatch()).method_25775(BlockStateProvider.createBooleanModelDispatch(BlockStateProperties.TOGGLE, model1, model2)));
        generator.method_25623(block, model1);
    }

    public static void createTallTargetDummy(class_4910 generator) {
        class_2248 block = BlockRegistry.TALL_ROUND_TARGET_DUMMY;
        class_2960 top = TextureMappings.getTextureFromDirectResource(block, Category.DECORATION, "target_dummy", "shot_arrows");
        class_2960 bottom = TextureMappings.getTextureFromDirectResource(block, Category.DECORATION, "target_dummy", "round_target_dummy_post");
        class_2960 front = TextureMappings.getTextureFromDirectResource(block, Category.DECORATION, "target_dummy", "tall_round_target_dummy_front");
        class_2960 back = TextureMappings.getTextureFromDirectResource(block, Category.DECORATION, "target_dummy", "tall_round_target_dummy_back");
        class_4944 textureMapping = new class_4944().method_25868(class_4945.field_23015, top).method_25868(class_4945.field_23014, bottom).method_25868(class_4945.field_23016, front).method_25868(class_4945.field_23017, back).method_25868(class_4945.field_23012, front);
        class_2960 lowerModel = ModelTemplates.createOBJTemplate("tall_round_target_dummy", "_lower", class_4945.field_23014, class_4945.field_23016, class_4945.field_23017, class_4945.field_23012).create(block, textureMapping, (BiConsumer<class_2960, Supplier<JsonElement>>)generator.field_22831);
        class_2960 upperModel = ModelTemplates.createOBJTemplate("tall_round_target_dummy", "_upper", class_4945.field_23014, class_4945.field_23016, class_4945.field_23017, class_4945.field_23012).create(block, textureMapping, (BiConsumer<class_2960, Supplier<JsonElement>>)generator.field_22831);
        class_2960 toggledModel = ModelTemplates.createOBJTemplate("tall_round_target_dummy", "_toggled", class_4945.field_23015, class_4945.field_23014, class_4945.field_23016, class_4945.field_23017, class_4945.field_23012).create(block, textureMapping, (BiConsumer<class_2960, Supplier<JsonElement>>)generator.field_22831);
        class_2960 inventory = ModelTemplates.createOBJTemplate("tall_round_target_dummy", Parent.TALL_BLOCK, "_inventory", class_4945.field_23014, class_4945.field_23016, class_4945.field_23017).create(block, textureMapping, (BiConsumer<class_2960, Supplier<JsonElement>>)generator.field_22831);
        generator.field_22830.accept(class_4925.method_25769((class_2248)block).method_25775(BlockStateProvider.createHorizontalFacingDispatch()).method_25775((class_4926)class_4926.method_25784(BlockStateProperties.DOUBLE_BLOCK_HALF, (class_2769)BlockStateProperties.TOGGLE).method_25797((Comparable)class_2756.field_12607, (Comparable)Boolean.valueOf(false), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)lowerModel)).method_25797((Comparable)class_2756.field_12609, (Comparable)Boolean.valueOf(false), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)upperModel)).method_25797((Comparable)class_2756.field_12607, (Comparable)Boolean.valueOf(true), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)lowerModel)).method_25797((Comparable)class_2756.field_12609, (Comparable)Boolean.valueOf(true), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)toggledModel))));
        generator.method_25623(block, inventory);
    }

    private static List<class_2960> getResourceLocations(class_4910 generator, class_2248 block, class_4944 textureMapping, String[] suffixes, String parent, class_4945 ... textureSlots) {
        ArrayList<class_2960> models = new ArrayList<class_2960>(suffixes.length);
        for (String suffix : suffixes) {
            class_2960 resourceLocation = ModelTemplates.createTemplate(parent + suffix, suffix, textureSlots).method_25846(block, textureMapping, generator.field_22831);
            models.add(resourceLocation);
        }
        return models;
    }

    private static List<class_2960> getResourceLocations(class_4910 generator, class_2248 block, class_4944 textureMapping, String[] suffixes, class_4945 ... textureSlots) {
        String parent = class_7923.field_41175.method_10221((Object)block).method_12832();
        ArrayList<class_2960> models = new ArrayList<class_2960>(suffixes.length);
        for (String suffix : suffixes) {
            class_2960 resourceLocation = ModelTemplates.createOBJTemplate(parent, suffix, textureSlots).create(block, textureMapping, (BiConsumer<class_2960, Supplier<JsonElement>>)generator.field_22831);
            models.add(resourceLocation);
        }
        return models;
    }

    private static List<class_2960> getResourceLocations(class_4910 generator, class_2248 block, Parent parent, class_4944 textureMapping, String[] suffixes, class_4945 ... textureSlots) {
        String string = class_7923.field_41175.method_10221((Object)block).method_12832();
        ArrayList<class_2960> models = new ArrayList<class_2960>(suffixes.length);
        for (String suffix : suffixes) {
            class_2960 resourceLocation = ModelTemplates.createOBJTemplate(string, parent, suffix, textureSlots).create(block, textureMapping, (BiConsumer<class_2960, Supplier<JsonElement>>)generator.field_22831);
            models.add(resourceLocation);
        }
        return models;
    }
}

