/*
 * Decompiled with CFR 0.152.
 */
package com.conquest.hearthfire.data.models.model;

import com.conquest.hearthfire.data.models.model.DisplayConfig;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_4941;
import net.minecraft.class_4944;
import net.minecraft.class_4945;

public class OBJModelTemplate {
    private final Optional<class_2960> parent;
    private final Set<class_4945> requiredSlots;
    private final Optional<String> suffix;
    private final String loader;
    private final Optional<class_2960> model;
    private final boolean emissiveAmbient;
    private final boolean flipV;
    private final String guiLight;
    private final Optional<DisplayConfig> display;

    public OBJModelTemplate(Optional<class_2960> parent, Optional<String> suffix, Optional<class_2960> model, boolean emissiveAmbient, boolean flipV, String guiLight, Optional<DisplayConfig> display, class_4945 ... textureSlots) {
        this.parent = parent;
        this.suffix = suffix;
        this.requiredSlots = ImmutableSet.copyOf((Object[])textureSlots);
        this.loader = "porting_lib:obj";
        this.model = model;
        this.emissiveAmbient = emissiveAmbient;
        this.flipV = flipV;
        this.guiLight = guiLight;
        this.display = display;
    }

    public class_2960 create(class_2248 block, class_4944 textureMapping, BiConsumer<class_2960, Supplier<JsonElement>> biConsumer) {
        return this.create(class_4941.method_25843((class_2248)block, (String)this.suffix.orElse("")), textureMapping, biConsumer);
    }

    public class_2960 createWithSuffix(class_2248 block, String string, class_4944 textureMapping, BiConsumer<class_2960, Supplier<JsonElement>> biConsumer) {
        return this.create(class_4941.method_25843((class_2248)block, (String)(string + this.suffix.orElse(""))), textureMapping, biConsumer);
    }

    public class_2960 createWithOverride(class_2248 block, String string, class_4944 textureMapping, BiConsumer<class_2960, Supplier<JsonElement>> biConsumer) {
        return this.create(class_4941.method_25843((class_2248)block, (String)string), textureMapping, biConsumer);
    }

    public class_2960 create(class_2960 resourceLocation, class_4944 textureMapping, BiConsumer<class_2960, Supplier<JsonElement>> biConsumer) {
        return this.create(resourceLocation, textureMapping, biConsumer, this::createBaseTemplate);
    }

    public class_2960 create(class_2960 resourceLocation, class_4944 textureMapping, BiConsumer<class_2960, Supplier<JsonElement>> biConsumer, JsonFactory jsonFactory) {
        Map<class_4945, class_2960> map = this.createMap(textureMapping);
        biConsumer.accept(resourceLocation, () -> jsonFactory.create(resourceLocation, map));
        return resourceLocation;
    }

    public JsonObject createBaseTemplate(class_2960 resourceLocation, Map<class_4945, class_2960> textureMap) {
        JsonObject jsonObject = new JsonObject();
        this.parent.ifPresent(resourceLocation1 -> jsonObject.addProperty("parent", resourceLocation1.toString()));
        if (!textureMap.isEmpty()) {
            JsonObject jsonObject2 = new JsonObject();
            textureMap.forEach((textureSlot, resourceLocation1) -> jsonObject2.addProperty(textureSlot.method_25912(), resourceLocation1.toString()));
            jsonObject.add("textures", (JsonElement)jsonObject2);
        }
        jsonObject.addProperty("loader", this.loader);
        this.model.ifPresent(model -> jsonObject.addProperty("model", model.toString()));
        jsonObject.addProperty("emissive_ambient", Boolean.valueOf(this.emissiveAmbient));
        jsonObject.addProperty("flip_v", Boolean.valueOf(this.flipV));
        jsonObject.addProperty("gui_light", this.guiLight);
        this.display.ifPresent(display -> jsonObject.add("display", (JsonElement)display.toJson()));
        return jsonObject;
    }

    private Map<class_4945, class_2960> createMap(class_4944 textureMapping) {
        return (Map)Streams.concat((Stream[])new Stream[]{this.requiredSlots.stream(), textureMapping.method_25861()}).collect(ImmutableMap.toImmutableMap(Function.identity(), arg_0 -> ((class_4944)textureMapping).method_25867(arg_0)));
    }

    public static interface JsonFactory {
        public JsonObject create(class_2960 var1, Map<class_4945, class_2960> var2);
    }
}

