/*
 * Decompiled with CFR 0.152.
 */
package com.conquest.hearthfire.world.inventory;

import com.conquest.hearthfire.world.inventory.ListeningContainerMenu;
import com.conquest.hearthfire.world.inventory.MenuTypes;
import com.conquest.hearthfire.world.item.crafting.RecipeTypes;
import com.conquest.hearthfire.world.item.crafting.WeavingRecipe;
import com.conquest.hearthfire.world.level.block.BlockRegistry;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1731;
import net.minecraft.class_1735;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3489;
import net.minecraft.class_3914;
import net.minecraft.class_3915;
import net.minecraft.class_3917;

public class TreadleLoomMenu
extends ListeningContainerMenu {
    private final class_3914 access;
    private final class_3915 selectedRecipeIndex = class_3915.method_17403();
    private final class_1937 level;
    private final List<WeavingRecipe> recipes = Lists.newArrayList();
    long lastSoundTime;
    final class_1735 ingredientSlot;
    final class_1735 dyeSlot;
    final class_1735 resultSlot;
    public final class_1263 container = new class_1277(3){

        public void method_5431() {
            super.method_5431();
            TreadleLoomMenu.this.method_7609((class_1263)this);
            TreadleLoomMenu.this.slotUpdateListener.run();
        }
    };
    final class_1731 resultContainer = new class_1731();

    public TreadleLoomMenu(int i, class_1661 inventory) {
        this(i, inventory, class_3914.field_17304);
    }

    public TreadleLoomMenu(int i, class_1661 inventory, final class_3914 containerLevelAccess) {
        super(MenuTypes.TREADLE_LOOM, i);
        int j;
        this.access = containerLevelAccess;
        this.level = inventory.field_7546.method_37908();
        this.ingredientSlot = this.method_7621(new IngredientSlot(this.container, 0, 11, 24));
        this.dyeSlot = this.method_7621(new DyeSlot(this.container, 1, 11, 44));
        this.resultSlot = this.method_7621(new class_1735((class_1263)this.resultContainer, 2, 143, 57){

            public boolean method_7680(class_1799 itemStack) {
                return false;
            }

            public void method_7667(class_1657 player, class_1799 itemStack) {
                WeavingRecipe selectedRecipe = TreadleLoomMenu.this.recipes.get(TreadleLoomMenu.this.selectedRecipeIndex.method_17407());
                TreadleLoomMenu.this.ingredientSlot.method_7671(selectedRecipe.getIngredientCount());
                if (selectedRecipe.requiresDye()) {
                    TreadleLoomMenu.this.dyeSlot.method_7671(selectedRecipe.getDyeCount());
                }
                itemStack.method_7982(player.method_37908(), player, itemStack.method_7947());
                TreadleLoomMenu.this.resultContainer.method_7664(player, this.getRelevantItems());
                if (!TreadleLoomMenu.this.ingredientSlot.method_7677().method_7960()) {
                    TreadleLoomMenu.this.updateResultSlot();
                }
                containerLevelAccess.method_17393((level, blockPos) -> {
                    long l = level.method_8510();
                    if (TreadleLoomMenu.this.lastSoundTime != l) {
                        level.method_8396(null, blockPos, class_3417.field_15096, class_3419.field_15245, 1.0f, 1.0f);
                        TreadleLoomMenu.this.lastSoundTime = l;
                    }
                });
                super.method_7667(player, itemStack);
            }

            private List<class_1799> getRelevantItems() {
                return List.of(TreadleLoomMenu.this.ingredientSlot.method_7677());
            }
        });
        for (j = 0; j < 3; ++j) {
            for (int k = 0; k < 9; ++k) {
                this.method_7621(new class_1735((class_1263)inventory, k + j * 9 + 9, 8 + k * 18, 84 + j * 18));
            }
        }
        for (j = 0; j < 9; ++j) {
            this.method_7621(new class_1735((class_1263)inventory, j, 8 + j * 18, 142));
        }
        this.method_17362(this.selectedRecipeIndex);
    }

    public int getSelectedRecipeIndex() {
        return this.selectedRecipeIndex.method_17407();
    }

    public List<WeavingRecipe> getRecipes() {
        return this.recipes;
    }

    public int getNumRecipes() {
        return this.recipes.size();
    }

    public boolean hasIngredientItem() {
        return this.ingredientSlot.method_7681() && !this.recipes.isEmpty();
    }

    public boolean method_7597(class_1657 player) {
        return TreadleLoomMenu.method_17695((class_3914)this.access, (class_1657)player, (class_2248)BlockRegistry.TREADLE_LOOM);
    }

    public boolean method_7604(class_1657 player, int i) {
        if (this.isValidRecipeIndex(i)) {
            this.selectedRecipeIndex.method_17404(i);
            this.updateResultSlot();
        }
        return true;
    }

    private boolean isValidRecipeIndex(int i) {
        return i >= 0 && i < this.recipes.size();
    }

    public void method_7609(class_1263 container) {
        this.updateRecipeList();
        this.updateResultSlot();
    }

    private void updateRecipeList() {
        this.recipes.clear();
        this.selectedRecipeIndex.method_17404(-1);
        this.resultSlot.method_7673(class_1799.field_8037);
        class_1799 ingredientItem = this.ingredientSlot.method_7677();
        class_1799 dyeItem = this.dyeSlot.method_7677();
        if (!ingredientItem.method_7960()) {
            List possibleRecipes = this.level.method_8433().method_17877(RecipeTypes.WEAVING, this.container, this.level);
            for (WeavingRecipe recipe : possibleRecipes) {
                if (!this.isRecipeValid(recipe, ingredientItem, dyeItem)) continue;
                this.recipes.add(recipe);
            }
        }
    }

    private boolean isRecipeValid(WeavingRecipe recipe, class_1799 ingredient, class_1799 dye) {
        boolean hasRequiredIngredient = recipe.ingredient.method_8093(ingredient);
        if (recipe.requiresDye()) {
            return hasRequiredIngredient && recipe.dye.method_8093(dye);
        }
        return hasRequiredIngredient;
    }

    private void updateResultSlot() {
        if (!this.recipes.isEmpty() && this.isValidRecipeIndex(this.selectedRecipeIndex.method_17407())) {
            WeavingRecipe selectedRecipe = this.recipes.get(this.selectedRecipeIndex.method_17407());
            if (this.hasEnoughMaterials(selectedRecipe)) {
                class_1799 craftedItem = selectedRecipe.method_8116(this.container, this.level.method_30349());
                this.resultContainer.method_7662((class_1860)selectedRecipe);
                this.resultSlot.method_7673(craftedItem);
            } else {
                this.resultSlot.method_7673(class_1799.field_8037);
            }
        } else {
            this.resultSlot.method_7673(class_1799.field_8037);
        }
        this.method_7623();
    }

    private boolean hasEnoughMaterials(WeavingRecipe recipe) {
        class_1799 ingredientItem = this.ingredientSlot.method_7677();
        class_1799 dyeItem = this.dyeSlot.method_7677();
        boolean hasValidIngredient = recipe.ingredient.method_8093(ingredientItem);
        if (recipe.requiresDye()) {
            return hasValidIngredient && recipe.dye.method_8093(dyeItem);
        }
        return hasValidIngredient;
    }

    public class_3917<?> method_17358() {
        return MenuTypes.TREADLE_LOOM;
    }

    public boolean method_7613(class_1799 itemStack, class_1735 slot) {
        return slot.field_7871 != this.resultContainer && super.method_7613(itemStack, slot);
    }

    public class_1799 method_7601(class_1657 player, int i) {
        class_1799 itemStack = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(i);
        if (slot != null && slot.method_7681()) {
            class_1799 itemStack2 = slot.method_7677();
            class_1792 item = itemStack2.method_7909();
            itemStack = itemStack2.method_7972();
            if (i == 2) {
                item.method_7843(itemStack2, player.method_37908(), player);
                if (!this.method_7616(itemStack2, 3, 39, true)) {
                    return class_1799.field_8037;
                }
                slot.method_7670(itemStack2, itemStack);
            } else if (i == 0 || i == 1) {
                if (!this.method_7616(itemStack2, 3, 39, false)) {
                    return class_1799.field_8037;
                }
            } else {
                if (!this.method_7616(itemStack2, 0, 2, false)) {
                    return class_1799.field_8037;
                }
                if (i >= 3 && i < 30 ? !this.method_7616(itemStack2, 30, 39, false) : i >= 30 && i < 39 && !this.method_7616(itemStack2, 3, 30, false)) {
                    return class_1799.field_8037;
                }
            }
            if (itemStack2.method_7960()) {
                slot.method_48931(class_1799.field_8037);
            }
            slot.method_7668();
            if (itemStack2.method_7947() == itemStack.method_7947()) {
                return class_1799.field_8037;
            }
            slot.method_7667(player, itemStack2);
            this.method_7623();
        }
        return itemStack;
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        this.resultContainer.method_5441(1);
        this.access.method_17393((level, blockPos) -> this.method_7607(player, this.container));
    }

    static class IngredientSlot
    extends class_1735 {
        public IngredientSlot(class_1263 container, int i, int j, int k) {
            super(container, i, j, k);
        }

        public boolean method_7680(class_1799 itemStack) {
            return itemStack.method_31573(class_3489.field_15544) || itemStack.method_31574(class_1802.field_8276) || itemStack.method_31574(class_1802.field_8786);
        }

        public int method_7675() {
            return 64;
        }
    }

    static class DyeSlot
    extends class_1735 {
        public DyeSlot(class_1263 container, int i, int j, int k) {
            super(container, i, j, k);
        }

        public boolean method_7680(class_1799 itemStack) {
            return itemStack.method_7909() instanceof class_1769;
        }

        public int method_7675() {
            return 64;
        }
    }
}

