/*
 * Decompiled with CFR 0.152.
 */
package com.conquest.hearthfire.world.item.crafting;

import com.conquest.hearthfire.world.item.crafting.RecipeSerializers;
import com.conquest.hearthfire.world.item.crafting.RecipeTypes;
import com.conquest.hearthfire.world.level.block.BlockRegistry;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public class WoodworkingRecipe
implements class_1860<class_1263> {
    public final class_1856 ingredient;
    public final class_1856 supplement;
    public final class_1856 dye;
    protected final class_1799 result;
    private final class_3956<?> type;
    private final class_1865<?> serializer;
    protected final class_2960 id;
    protected final String group;
    protected final boolean requiresDye;
    final int ingredientCount;
    final int supplementCount;
    final int dyeCount;

    public WoodworkingRecipe(class_2960 id, String group, class_1856 ingredient, int ingredientCount, class_1856 supplement, int supplementCount, class_1856 dye, int dyeCount, class_1799 result, boolean requiresDye) {
        this(RecipeTypes.WOODWORKING, RecipeSerializers.WOODWORKING, id, group, ingredient, ingredientCount, supplement, supplementCount, dye, dyeCount, result, requiresDye);
    }

    public WoodworkingRecipe(class_3956<?> type, class_1865<?> serializer, class_2960 id, String group, class_1856 ingredient, int ingredientCount, class_1856 supplement, int supplementCount, class_1856 dye, int dyeCount, class_1799 result, boolean requiresDye) {
        this.type = type;
        this.serializer = serializer;
        this.id = id;
        this.group = group;
        this.ingredient = ingredient;
        this.supplement = supplement;
        this.dye = dye;
        this.result = result;
        this.requiresDye = requiresDye;
        this.ingredientCount = ingredientCount;
        this.supplementCount = supplementCount;
        this.dyeCount = dyeCount;
    }

    public boolean method_8115(class_1263 container, @NotNull class_1937 world) {
        boolean hasRequiredIngredient;
        class_1799 itemStack = container.method_5438(0);
        class_1799 itemStack1 = container.method_5438(1);
        class_1799 itemStack2 = container.method_5438(2);
        boolean bl = hasRequiredIngredient = this.ingredient.method_8093(itemStack) && itemStack.method_7947() >= this.ingredientCount && this.supplement.method_8093(itemStack1) && itemStack1.method_7947() >= this.supplementCount;
        if (this.requiresDye) {
            return hasRequiredIngredient && this.dye.method_8093(itemStack2) && itemStack2.method_7947() >= this.dyeCount;
        }
        return hasRequiredIngredient;
    }

    public class_1799 method_17447() {
        return new class_1799((class_1935)BlockRegistry.CARPENTRY_TABLE);
    }

    public class_3956<?> method_17716() {
        return this.type;
    }

    public class_1865<?> method_8119() {
        return this.serializer;
    }

    public class_2960 method_8114() {
        return this.id;
    }

    public String method_8112() {
        return this.group;
    }

    public class_1799 method_8110(class_5455 registryAccess) {
        return this.result.method_7972();
    }

    public class_1799 getResultItem() {
        return this.method_8110(null);
    }

    public class_2371<class_1856> method_8117() {
        class_2371 ingredients = class_2371.method_10211();
        ingredients.add((Object)this.ingredient);
        ingredients.add((Object)this.supplement);
        if (this.requiresDye) {
            ingredients.add((Object)this.dye);
        }
        return ingredients;
    }

    public boolean method_8113(int i, int j) {
        return true;
    }

    public class_1799 method_8116(class_1263 container, class_5455 registryAccess) {
        return this.result.method_7972();
    }

    public boolean requiresDye() {
        return this.requiresDye;
    }

    public int getIngredientCount() {
        return this.ingredientCount;
    }

    public int getSupplementCount() {
        return this.supplementCount;
    }

    public int getDyeCount() {
        return this.dyeCount;
    }

    public static class Serializer<T extends WoodworkingRecipe>
    implements class_1865<T> {
        final SingleItemMaker<T> recipeFactory;

        protected Serializer(SingleItemMaker<T> singleItemMaker) {
            this.recipeFactory = singleItemMaker;
        }

        public T fromJson(class_2960 resourceLocation, JsonObject jsonObject) {
            String group = class_3518.method_15253((JsonObject)jsonObject, (String)"group", (String)"");
            class_1856 ingredient = class_1856.method_52177((JsonElement)class_3518.method_15296((JsonObject)jsonObject, (String)"ingredient"));
            int ingredientCount = class_3518.method_15282((JsonObject)jsonObject.getAsJsonObject("ingredient"), (String)"count", (int)1);
            class_1856 supplement = class_1856.method_52177((JsonElement)class_3518.method_15296((JsonObject)jsonObject, (String)"supplement"));
            int supplementCount = class_3518.method_15282((JsonObject)jsonObject.getAsJsonObject("supplement"), (String)"count", (int)1);
            class_1856 dye = class_1856.field_9017;
            int dyeCount = 0;
            boolean requiresDye = jsonObject.has("dye");
            if (requiresDye) {
                dye = class_1856.method_52177((JsonElement)class_3518.method_15296((JsonObject)jsonObject, (String)"dye"));
                dyeCount = class_3518.method_15282((JsonObject)jsonObject.getAsJsonObject("dye"), (String)"count", (int)1);
            }
            String resultItem = class_3518.method_15265((JsonObject)jsonObject.getAsJsonObject("result"), (String)"item");
            int resultCount = class_3518.method_15282((JsonObject)jsonObject.getAsJsonObject("result"), (String)"count", (int)1);
            class_1799 resultStack = new class_1799((class_1935)class_7923.field_41178.method_10223(new class_2960(resultItem)), resultCount);
            return this.recipeFactory.create(resourceLocation, group, ingredient, ingredientCount, supplement, supplementCount, dye, dyeCount, resultStack, requiresDye);
        }

        public T fromNetwork(class_2960 resourceLocation, class_2540 buffer) {
            String group = buffer.method_19772();
            class_1856 ingredient = class_1856.method_8086((class_2540)buffer);
            int ingredientCount = buffer.readInt();
            class_1856 supplement = class_1856.method_8086((class_2540)buffer);
            int supplementCount = buffer.readInt();
            class_1856 dye = class_1856.field_9017;
            int dyeCount = 0;
            boolean requiresDye = buffer.readBoolean();
            if (requiresDye) {
                dye = class_1856.method_8086((class_2540)buffer);
                dyeCount = buffer.readInt();
            }
            class_1799 result = buffer.method_10819();
            return this.recipeFactory.create(resourceLocation, group, ingredient, ingredientCount, supplement, supplementCount, dye, dyeCount, result, requiresDye);
        }

        public void toNetwork(class_2540 buffer, T recipe) {
            buffer.method_10814(((WoodworkingRecipe)recipe).group);
            ((WoodworkingRecipe)recipe).ingredient.method_8088(buffer);
            buffer.writeInt(((WoodworkingRecipe)recipe).ingredientCount);
            ((WoodworkingRecipe)recipe).supplement.method_8088(buffer);
            buffer.writeInt(((WoodworkingRecipe)recipe).supplementCount);
            buffer.writeBoolean(((WoodworkingRecipe)recipe).requiresDye);
            if (((WoodworkingRecipe)recipe).requiresDye) {
                ((WoodworkingRecipe)recipe).dye.method_8088(buffer);
                buffer.writeInt(((WoodworkingRecipe)recipe).dyeCount);
            }
            buffer.method_10793(((WoodworkingRecipe)recipe).result);
        }

        public static interface SingleItemMaker<T extends WoodworkingRecipe> {
            public T create(class_2960 var1, String var2, class_1856 var3, int var4, class_1856 var5, int var6, class_1856 var7, int var8, class_1799 var9, boolean var10);
        }
    }
}

