/*
 * Decompiled with CFR 0.152.
 */
package com.conquest.hearthfire.world.level.block;

import com.conquest.hearthfire.util.Util;
import com.conquest.hearthfire.world.level.block.HorizontalDirectionalBlock;
import com.conquest.hearthfire.world.level.block.entity.StorageBlockEntity;
import java.util.Optional;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3545;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5712;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractStorageBlock
extends HorizontalDirectionalBlock
implements class_2343 {
    public static final class_3414 DEFAULT_SOUND = class_3417.field_14718;

    protected AbstractStorageBlock(class_4970.class_2251 properties) {
        super(properties);
    }

    @Nullable
    public class_2586 method_10123(class_2338 blockPos, class_2680 blockState) {
        return new StorageBlockEntity(blockPos, blockState, this.getCapacity());
    }

    public class_1269 method_9534(class_2680 blockState, class_1937 level, class_2338 blockPos, class_1657 player, class_1268 interactionHand, class_3965 blockHitResult) {
        class_2586 blockEntity = level.method_8321(blockPos);
        if (blockEntity instanceof StorageBlockEntity) {
            StorageBlockEntity storageBlockEntity = (StorageBlockEntity)blockEntity;
            Optional<class_3545<Float, Float>> hitCoordinates = Util.getRelativeHitCoordinatesForBlockFace(blockHitResult, (class_2350)blockState.method_11654((class_2769)FACING), this.getRestrictedDirections());
            if (hitCoordinates.isEmpty()) {
                return class_1269.field_5811;
            }
            class_3545<Float, Float> coordinates = hitCoordinates.get();
            int slot = this.calculateSlot((Float)coordinates.method_15442(), (Float)coordinates.method_15441());
            if (slot == Integer.MIN_VALUE || slot >= storageBlockEntity.getInventory().size() || slot < 0) {
                return class_1269.field_5811;
            }
            if (!((class_1799)storageBlockEntity.getInventory().get(slot)).method_7960()) {
                this.removeItem(level, blockPos, player, storageBlockEntity, slot);
                return class_1269.method_29236((boolean)level.field_9236);
            }
            class_1799 heldItem = player.method_5998(interactionHand);
            if (!heldItem.method_7960() && this.isItemValidForSlot(heldItem)) {
                this.addItem(level, blockPos, player, storageBlockEntity, heldItem, slot);
                return class_1269.method_29236((boolean)level.field_9236);
            }
            return class_1269.field_21466;
        }
        return class_1269.field_5811;
    }

    public void addItem(class_1937 level, class_2338 blockPos, class_1657 player, StorageBlockEntity blockEntity, class_1799 itemStack, int slot) {
        if (!level.field_9236) {
            class_3414 addSound = this.getAddSound(level, blockPos, player, slot);
            blockEntity.updateItem(slot, itemStack.method_7971(1));
            level.method_8396(null, blockPos, addSound, class_3419.field_15245, 1.0f, 1.0f);
            if (player.method_7337()) {
                itemStack.method_7933(1);
            }
            level.method_33596((class_1297)player, class_5712.field_28733, blockPos);
        }
    }

    public void removeItem(class_1937 level, class_2338 blockPos, class_1657 player, StorageBlockEntity potEntity, int slot) {
        if (!level.field_9236) {
            class_1799 removedItem = potEntity.removeItem(slot);
            class_3414 removeSound = this.getRemoveSound(level, blockPos, player, slot);
            level.method_8396(null, blockPos, removeSound, class_3419.field_15245, 1.0f, 1.0f);
            if (!player.method_31548().method_7394(removedItem)) {
                player.method_7328(removedItem, false);
            }
            level.method_33596((class_1297)player, class_5712.field_28733, blockPos);
        }
    }

    public class_3414 getRemoveSound(class_1937 level, class_2338 blockPos, class_1657 player, int slot) {
        return DEFAULT_SOUND;
    }

    public class_3414 getAddSound(class_1937 level, class_2338 blockPos, class_1657 player, int slot) {
        return DEFAULT_SOUND;
    }

    public void method_9536(class_2680 blockState, class_1937 level, class_2338 blockPos, class_2680 blockState2, boolean bl) {
        if (!blockState.method_27852(blockState2.method_26204())) {
            class_2586 blockEntity = level.method_8321(blockPos);
            if (blockEntity instanceof StorageBlockEntity) {
                StorageBlockEntity potEntity = (StorageBlockEntity)blockEntity;
                if (level instanceof class_3218) {
                    class_3218 serverLevel = (class_3218)level;
                    class_1264.method_17349((class_1937)serverLevel, (class_2338)blockPos, potEntity.getInventory());
                }
                level.method_8455(blockPos, (class_2248)this);
            }
            super.method_9536(blockState, level, blockPos, blockState2, bl);
        }
    }

    @NotNull
    public class_2464 method_9604(class_2680 blockState) {
        return class_2464.field_11458;
    }

    public abstract int getCapacity();

    public abstract class_2960 getBlockType();

    public abstract class_2350[] getRestrictedDirections();

    public abstract boolean isItemValidForSlot(class_1799 var1);

    public abstract int calculateSlot(Float var1, Float var2);
}

