/*
 * Decompiled with CFR 0.152.
 */
package com.conquest.hearthfire.world.level.block;

import com.conquest.hearthfire.tags.ItemTagRegistry;
import com.conquest.hearthfire.world.level.block.AbstractStorageBlock;
import com.conquest.hearthfire.world.level.block.BlockRegistry;
import com.conquest.hearthfire.world.level.block.entity.StorageBlockTypes;
import com.conquest.hearthfire.world.level.block.state.properties.BlockStateProperties;
import com.conquest.hearthfire.world.level.block.state.properties.HorizontalConnection;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WallShelfBlock
extends AbstractStorageBlock {
    public static final class_2754<HorizontalConnection> SHAPE = BlockStateProperties.HORIZONTAL_CONNECTION;
    public static final class_2746 UP = BlockStateProperties.UP;
    protected static final class_265 NORTH = class_2248.method_9541((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final class_265 EAST = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0);
    protected static final class_265 SOUTH = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
    protected static final class_265 WEST = class_2248.method_9541((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    protected WallShelfBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657(SHAPE, (Comparable)((Object)HorizontalConnection.SINGLE))).method_11657((class_2769)UP, (Comparable)Boolean.TRUE));
    }

    public class_265 method_9530(class_2680 blockState, class_1922 blockGetter, class_2338 blockPos, class_3726 context) {
        return switch ((class_2350)blockState.method_11654((class_2769)FACING)) {
            default -> NORTH;
            case class_2350.field_11034 -> EAST;
            case class_2350.field_11035 -> SOUTH;
            case class_2350.field_11039 -> WEST;
        };
    }

    @Override
    @Nullable
    public class_2680 method_9605(class_1750 context) {
        class_1937 level = context.method_8045();
        class_2338 blockPos = context.method_8037();
        class_2338 blockPos1 = blockPos.method_10084();
        class_2350 direction = context.method_8042().method_10153();
        class_2680 blockState = (class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)direction);
        class_2680 blockState1 = level.method_8320(blockPos1);
        boolean bl = blockState1.method_26204() instanceof WallShelfBlock && blockState1.method_11654((class_2769)FACING) == direction;
        HorizontalConnection shape = this.determineShape(this.attachesTo(level.method_8320(blockPos.method_10093(direction.method_10160())), direction), this.attachesTo(level.method_8320(blockPos.method_10093(direction.method_10170())), direction));
        return (class_2680)((class_2680)blockState.method_11657(SHAPE, (Comparable)((Object)shape))).method_11657((class_2769)UP, (Comparable)Boolean.valueOf(!bl));
    }

    public class_2680 method_9559(class_2680 blockState, class_2350 direction, class_2680 neighborState, class_1936 levelAccessor, class_2338 blockPos, class_2338 neighborPos) {
        if (blockState.method_26204() == this) {
            class_2350 facing = (class_2350)blockState.method_11654((class_2769)FACING);
            HorizontalConnection shape = this.determineShape(this.attachesTo(levelAccessor.method_8320(blockPos.method_10093(facing.method_10160())), facing), this.attachesTo(levelAccessor.method_8320(blockPos.method_10093(facing.method_10170())), facing));
            boolean bl = levelAccessor.method_8320(blockPos.method_10084()).method_26204() instanceof WallShelfBlock && levelAccessor.method_8320(blockPos.method_10084()).method_11654((class_2769)FACING) == facing;
            return (class_2680)((class_2680)blockState.method_11657(SHAPE, (Comparable)((Object)shape))).method_11657((class_2769)UP, (Comparable)Boolean.valueOf(!bl));
        }
        return super.method_9559(blockState, direction, neighborState, levelAccessor, blockPos, neighborPos);
    }

    HorizontalConnection determineShape(boolean attachesToLeft, boolean attachesToRight) {
        if (attachesToLeft && attachesToRight) {
            return HorizontalConnection.MIDDLE;
        }
        if (attachesToLeft) {
            return HorizontalConnection.LEFT;
        }
        if (attachesToRight) {
            return HorizontalConnection.RIGHT;
        }
        return HorizontalConnection.SINGLE;
    }

    protected boolean attachesTo(class_2680 blockState, class_2350 direction) {
        return blockState.method_26204() == this && blockState.method_11654((class_2769)FACING) == direction;
    }

    @Override
    @NotNull
    public class_2464 method_9604(class_2680 blockState) {
        return class_2464.field_11458;
    }

    @Override
    public int getCapacity() {
        return 3;
    }

    @Override
    public class_2960 getBlockType() {
        return StorageBlockTypes.OLD_WOOD_WALL_SHELF;
    }

    @Override
    public class_2350[] getRestrictedDirections() {
        return new class_2350[]{class_2350.field_11033};
    }

    @Override
    public boolean isItemValidForSlot(class_1799 itemStack) {
        return itemStack.method_31573(ItemTagRegistry.JAM_JARS) || itemStack.method_31573(ItemTagRegistry.BOTTLES) || itemStack.method_31574(BlockRegistry.SACK.method_8389());
    }

    @Override
    public int calculateSlot(Float x, Float y) {
        if (x.floatValue() < 0.0f || x.floatValue() > 1.0f || y.floatValue() < 0.0f || y.floatValue() > 1.0f) {
            return Integer.MIN_VALUE;
        }
        float sectionWidth = 1.0f / (float)this.getCapacity();
        int slot = (int)(x.floatValue() / sectionWidth);
        return slot >= 0 && slot < this.getCapacity() ? slot : Integer.MIN_VALUE;
    }

    public void method_9588(class_2680 blockState, class_3218 serverLevel, class_2338 blockPos, class_5819 randomSource) {
        if (!blockState.method_26184((class_4538)serverLevel, blockPos)) {
            serverLevel.method_22352(blockPos, true);
        }
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, SHAPE, UP});
    }
}

