/*
 * Decompiled with CFR 0.152.
 */
package com.conquest.hearthfire;

import com.conquest.hearthfire.Config;
import com.conquest.hearthfire.compat.jei.recipes.CustomRecipes;
import com.conquest.hearthfire.core.particles.ParticleTypes;
import com.conquest.hearthfire.util.CompostingChanceRegistry;
import com.conquest.hearthfire.util.datafix.DataFixers;
import com.conquest.hearthfire.world.entity.npc.VillagerTrades;
import com.conquest.hearthfire.world.inventory.MenuTypes;
import com.conquest.hearthfire.world.item.CreativeModeTabRegistry;
import com.conquest.hearthfire.world.item.CreativeModeTabs;
import com.conquest.hearthfire.world.item.ItemRegistry;
import com.conquest.hearthfire.world.item.crafting.RecipeSerializers;
import com.conquest.hearthfire.world.item.crafting.RecipeTypes;
import com.conquest.hearthfire.world.level.block.BlockRegistry;
import com.conquest.hearthfire.world.level.block.entity.BlockEntityTypes;
import com.mojang.logging.LogUtils;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="hearthfire")
public class Hearthfire {
    public static final String MOD_ID = "hearthfire";
    public static final Logger LOGGER = LogUtils.getLogger();

    public Hearthfire() {
        FMLJavaModLoadingContext context = FMLJavaModLoadingContext.get();
        IEventBus modEventBus = context.getModEventBus();
        this.registerModEventBus(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::addCreative);
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    private void registerModEventBus(IEventBus eventBus) {
        eventBus.addListener(this::commonSetup);
        DataFixers.register();
        BlockRegistry.register(eventBus);
        ItemRegistry.register(eventBus);
        CreativeModeTabs.register(eventBus);
        BlockEntityTypes.register(eventBus);
        ParticleTypes.register(eventBus);
        RecipeTypes.register(eventBus);
        RecipeSerializers.register(eventBus);
        MenuTypes.register(eventBus);
        VillagerTrades.register();
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(CustomRecipes::register);
        event.enqueueWork(CompostingChanceRegistry::register);
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        CreativeModeTabRegistry.register(event);
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("Hearthfire server starting...");
    }
}

