/*
 * Decompiled with CFR 0.152.
 */
package com.conquest.hearthfire.client;

import java.nio.file.Path;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.resource.PathPackResources;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="hearthfire", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class BuiltinPackLoader {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String PACK_NAME = "hearthfire_resource_pack";
    private static final String PACK_PATH = "builtin_resourcepacks/hearthfire_resource_pack";

    @SubscribeEvent
    public static void registerPack(AddPackFindersEvent event) {
        if (event.getPackType() != PackType.CLIENT_RESOURCES) {
            return;
        }
        try {
            ResourceLocation resourceLocation = new ResourceLocation("hearthfire", PACK_NAME);
            Path path = ModList.get().getModFileById("hearthfire").getFile().findResource(new String[]{PACK_PATH});
            Pack.ResourcesSupplier resourcesSupplier = packId -> new PathPackResources(packId, true, path);
            Pack.Info info = new Pack.Info((Component)Component.m_237113_((String)"Hearthfire Resource Pack"), 15, FeatureFlagSet.m_246902_());
            Pack pack = Pack.m_245512_((String)resourceLocation.toString(), (Component)info.f_244592_(), (boolean)false, (Pack.ResourcesSupplier)resourcesSupplier, (Pack.Info)info, (PackType)PackType.CLIENT_RESOURCES, (Pack.Position)Pack.Position.TOP, (boolean)false, (PackSource)PackSource.f_10527_);
            event.addRepositorySource(consumer -> consumer.accept(pack));
            LOGGER.info("Successfully registered built-in resource pack: {}", (Object)PACK_NAME);
        }
        catch (Exception exception) {
            LOGGER.error("Failed to register built-in resource pack: {}", (Object)PACK_NAME, (Object)exception);
        }
    }
}

