/*
 * Decompiled with CFR 0.152.
 */
package com.conquest.hearthfire.client;

import com.conquest.hearthfire.client.color.block.BlockColorProvider;
import com.conquest.hearthfire.client.gui.screens.MenuScreens;
import com.conquest.hearthfire.client.particle.ParticleEngine;
import com.conquest.hearthfire.client.renderer.RenderTypes;
import com.conquest.hearthfire.client.renderer.entity.EntityRenderers;
import com.mojang.logging.LogUtils;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import org.slf4j.Logger;

@Mod.EventBusSubscriber(modid="hearthfire", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class Hearthfire {
    public static final String MOD_ID = "hearthfire";
    public static final Logger LOGGER = LogUtils.getLogger();

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            MenuScreens.register();
            RenderTypes.register();
            EntityRenderers.register();
        });
        LOGGER.info("Hearthfire client setup complete.");
    }

    @SubscribeEvent
    public static void particleSetup(RegisterParticleProvidersEvent event) {
        ParticleEngine.register(event);
        LOGGER.info("Registered Hearthfire particle providers.");
    }

    @SubscribeEvent
    public static void onRegisterBlockColors(RegisterColorHandlersEvent.Block event) {
        BlockColorProvider.register(event);
        LOGGER.info("Registered Hearthfire block color handlers.");
    }
}

