/*
 * Decompiled with CFR 0.152.
 */
package com.conquest.hearthfire.client.gui.screens.inventory;

import com.conquest.hearthfire.world.inventory.ListeningContainerMenu;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class AbstractRecipeSelectionScreen<T extends ListeningContainerMenu, R extends Recipe<?>>
extends AbstractContainerScreen<T> {
    private final ResourceLocation backgroundTexture;
    private final Function<T, List<R>> recipesGetter;
    private final Function<T, Integer> numRecipesGetter;
    private final Function<T, Boolean> hasIngredientChecker;
    private final Function<T, Integer> selectedRecipeIndexGetter;
    private final SoundProvider soundProvider;
    private float scrollOffs;
    private boolean scrolling;
    private int startIndex;
    private boolean displayRecipes;

    protected AbstractRecipeSelectionScreen(T menu, Inventory inventory, Component component, ResourceLocation backgroundTexture, Function<T, List<R>> recipesGetter, Function<T, Integer> numRecipesGetter, Function<T, Boolean> hasIngredientChecker, Function<T, Integer> selectedRecipeIndexGetter, SoundProvider soundProvider) {
        super(menu, inventory, component);
        this.backgroundTexture = backgroundTexture;
        this.recipesGetter = recipesGetter;
        this.numRecipesGetter = numRecipesGetter;
        this.hasIngredientChecker = hasIngredientChecker;
        this.selectedRecipeIndexGetter = selectedRecipeIndexGetter;
        this.soundProvider = soundProvider;
        ((ListeningContainerMenu)((Object)menu)).registerUpdateListener(this::containerChanged);
        --this.f_97729_;
    }

    public void m_88315_(GuiGraphics guiGraphics, int i, int j, float f) {
        super.m_88315_(guiGraphics, i, j, f);
        this.m_280072_(guiGraphics, i, j);
    }

    protected void m_7286_(GuiGraphics guiGraphics, float f, int i, int j) {
        this.m_280273_(guiGraphics);
        int k = this.f_97735_;
        int l = this.f_97736_;
        guiGraphics.m_280218_(this.backgroundTexture, k, l, 0, 0, this.f_97726_, this.f_97727_);
        int m = (int)(41.0f * this.scrollOffs);
        guiGraphics.m_280218_(this.backgroundTexture, k + 119, l + 15 + m, 176 + (this.isScrollBarActive() ? 0 : 12), 0, 12, 15);
        int n = this.f_97735_ + 52;
        int o = this.f_97736_ + 14;
        int p = this.startIndex + 12;
        this.renderButtons(guiGraphics, i, j, n, o, p);
        this.renderRecipes(guiGraphics, n, o, p);
    }

    protected void m_280072_(GuiGraphics guiGraphics, int i, int j) {
        super.m_280072_(guiGraphics, i, j);
        if (this.displayRecipes) {
            int k = this.f_97735_ + 52;
            int l = this.f_97736_ + 14;
            int m = this.startIndex + 12;
            List<R> list = this.recipesGetter.apply((ListeningContainerMenu)this.f_97732_);
            for (int n = this.startIndex; n < m && n < this.numRecipesGetter.apply((ListeningContainerMenu)this.f_97732_); ++n) {
                int o = n - this.startIndex;
                int p = k + o % 4 * 16;
                int q = l + o / 4 * 18 + 2;
                if (i < p || i >= p + 16 || j < q || j >= q + 18) continue;
                guiGraphics.m_280153_(this.f_96547_, ((Recipe)list.get(n)).m_8043_(this.f_96541_.f_91073_.m_9598_()), i, j);
            }
        }
    }

    private void renderButtons(GuiGraphics guiGraphics, int i, int j, int k, int l, int m) {
        for (int n = this.startIndex; n < m && n < this.numRecipesGetter.apply((ListeningContainerMenu)this.f_97732_); ++n) {
            int o = n - this.startIndex;
            int p = k + o % 4 * 16;
            int q = o / 4;
            int r = l + q * 18 + 2;
            int s = this.f_97727_;
            if (n == this.selectedRecipeIndexGetter.apply((ListeningContainerMenu)this.f_97732_)) {
                s += 18;
            } else if (i >= p && j >= r && i < p + 16 && j < r + 18) {
                s += 36;
            }
            guiGraphics.m_280218_(this.backgroundTexture, p, r - 1, 0, s, 16, 18);
        }
    }

    private void renderRecipes(GuiGraphics guiGraphics, int i, int j, int k) {
        List<R> list = this.recipesGetter.apply((ListeningContainerMenu)this.f_97732_);
        for (int l = this.startIndex; l < k && l < this.numRecipesGetter.apply((ListeningContainerMenu)this.f_97732_); ++l) {
            int m = l - this.startIndex;
            int n = i + m % 4 * 16;
            int o = m / 4;
            int p = j + o * 18 + 2;
            guiGraphics.m_280480_(((Recipe)list.get(l)).m_8043_(this.f_96541_.f_91073_.m_9598_()), n, p);
        }
    }

    public boolean m_6375_(double d, double e, int i) {
        this.scrolling = false;
        if (this.displayRecipes) {
            int j = this.f_97735_ + 52;
            int k = this.f_97736_ + 14;
            int l = this.startIndex + 12;
            for (int m = this.startIndex; m < l; ++m) {
                int n = m - this.startIndex;
                double f = d - (double)(j + n % 4 * 16);
                double g = e - (double)(k + n / 4 * 18);
                if (!(f >= 0.0 && g >= 0.0 && f < 16.0 && g < 18.0 && ((ListeningContainerMenu)this.f_97732_).m_6366_((Player)this.f_96541_.f_91074_, m))) continue;
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)this.soundProvider.getSelectSound(), (float)1.0f));
                this.f_96541_.f_91072_.m_105208_(((ListeningContainerMenu)this.f_97732_).f_38840_, m);
                return true;
            }
            j = this.f_97735_ + 119;
            k = this.f_97736_ + 9;
            if (d >= (double)j && d < (double)(j + 12) && e >= (double)k && e < (double)(k + 54)) {
                this.scrolling = true;
            }
        }
        return super.m_6375_(d, e, i);
    }

    public boolean m_7979_(double d, double e, int i, double f, double g) {
        if (this.scrolling && this.isScrollBarActive()) {
            int j = this.f_97736_ + 14;
            int k = j + 54;
            this.scrollOffs = ((float)e - (float)j - 7.5f) / ((float)(k - j) - 15.0f);
            this.scrollOffs = Mth.m_14036_((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)this.getOffscreenRows()) + 0.5) * 4;
            return true;
        }
        return super.m_7979_(d, e, i, f, g);
    }

    public boolean m_6050_(double d, double e, double f) {
        if (this.isScrollBarActive()) {
            int i = this.getOffscreenRows();
            float g = (float)f / (float)i;
            this.scrollOffs = Mth.m_14036_((float)(this.scrollOffs - g), (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)i) + 0.5) * 4;
        }
        return true;
    }

    private boolean isScrollBarActive() {
        return this.displayRecipes && this.numRecipesGetter.apply((ListeningContainerMenu)this.f_97732_) > 12;
    }

    protected int getOffscreenRows() {
        return (this.numRecipesGetter.apply((ListeningContainerMenu)this.f_97732_) + 4 - 1) / 4 - 3;
    }

    private void containerChanged() {
        this.displayRecipes = this.hasIngredientChecker.apply((ListeningContainerMenu)this.f_97732_);
        if (!this.displayRecipes) {
            this.scrollOffs = 0.0f;
            this.startIndex = 0;
        }
    }

    @FunctionalInterface
    public static interface SoundProvider {
        public SoundEvent getSelectSound();
    }
}

