/*
 * Decompiled with CFR 0.152.
 */
package com.conquest.hearthfire.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class RenderHelper {
    public static <T extends BlockEntity> void renderBlockState(BlockState blockState, PoseStack poseStack, MultiBufferSource bufferSource, T blockEntity) {
        Level level = blockEntity.m_58904_();
        if (level != null) {
            Minecraft.m_91087_().m_91289_().m_110912_(blockState, poseStack, bufferSource, RenderHelper.calculateLightLevel(level, blockEntity.m_58899_()), OverlayTexture.f_118083_);
        }
    }

    public static <T extends BlockEntity> void renderBlockFromItem(BlockItem blockItem, PoseStack poseStack, MultiBufferSource bufferSource, T blockEntity) {
        RenderHelper.renderBlockState(blockItem.m_40614_().m_49966_(), poseStack, bufferSource, blockEntity);
    }

    public static int calculateLightLevel(Level level, BlockPos blockPos) {
        int blockLight = level.m_45517_(LightLayer.BLOCK, blockPos);
        if (blockLight <= 8) {
            blockLight += 2;
        }
        int skyLight = level.m_45517_(LightLayer.SKY, blockPos);
        return LightTexture.m_109885_((int)blockLight, (int)skyLight);
    }
}

