/*
 * Decompiled with CFR 0.152.
 */
package com.conquest.hearthfire.client.renderer.entity;

import com.conquest.hearthfire.client.renderer.entity.StorageBlockRenderer;
import com.conquest.hearthfire.world.level.block.AbstractStorageBlock;
import com.conquest.hearthfire.world.level.block.entity.StorageBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class StorageBlockEntityRenderer
implements BlockEntityRenderer<StorageBlockEntity> {
    private static final Map<ResourceLocation, StorageBlockRenderer> STORAGE_RENDERERS = new HashMap<ResourceLocation, StorageBlockRenderer>();

    public static void addStorageRenderer(ResourceLocation resourceLocation, StorageBlockRenderer renderer) {
        STORAGE_RENDERERS.put(resourceLocation, renderer);
    }

    public static StorageBlockRenderer getStorageRenderer(ResourceLocation resourceLocation) {
        return STORAGE_RENDERERS.get(resourceLocation);
    }

    public StorageBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(StorageBlockEntity entity, float tickDelta, PoseStack poseStack, MultiBufferSource bufferSource, int light, int overlay) {
        if (!entity.m_58898_()) {
            return;
        }
        BlockState blockState = entity.m_58900_();
        Block block = blockState.m_60734_();
        if (block instanceof AbstractStorageBlock) {
            AbstractStorageBlock storageBlock = (AbstractStorageBlock)block;
            NonNullList<ItemStack> inventory = entity.getInventory();
            poseStack.m_85836_();
            StorageBlockEntityRenderer.setBlockRotation(poseStack, blockState, 0.0f);
            ResourceLocation storageType = storageBlock.getBlockType();
            StorageBlockRenderer renderer = StorageBlockEntityRenderer.getStorageRenderer(storageType);
            if (renderer != null) {
                renderer.render(entity, poseStack, bufferSource, inventory);
            }
            poseStack.m_85849_();
        }
    }

    public static void setBlockRotation(PoseStack poseStack, BlockState blockState, float angleOffset) {
        float blockRotation = ((Direction)blockState.m_61143_((Property)AbstractStorageBlock.FACING)).m_122435_();
        poseStack.m_85837_(0.5, 0.0, 0.5);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(angleOffset - blockRotation));
    }
}

