/*
 * Decompiled with CFR 0.152.
 */
package com.conquest.hearthfire.compat;

import com.conquest.hearthfire.compat.jei.ChurningCategory;
import com.conquest.hearthfire.compat.jei.SmithingCategory;
import com.conquest.hearthfire.compat.jei.WeavingCategory;
import com.conquest.hearthfire.compat.jei.WoodCuttingCategory;
import com.conquest.hearthfire.compat.jei.WoodWorkingCategory;
import com.conquest.hearthfire.compat.jei.recipes.ChurningRecipeType;
import com.conquest.hearthfire.compat.jei.recipes.ChurningRecipes;
import com.conquest.hearthfire.world.item.crafting.RecipeTypes;
import com.conquest.hearthfire.world.level.block.BlockRegistry;
import java.util.List;
import java.util.Objects;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    @NotNull
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("hearthfire", "jei_plugin");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new WoodCuttingCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new WoodWorkingCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new ChurningCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new WeavingCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new SmithingCategory(guiHelper)});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeManager recipeManager = Objects.requireNonNull(Minecraft.m_91087_().f_91073_.m_7465_());
        List woodcuttingRecipes = recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)RecipeTypes.WOODCUTTING.get());
        registration.addRecipes(WoodCuttingCategory.WOODCUTTING, woodcuttingRecipes);
        List woodworkingRecipes = recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)RecipeTypes.WOODWORKING.get());
        registration.addRecipes(WoodWorkingCategory.WOODWORKING, woodworkingRecipes);
        List<ChurningRecipeType> churningRecipes = ChurningRecipes.getRecipes();
        registration.addRecipes(ChurningCategory.CHURNING, churningRecipes);
        List weavingRecipes = recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)RecipeTypes.WEAVING.get());
        registration.addRecipes(WeavingCategory.WEAVING, weavingRecipes);
        List smithingRecipes = recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)RecipeTypes.SMITHING.get());
        registration.addRecipes(SmithingCategory.SMITHING, smithingRecipes);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst((ItemLike)BlockRegistry.SAWHORSE.get(), new RecipeType[]{WoodCuttingCategory.WOODCUTTING});
        registration.addRecipeCatalyst((ItemLike)BlockRegistry.CARPENTRY_TABLE.get(), new RecipeType[]{WoodWorkingCategory.WOODWORKING});
        registration.addRecipeCatalyst((ItemLike)BlockRegistry.BUTTER_CHURN.get(), new RecipeType[]{ChurningCategory.CHURNING});
        registration.addRecipeCatalyst((ItemLike)BlockRegistry.TREADLE_LOOM.get(), new RecipeType[]{WeavingCategory.WEAVING});
        registration.addRecipeCatalyst((ItemLike)BlockRegistry.STAKE_ANVIL.get(), new RecipeType[]{SmithingCategory.SMITHING});
    }
}

