/*
 * Decompiled with CFR 0.152.
 */
package com.conquest.hearthfire.compat.jei;

import com.conquest.hearthfire.world.item.crafting.WeavingRecipe;
import com.conquest.hearthfire.world.level.block.BlockRegistry;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class WeavingCategory
implements IRecipeCategory<WeavingRecipe> {
    public static final RecipeType<WeavingRecipe> WEAVING = RecipeType.create((String)"hearthfire", (String)"weaving", WeavingRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;
    private final Component component;

    public WeavingCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(102, 48);
        this.icon = guiHelper.createDrawableItemStack(((Block)BlockRegistry.TREADLE_LOOM.get()).m_5456_().m_7968_());
        this.component = ((Block)BlockRegistry.TREADLE_LOOM.get()).m_49954_();
    }

    public void setRecipe(IRecipeLayoutBuilder builder, WeavingRecipe recipe, @NotNull IFocusGroup focusGroup) {
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 16).setStandardSlotBackground().addIngredients((Ingredient)recipe.m_7527_().get(0));
        if (recipe.requiresDye()) {
            builder.addSlot(RecipeIngredientRole.INPUT, 21, 16).setStandardSlotBackground().addIngredients((Ingredient)recipe.m_7527_().get(1));
        } else {
            builder.addSlot(RecipeIngredientRole.INPUT, 21, 16).setStandardSlotBackground();
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 81, 16).setOutputSlotBackground().addItemStack(recipe.getResultItem());
    }

    public void createRecipeExtras(IRecipeExtrasBuilder builder, @NotNull WeavingRecipe recipe, @NotNull IFocusGroup focuses) {
        builder.addRecipeArrow().setPosition(46, 16);
    }

    @NotNull
    public RecipeType<WeavingRecipe> getRecipeType() {
        return WEAVING;
    }

    @NotNull
    public Component getTitle() {
        return this.component;
    }

    public int getWidth() {
        return this.background.getWidth();
    }

    public int getHeight() {
        return this.background.getHeight();
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }
}

