/*
 * Decompiled with CFR 0.152.
 */
package com.conquest.hearthfire.compat.jei;

import com.conquest.hearthfire.world.item.crafting.WoodworkingRecipe;
import com.conquest.hearthfire.world.level.block.BlockRegistry;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class WoodWorkingCategory
implements IRecipeCategory<WoodworkingRecipe> {
    public static final RecipeType<WoodworkingRecipe> WOODWORKING = RecipeType.create((String)"hearthfire", (String)"woodworking", WoodworkingRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;
    private final Component component;

    public WoodWorkingCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(102, 48);
        this.icon = guiHelper.createDrawableItemStack(((Block)BlockRegistry.CARPENTRY_TABLE.get()).m_5456_().m_7968_());
        this.component = ((Block)BlockRegistry.CARPENTRY_TABLE.get()).m_49954_();
    }

    public void setRecipe(IRecipeLayoutBuilder builder, WoodworkingRecipe recipe, @NotNull IFocusGroup focusGroup) {
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 6).setStandardSlotBackground().addIngredients((Ingredient)recipe.m_7527_().get(0));
        builder.addSlot(RecipeIngredientRole.INPUT, 21, 6).setStandardSlotBackground().addIngredients((Ingredient)recipe.m_7527_().get(1));
        if (recipe.requiresDye()) {
            builder.addSlot(RecipeIngredientRole.INPUT, 11, 26).setStandardSlotBackground().addIngredients((Ingredient)recipe.m_7527_().get(2));
        } else {
            builder.addSlot(RecipeIngredientRole.INPUT, 11, 26).setStandardSlotBackground();
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 81, 16).setOutputSlotBackground().addItemStack(recipe.getResultItem());
    }

    public void createRecipeExtras(IRecipeExtrasBuilder builder, @NotNull WoodworkingRecipe recipe, @NotNull IFocusGroup focuses) {
        builder.addRecipeArrow().setPosition(46, 16);
    }

    @NotNull
    public RecipeType<WoodworkingRecipe> getRecipeType() {
        return WOODWORKING;
    }

    @NotNull
    public Component getTitle() {
        return this.component;
    }

    public int getWidth() {
        return this.background.getWidth();
    }

    public int getHeight() {
        return this.background.getHeight();
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }
}

