/*
 * Decompiled with CFR 0.152.
 */
package com.conquest.hearthfire.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class Util {
    public static Collection<ServerPlayer> getPlayersTrackingPosition(ServerLevel serverLevel, BlockPos blockPos) {
        Objects.requireNonNull(blockPos, "Block Position cannot be null");
        return Util.getPlayersTrackingChunk(serverLevel, new ChunkPos(blockPos));
    }

    public static Collection<ServerPlayer> getPlayersTrackingChunk(ServerLevel serverLevel, ChunkPos chunkPos) {
        Objects.requireNonNull(serverLevel, "The Server Level cannot be null");
        Objects.requireNonNull(chunkPos, "The Chunk Position cannot be null");
        return serverLevel.m_7726_().f_8325_.m_183262_(chunkPos, false);
    }

    public static Optional<Tuple<Float, Float>> getRelativeHitCoordinatesForBlockFace(BlockHitResult hitResult, Direction targetDirection, Direction[] disallowedDirections) {
        Direction hitDirection = hitResult.m_82434_();
        if (Arrays.asList(disallowedDirections).contains(hitDirection)) {
            return Optional.empty();
        }
        if (targetDirection != hitDirection && hitDirection != Direction.UP && hitDirection != Direction.DOWN) {
            return Optional.empty();
        }
        BlockPos blockPos = hitResult.m_82425_().m_121945_(hitDirection);
        Vec3 hitPosition = hitResult.m_82450_().m_82492_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_());
        float x = (float)hitPosition.f_82479_;
        float y = (float)hitPosition.f_82480_;
        float z = (float)hitPosition.f_82481_;
        if (hitDirection == Direction.UP || hitDirection == Direction.DOWN) {
            hitDirection = targetDirection;
        }
        return switch (hitDirection) {
            case Direction.NORTH -> Optional.of(new Tuple((Object)Float.valueOf(1.0f - x), (Object)Float.valueOf(y)));
            case Direction.SOUTH -> Optional.of(new Tuple((Object)Float.valueOf(x), (Object)Float.valueOf(y)));
            case Direction.WEST -> Optional.of(new Tuple((Object)Float.valueOf(z), (Object)Float.valueOf(y)));
            case Direction.EAST -> Optional.of(new Tuple((Object)Float.valueOf(1.0f - z), (Object)Float.valueOf(y)));
            default -> Optional.empty();
        };
    }
}

