/*
 * Decompiled with CFR 0.152.
 */
package com.conquest.hearthfire.world.inventory;

import com.conquest.hearthfire.world.inventory.ListeningContainerMenu;
import com.conquest.hearthfire.world.inventory.MenuTypes;
import com.conquest.hearthfire.world.item.crafting.RecipeTypes;
import com.conquest.hearthfire.world.item.crafting.SmithingRecipe;
import com.conquest.hearthfire.world.level.block.BlockRegistry;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class StakeAnvilMenu
extends ListeningContainerMenu {
    private final ContainerLevelAccess access;
    private final DataSlot selectedRecipeIndex = DataSlot.m_39401_();
    private final Level level;
    private List<SmithingRecipe> recipes = Lists.newArrayList();
    private ItemStack input = ItemStack.f_41583_;
    long lastSoundTime;
    final Slot inputSlot;
    final Slot resultSlot;
    public final Container container = new SimpleContainer(1){

        public void m_6596_() {
            super.m_6596_();
            StakeAnvilMenu.this.m_6199_((Container)this);
            StakeAnvilMenu.this.slotUpdateListener.run();
        }
    };
    final ResultContainer resultContainer = new ResultContainer();

    public StakeAnvilMenu(int i, Inventory inventory) {
        this(i, inventory, ContainerLevelAccess.f_39287_);
    }

    public StakeAnvilMenu(int i, Inventory inventory, final ContainerLevelAccess containerLevelAccess) {
        super((MenuType)MenuTypes.STAKE_ANVIL.get(), i);
        int j;
        this.access = containerLevelAccess;
        this.level = inventory.f_35978_.m_9236_();
        this.inputSlot = this.m_38897_(new Slot(this.container, 0, 20, 33));
        this.resultSlot = this.m_38897_(new Slot((Container)this.resultContainer, 1, 143, 33){

            public boolean m_5857_(ItemStack itemStack) {
                return false;
            }

            public void m_142406_(Player player, ItemStack itemStack) {
                itemStack.m_41678_(player.m_9236_(), player, itemStack.m_41613_());
                StakeAnvilMenu.this.resultContainer.m_58395_(player, this.getRelevantItems());
                ItemStack itemStack2 = StakeAnvilMenu.this.inputSlot.m_6201_(1);
                if (!itemStack2.m_41619_()) {
                    StakeAnvilMenu.this.setupResultSlot();
                }
                containerLevelAccess.m_39292_((level, blockPos) -> {
                    long l = level.m_46467_();
                    if (StakeAnvilMenu.this.lastSoundTime != l) {
                        level.m_5594_(null, blockPos, SoundEvents.f_11671_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        StakeAnvilMenu.this.lastSoundTime = l;
                    }
                });
                super.m_142406_(player, itemStack);
            }

            private List<ItemStack> getRelevantItems() {
                return List.of(StakeAnvilMenu.this.inputSlot.m_7993_());
            }
        });
        for (j = 0; j < 3; ++j) {
            for (int k = 0; k < 9; ++k) {
                this.m_38897_(new Slot((Container)inventory, k + j * 9 + 9, 8 + k * 18, 84 + j * 18));
            }
        }
        for (j = 0; j < 9; ++j) {
            this.m_38897_(new Slot((Container)inventory, j, 8 + j * 18, 142));
        }
        this.m_38895_(this.selectedRecipeIndex);
    }

    public int getSelectedRecipeIndex() {
        return this.selectedRecipeIndex.m_6501_();
    }

    public List<SmithingRecipe> getRecipes() {
        return this.recipes;
    }

    public int getNumRecipes() {
        return this.recipes.size();
    }

    public boolean hasInputItem() {
        return this.inputSlot.m_6657_() && !this.recipes.isEmpty();
    }

    public boolean m_6875_(Player player) {
        return StakeAnvilMenu.m_38889_((ContainerLevelAccess)this.access, (Player)player, (Block)((Block)BlockRegistry.STAKE_ANVIL.get()));
    }

    public boolean m_6366_(Player player, int i) {
        if (this.isValidRecipeIndex(i)) {
            this.selectedRecipeIndex.m_6422_(i);
            this.setupResultSlot();
        }
        return true;
    }

    private boolean isValidRecipeIndex(int i) {
        return i >= 0 && i < this.recipes.size();
    }

    public void m_6199_(Container container) {
        ItemStack itemStack = this.inputSlot.m_7993_();
        if (!itemStack.m_150930_(this.input.m_41720_())) {
            this.input = itemStack.m_41777_();
            this.setupRecipeList(container, itemStack);
        }
    }

    private void setupRecipeList(Container container, ItemStack itemStack) {
        this.recipes.clear();
        this.selectedRecipeIndex.m_6422_(-1);
        this.resultSlot.m_5852_(ItemStack.f_41583_);
        if (!itemStack.m_41619_()) {
            this.recipes = this.level.m_7465_().m_44056_((RecipeType)RecipeTypes.SMITHING.get(), container, this.level);
        }
    }

    void setupResultSlot() {
        if (!this.recipes.isEmpty() && this.isValidRecipeIndex(this.selectedRecipeIndex.m_6501_())) {
            SmithingRecipe metalWorkingRecipe = this.recipes.get(this.selectedRecipeIndex.m_6501_());
            ItemStack itemStack = metalWorkingRecipe.m_5874_(this.container, this.level.m_9598_());
            if (itemStack.m_246617_(this.level.m_246046_())) {
                this.resultContainer.m_6029_((Recipe)metalWorkingRecipe);
                this.resultSlot.m_5852_(itemStack);
            } else {
                this.resultSlot.m_5852_(ItemStack.f_41583_);
            }
        } else {
            this.resultSlot.m_5852_(ItemStack.f_41583_);
        }
        this.m_38946_();
    }

    public MenuType<?> m_6772_() {
        return (MenuType)MenuTypes.STAKE_ANVIL.get();
    }

    public boolean m_5882_(ItemStack itemStack, Slot slot) {
        return slot.f_40218_ != this.resultContainer && super.m_5882_(itemStack, slot);
    }

    public ItemStack m_7648_(Player player, int i) {
        ItemStack itemStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(i);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemStack2 = slot.m_7993_();
            Item item = itemStack2.m_41720_();
            itemStack = itemStack2.m_41777_();
            if (i == 1) {
                item.m_7836_(itemStack2, player.m_9236_(), player);
                if (!this.m_38903_(itemStack2, 2, 38, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemStack2, itemStack);
            } else if (i == 0 ? !this.m_38903_(itemStack2, 2, 38, false) : (this.level.m_7465_().m_44015_((RecipeType)RecipeTypes.SMITHING.get(), (Container)new SimpleContainer(new ItemStack[]{itemStack2}), this.level).isPresent() ? !this.m_38903_(itemStack2, 0, 1, false) : (i >= 2 && i < 29 ? !this.m_38903_(itemStack2, 29, 38, false) : i >= 29 && i < 38 && !this.m_38903_(itemStack2, 2, 29, false)))) {
                return ItemStack.f_41583_;
            }
            if (itemStack2.m_41619_()) {
                slot.m_269060_(ItemStack.f_41583_);
            }
            slot.m_6654_();
            if (itemStack2.m_41613_() == itemStack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, itemStack2);
            this.m_38946_();
        }
        return itemStack;
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.resultContainer.m_8016_(1);
        this.access.m_39292_((level, blockPos) -> this.m_150411_(player, this.container));
    }
}

