/*
 * Decompiled with CFR 0.152.
 */
package com.conquest.hearthfire.world.inventory;

import com.conquest.hearthfire.world.inventory.ListeningContainerMenu;
import com.conquest.hearthfire.world.inventory.MenuTypes;
import com.conquest.hearthfire.world.item.crafting.RecipeTypes;
import com.conquest.hearthfire.world.item.crafting.WeavingRecipe;
import com.conquest.hearthfire.world.level.block.BlockRegistry;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class TreadleLoomMenu
extends ListeningContainerMenu {
    private final ContainerLevelAccess access;
    private final DataSlot selectedRecipeIndex = DataSlot.m_39401_();
    private final Level level;
    private final List<WeavingRecipe> recipes = Lists.newArrayList();
    long lastSoundTime;
    final Slot ingredientSlot;
    final Slot dyeSlot;
    final Slot resultSlot;
    public final Container container = new SimpleContainer(3){

        public void m_6596_() {
            super.m_6596_();
            TreadleLoomMenu.this.m_6199_((Container)this);
            TreadleLoomMenu.this.slotUpdateListener.run();
        }
    };
    final ResultContainer resultContainer = new ResultContainer();

    public TreadleLoomMenu(int i, Inventory inventory) {
        this(i, inventory, ContainerLevelAccess.f_39287_);
    }

    public TreadleLoomMenu(int i, Inventory inventory, final ContainerLevelAccess containerLevelAccess) {
        super((MenuType)MenuTypes.TREADLE_LOOM.get(), i);
        int j;
        this.access = containerLevelAccess;
        this.level = inventory.f_35978_.m_9236_();
        this.ingredientSlot = this.m_38897_(new IngredientSlot(this.container, 0, 11, 24));
        this.dyeSlot = this.m_38897_(new DyeSlot(this.container, 1, 11, 44));
        this.resultSlot = this.m_38897_(new Slot((Container)this.resultContainer, 2, 143, 57){

            public boolean m_5857_(ItemStack itemStack) {
                return false;
            }

            public void m_142406_(Player player, ItemStack itemStack) {
                WeavingRecipe selectedRecipe = TreadleLoomMenu.this.recipes.get(TreadleLoomMenu.this.selectedRecipeIndex.m_6501_());
                TreadleLoomMenu.this.ingredientSlot.m_6201_(selectedRecipe.getIngredientCount());
                if (selectedRecipe.requiresDye()) {
                    TreadleLoomMenu.this.dyeSlot.m_6201_(selectedRecipe.getDyeCount());
                }
                itemStack.m_41678_(player.m_9236_(), player, itemStack.m_41613_());
                TreadleLoomMenu.this.resultContainer.m_58395_(player, this.getRelevantItems());
                if (!TreadleLoomMenu.this.ingredientSlot.m_7993_().m_41619_()) {
                    TreadleLoomMenu.this.updateResultSlot();
                }
                containerLevelAccess.m_39292_((level, blockPos) -> {
                    long l = level.m_46467_();
                    if (TreadleLoomMenu.this.lastSoundTime != l) {
                        level.m_5594_(null, blockPos, SoundEvents.f_12492_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        TreadleLoomMenu.this.lastSoundTime = l;
                    }
                });
                super.m_142406_(player, itemStack);
            }

            private List<ItemStack> getRelevantItems() {
                return List.of(TreadleLoomMenu.this.ingredientSlot.m_7993_());
            }
        });
        for (j = 0; j < 3; ++j) {
            for (int k = 0; k < 9; ++k) {
                this.m_38897_(new Slot((Container)inventory, k + j * 9 + 9, 8 + k * 18, 84 + j * 18));
            }
        }
        for (j = 0; j < 9; ++j) {
            this.m_38897_(new Slot((Container)inventory, j, 8 + j * 18, 142));
        }
        this.m_38895_(this.selectedRecipeIndex);
    }

    public int getSelectedRecipeIndex() {
        return this.selectedRecipeIndex.m_6501_();
    }

    public List<WeavingRecipe> getRecipes() {
        return this.recipes;
    }

    public int getNumRecipes() {
        return this.recipes.size();
    }

    public boolean hasIngredientItem() {
        return this.ingredientSlot.m_6657_() && !this.recipes.isEmpty();
    }

    public boolean m_6875_(Player player) {
        return TreadleLoomMenu.m_38889_((ContainerLevelAccess)this.access, (Player)player, (Block)((Block)BlockRegistry.TREADLE_LOOM.get()));
    }

    public boolean m_6366_(Player player, int i) {
        if (this.isValidRecipeIndex(i)) {
            this.selectedRecipeIndex.m_6422_(i);
            this.updateResultSlot();
        }
        return true;
    }

    private boolean isValidRecipeIndex(int i) {
        return i >= 0 && i < this.recipes.size();
    }

    public void m_6199_(Container container) {
        this.updateRecipeList();
        this.updateResultSlot();
    }

    private void updateRecipeList() {
        this.recipes.clear();
        this.selectedRecipeIndex.m_6422_(-1);
        this.resultSlot.m_5852_(ItemStack.f_41583_);
        ItemStack ingredientItem = this.ingredientSlot.m_7993_();
        ItemStack dyeItem = this.dyeSlot.m_7993_();
        if (!ingredientItem.m_41619_()) {
            List possibleRecipes = this.level.m_7465_().m_44056_((RecipeType)RecipeTypes.WEAVING.get(), this.container, this.level);
            for (WeavingRecipe recipe : possibleRecipes) {
                if (!this.isRecipeValid(recipe, ingredientItem, dyeItem)) continue;
                this.recipes.add(recipe);
            }
        }
    }

    private boolean isRecipeValid(WeavingRecipe recipe, ItemStack ingredient, ItemStack dye) {
        boolean hasRequiredIngredient = recipe.ingredient.test(ingredient);
        if (recipe.requiresDye()) {
            return hasRequiredIngredient && recipe.dye.test(dye);
        }
        return hasRequiredIngredient;
    }

    private void updateResultSlot() {
        if (!this.recipes.isEmpty() && this.isValidRecipeIndex(this.selectedRecipeIndex.m_6501_())) {
            WeavingRecipe selectedRecipe = this.recipes.get(this.selectedRecipeIndex.m_6501_());
            if (this.hasEnoughMaterials(selectedRecipe)) {
                ItemStack craftedItem = selectedRecipe.m_5874_(this.container, this.level.m_9598_());
                this.resultContainer.m_6029_((Recipe)selectedRecipe);
                this.resultSlot.m_5852_(craftedItem);
            } else {
                this.resultSlot.m_5852_(ItemStack.f_41583_);
            }
        } else {
            this.resultSlot.m_5852_(ItemStack.f_41583_);
        }
        this.m_38946_();
    }

    private boolean hasEnoughMaterials(WeavingRecipe recipe) {
        ItemStack ingredientItem = this.ingredientSlot.m_7993_();
        ItemStack dyeItem = this.dyeSlot.m_7993_();
        boolean hasValidIngredient = recipe.ingredient.test(ingredientItem);
        if (recipe.requiresDye()) {
            return hasValidIngredient && recipe.dye.test(dyeItem);
        }
        return hasValidIngredient;
    }

    public MenuType<?> m_6772_() {
        return (MenuType)MenuTypes.TREADLE_LOOM.get();
    }

    public boolean m_5882_(ItemStack itemStack, Slot slot) {
        return slot.f_40218_ != this.resultContainer && super.m_5882_(itemStack, slot);
    }

    public ItemStack m_7648_(Player player, int i) {
        ItemStack itemStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(i);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemStack2 = slot.m_7993_();
            Item item = itemStack2.m_41720_();
            itemStack = itemStack2.m_41777_();
            if (i == 2) {
                item.m_7836_(itemStack2, player.m_9236_(), player);
                if (!this.m_38903_(itemStack2, 3, 39, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemStack2, itemStack);
            } else if (i == 0 || i == 1) {
                if (!this.m_38903_(itemStack2, 3, 39, false)) {
                    return ItemStack.f_41583_;
                }
            } else {
                if (!this.m_38903_(itemStack2, 0, 2, false)) {
                    return ItemStack.f_41583_;
                }
                if (i >= 3 && i < 30 ? !this.m_38903_(itemStack2, 30, 39, false) : i >= 30 && i < 39 && !this.m_38903_(itemStack2, 3, 30, false)) {
                    return ItemStack.f_41583_;
                }
            }
            if (itemStack2.m_41619_()) {
                slot.m_269060_(ItemStack.f_41583_);
            }
            slot.m_6654_();
            if (itemStack2.m_41613_() == itemStack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, itemStack2);
            this.m_38946_();
        }
        return itemStack;
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.resultContainer.m_8016_(1);
        this.access.m_39292_((level, blockPos) -> this.m_150411_(player, this.container));
    }

    static class IngredientSlot
    extends Slot {
        public IngredientSlot(Container container, int i, int j, int k) {
            super(container, i, j, k);
        }

        public boolean m_5857_(ItemStack itemStack) {
            return itemStack.m_204117_(ItemTags.f_13167_) || itemStack.m_150930_(Items.f_42401_) || itemStack.m_150930_(Items.f_41863_);
        }

        public int m_6641_() {
            return 64;
        }
    }

    static class DyeSlot
    extends Slot {
        public DyeSlot(Container container, int i, int j, int k) {
            super(container, i, j, k);
        }

        public boolean m_5857_(ItemStack itemStack) {
            return itemStack.m_41720_() instanceof DyeItem;
        }

        public int m_6641_() {
            return 64;
        }
    }
}

