/*
 * Decompiled with CFR 0.152.
 */
package com.conquest.hearthfire.world.item.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;

public abstract class SingleItemRecipe
implements Recipe<Container> {
    protected final Ingredient ingredient;
    protected final ItemStack result;
    private final RecipeType<?> type;
    private final RecipeSerializer<?> serializer;
    protected final ResourceLocation id;
    protected final String group;

    public SingleItemRecipe(RecipeType<?> type, RecipeSerializer<?> serializer, ResourceLocation id, String group, Ingredient ingredient, ItemStack result) {
        this.type = type;
        this.serializer = serializer;
        this.id = id;
        this.group = group;
        this.ingredient = ingredient;
        this.result = result;
    }

    public RecipeType<?> m_6671_() {
        return this.type;
    }

    public RecipeSerializer<?> m_7707_() {
        return this.serializer;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public String m_6076_() {
        return this.group;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.result.m_41777_();
    }

    public ItemStack getResultItem() {
        return this.m_8043_(null);
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList nonNullList = NonNullList.m_122779_();
        nonNullList.add((Object)this.ingredient);
        return nonNullList;
    }

    public boolean m_8004_(int i, int j) {
        return true;
    }

    public ItemStack m_5874_(Container container, RegistryAccess registryAccess) {
        return this.result.m_41777_();
    }

    public static class Serializer<T extends SingleItemRecipe>
    implements RecipeSerializer<T> {
        final SingleItemMaker<T> recipeFactory;

        protected Serializer(SingleItemMaker<T> singleItemMaker) {
            this.recipeFactory = singleItemMaker;
        }

        public T fromJson(ResourceLocation resourceLocation, JsonObject jsonObject) {
            String string = GsonHelper.m_13851_((JsonObject)jsonObject, (String)"group", (String)"");
            Ingredient ingredient = GsonHelper.m_13885_((JsonObject)jsonObject, (String)"ingredient") ? Ingredient.m_288218_((JsonElement)GsonHelper.m_13933_((JsonObject)jsonObject, (String)"ingredient"), (boolean)false) : Ingredient.m_288218_((JsonElement)GsonHelper.m_13930_((JsonObject)jsonObject, (String)"ingredient"), (boolean)false);
            String string2 = GsonHelper.m_13906_((JsonObject)jsonObject, (String)"result");
            int i = GsonHelper.m_13927_((JsonObject)jsonObject, (String)"count");
            ItemStack itemStack = new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(string2)), i);
            return this.recipeFactory.create(resourceLocation, string, ingredient, itemStack);
        }

        public T fromNetwork(ResourceLocation resourceLocation, FriendlyByteBuf friendlyByteBuf) {
            String string = friendlyByteBuf.m_130277_();
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)friendlyByteBuf);
            ItemStack itemStack = friendlyByteBuf.m_130267_();
            return this.recipeFactory.create(resourceLocation, string, ingredient, itemStack);
        }

        public void toNetwork(FriendlyByteBuf friendlyByteBuf, T recipe) {
            friendlyByteBuf.m_130070_(((SingleItemRecipe)recipe).group);
            ((SingleItemRecipe)recipe).ingredient.m_43923_(friendlyByteBuf);
            friendlyByteBuf.m_130055_(((SingleItemRecipe)recipe).result);
        }

        public static interface SingleItemMaker<T extends SingleItemRecipe> {
            public T create(ResourceLocation var1, String var2, Ingredient var3, ItemStack var4);
        }
    }
}

