/*
 * Decompiled with CFR 0.152.
 */
package com.conquest.hearthfire.world.item.crafting;

import com.conquest.hearthfire.world.item.crafting.RecipeSerializers;
import com.conquest.hearthfire.world.item.crafting.RecipeTypes;
import com.conquest.hearthfire.world.level.block.BlockRegistry;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class WoodworkingRecipe
implements Recipe<Container> {
    public final Ingredient ingredient;
    public final Ingredient supplement;
    public final Ingredient dye;
    protected final ItemStack result;
    private final RecipeType<?> type;
    private final RecipeSerializer<?> serializer;
    protected final ResourceLocation id;
    protected final String group;
    protected final boolean requiresDye;
    final int ingredientCount;
    final int supplementCount;
    final int dyeCount;

    public WoodworkingRecipe(ResourceLocation id, String group, Ingredient ingredient, int ingredientCount, Ingredient supplement, int supplementCount, Ingredient dye, int dyeCount, ItemStack result, boolean requiresDye) {
        this((RecipeType)RecipeTypes.WOODWORKING.get(), (RecipeSerializer)RecipeSerializers.WOODWORKING.get(), id, group, ingredient, ingredientCount, supplement, supplementCount, dye, dyeCount, result, requiresDye);
    }

    public WoodworkingRecipe(RecipeType<?> type, RecipeSerializer<?> serializer, ResourceLocation id, String group, Ingredient ingredient, int ingredientCount, Ingredient supplement, int supplementCount, Ingredient dye, int dyeCount, ItemStack result, boolean requiresDye) {
        this.type = type;
        this.serializer = serializer;
        this.id = id;
        this.group = group;
        this.ingredient = ingredient;
        this.supplement = supplement;
        this.dye = dye;
        this.result = result;
        this.requiresDye = requiresDye;
        this.ingredientCount = ingredientCount;
        this.supplementCount = supplementCount;
        this.dyeCount = dyeCount;
    }

    public boolean m_5818_(Container container, @NotNull Level world) {
        boolean hasRequiredIngredient;
        ItemStack itemStack = container.m_8020_(0);
        ItemStack itemStack1 = container.m_8020_(1);
        ItemStack itemStack2 = container.m_8020_(2);
        boolean bl = hasRequiredIngredient = this.ingredient.test(itemStack) && itemStack.m_41613_() >= this.ingredientCount && this.supplement.test(itemStack1) && itemStack1.m_41613_() >= this.supplementCount;
        if (this.requiresDye) {
            return hasRequiredIngredient && this.dye.test(itemStack2) && itemStack2.m_41613_() >= this.dyeCount;
        }
        return hasRequiredIngredient;
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)BlockRegistry.CARPENTRY_TABLE.get());
    }

    public RecipeType<?> m_6671_() {
        return this.type;
    }

    public RecipeSerializer<?> m_7707_() {
        return this.serializer;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public String m_6076_() {
        return this.group;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.result.m_41777_();
    }

    public ItemStack getResultItem() {
        return this.m_8043_(null);
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList ingredients = NonNullList.m_122779_();
        ingredients.add((Object)this.ingredient);
        ingredients.add((Object)this.supplement);
        if (this.requiresDye) {
            ingredients.add((Object)this.dye);
        }
        return ingredients;
    }

    public boolean m_8004_(int i, int j) {
        return true;
    }

    public ItemStack m_5874_(Container container, RegistryAccess registryAccess) {
        return this.result.m_41777_();
    }

    public boolean requiresDye() {
        return this.requiresDye;
    }

    public int getIngredientCount() {
        return this.ingredientCount;
    }

    public int getSupplementCount() {
        return this.supplementCount;
    }

    public int getDyeCount() {
        return this.dyeCount;
    }

    public static class Serializer<T extends WoodworkingRecipe>
    implements RecipeSerializer<T> {
        final SingleItemMaker<T> recipeFactory;

        protected Serializer(SingleItemMaker<T> singleItemMaker) {
            this.recipeFactory = singleItemMaker;
        }

        public T fromJson(ResourceLocation resourceLocation, JsonObject jsonObject) {
            String group = GsonHelper.m_13851_((JsonObject)jsonObject, (String)"group", (String)"");
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)jsonObject, (String)"ingredient"));
            int ingredientCount = GsonHelper.m_13824_((JsonObject)jsonObject.getAsJsonObject("ingredient"), (String)"count", (int)1);
            Ingredient supplement = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)jsonObject, (String)"supplement"));
            int supplementCount = GsonHelper.m_13824_((JsonObject)jsonObject.getAsJsonObject("supplement"), (String)"count", (int)1);
            Ingredient dye = Ingredient.f_43901_;
            int dyeCount = 0;
            boolean requiresDye = jsonObject.has("dye");
            if (requiresDye) {
                dye = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)jsonObject, (String)"dye"));
                dyeCount = GsonHelper.m_13824_((JsonObject)jsonObject.getAsJsonObject("dye"), (String)"count", (int)1);
            }
            String resultItem = GsonHelper.m_13906_((JsonObject)jsonObject.getAsJsonObject("result"), (String)"item");
            int resultCount = GsonHelper.m_13824_((JsonObject)jsonObject.getAsJsonObject("result"), (String)"count", (int)1);
            ItemStack resultStack = new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(resultItem)), resultCount);
            return this.recipeFactory.create(resourceLocation, group, ingredient, ingredientCount, supplement, supplementCount, dye, dyeCount, resultStack, requiresDye);
        }

        public T fromNetwork(ResourceLocation resourceLocation, FriendlyByteBuf buffer) {
            String group = buffer.m_130277_();
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            int ingredientCount = buffer.readInt();
            Ingredient supplement = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            int supplementCount = buffer.readInt();
            Ingredient dye = Ingredient.f_43901_;
            int dyeCount = 0;
            boolean requiresDye = buffer.readBoolean();
            if (requiresDye) {
                dye = Ingredient.m_43940_((FriendlyByteBuf)buffer);
                dyeCount = buffer.readInt();
            }
            ItemStack result = buffer.m_130267_();
            return this.recipeFactory.create(resourceLocation, group, ingredient, ingredientCount, supplement, supplementCount, dye, dyeCount, result, requiresDye);
        }

        public void toNetwork(FriendlyByteBuf buffer, T recipe) {
            buffer.m_130070_(((WoodworkingRecipe)recipe).group);
            ((WoodworkingRecipe)recipe).ingredient.m_43923_(buffer);
            buffer.writeInt(((WoodworkingRecipe)recipe).ingredientCount);
            ((WoodworkingRecipe)recipe).supplement.m_43923_(buffer);
            buffer.writeInt(((WoodworkingRecipe)recipe).supplementCount);
            buffer.writeBoolean(((WoodworkingRecipe)recipe).requiresDye);
            if (((WoodworkingRecipe)recipe).requiresDye) {
                ((WoodworkingRecipe)recipe).dye.m_43923_(buffer);
                buffer.writeInt(((WoodworkingRecipe)recipe).dyeCount);
            }
            buffer.m_130055_(((WoodworkingRecipe)recipe).result);
        }

        public static interface SingleItemMaker<T extends WoodworkingRecipe> {
            public T create(ResourceLocation var1, String var2, Ingredient var3, int var4, Ingredient var5, int var6, Ingredient var7, int var8, ItemStack var9, boolean var10);
        }
    }
}

