/*
 * Decompiled with CFR 0.152.
 */
package com.conquest.hearthfire.world.level.block;

import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class AbstractFoodBlock
extends Block {
    protected final IntegerProperty BITES;
    protected final int maxBites;
    protected final Block baseBlock;
    protected final int hunger;
    protected final float saturationMod;
    protected final VoxelShape voxelShape;

    public AbstractFoodBlock(BlockBehaviour.Properties properties, VoxelShape voxelShape, Block baseBlock, FoodProperties foodProperties, IntegerProperty bitesProperty, int maxBites) {
        super(properties);
        this.BITES = bitesProperty;
        this.maxBites = maxBites;
        this.baseBlock = baseBlock;
        this.hunger = foodProperties.m_38744_();
        this.saturationMod = foodProperties.m_38745_();
        this.voxelShape = voxelShape;
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext context) {
        return this.voxelShape;
    }

    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        ItemStack itemStack = player.m_21120_(interactionHand);
        if (level.m_5776_()) {
            if (this.eat(level, blockPos, blockState, player).m_19077_()) {
                return InteractionResult.SUCCESS;
            }
            if (itemStack.m_41619_()) {
                return InteractionResult.CONSUME;
            }
        }
        return this.eat(level, blockPos, blockState, player);
    }

    protected InteractionResult eat(Level level, BlockPos blockPos, BlockState blockState, Player player) {
        if (!player.m_36391_(false)) {
            return InteractionResult.PASS;
        }
        player.m_36324_().m_38707_(this.hunger, this.saturationMod);
        int i = (Integer)blockState.m_61143_((Property)this.BITES);
        level.m_142346_((Entity)player, GameEvent.f_157806_, blockPos);
        if (i < this.maxBites) {
            level.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)this.BITES, (Comparable)Integer.valueOf(i + 1)), 3);
        } else {
            level.m_46597_(blockPos, this.baseBlock.m_49966_());
            level.m_142346_((Entity)player, GameEvent.f_157794_, blockPos);
        }
        return InteractionResult.SUCCESS;
    }

    public boolean m_7278_(BlockState blockState) {
        return true;
    }

    public boolean m_7357_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, PathComputationType pathComputationType) {
        return false;
    }

    public int m_6782_(BlockState blockState, Level level, BlockPos blockPos) {
        return this.getOutputSignal((Integer)blockState.m_61143_((Property)this.BITES));
    }

    protected int getOutputSignal(int bites) {
        return (this.maxBites + 1 - bites) * 2;
    }
}

