/*
 * Decompiled with CFR 0.152.
 */
package com.conquest.hearthfire.world.level.block;

import com.conquest.hearthfire.world.level.block.HorizontalDirectionalBlock;
import com.conquest.hearthfire.world.level.block.state.properties.BlockStateProperties;
import com.conquest.hearthfire.world.level.block.state.properties.HorizontalConnection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractHorizontalConnectingBlock
extends HorizontalDirectionalBlock {
    public static final EnumProperty<HorizontalConnection> SHAPE = BlockStateProperties.HORIZONTAL_CONNECTION;

    protected AbstractHorizontalConnectingBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(SHAPE, (Comparable)((Object)HorizontalConnection.SINGLE)));
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Level level = context.m_43725_();
        BlockPos blockPos = context.m_8083_();
        Direction facing = context.m_8125_().m_122424_();
        BlockState blockState = (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing);
        HorizontalConnection shape = this.determineShape(this.attachesTo(level.m_8055_(blockPos.m_121945_(facing.m_122428_())), facing), this.attachesTo(level.m_8055_(blockPos.m_121945_(facing.m_122427_())), facing));
        return (BlockState)blockState.m_61124_(SHAPE, (Comparable)((Object)shape));
    }

    public BlockState m_7417_(BlockState blockState, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (blockState.m_60734_() == this) {
            Direction facing = (Direction)blockState.m_61143_((Property)FACING);
            HorizontalConnection shape = this.determineShape(this.attachesTo(world.m_8055_(pos.m_121945_(facing.m_122428_())), facing), this.attachesTo(world.m_8055_(pos.m_121945_(facing.m_122427_())), facing));
            return (BlockState)blockState.m_61124_(SHAPE, (Comparable)((Object)shape));
        }
        return super.m_7417_(blockState, direction, neighborState, world, pos, neighborPos);
    }

    HorizontalConnection determineShape(boolean attachesToLeft, boolean attachesToRight) {
        if (attachesToLeft && attachesToRight) {
            return HorizontalConnection.MIDDLE;
        }
        if (attachesToLeft) {
            return HorizontalConnection.LEFT;
        }
        if (attachesToRight) {
            return HorizontalConnection.RIGHT;
        }
        return HorizontalConnection.SINGLE;
    }

    protected boolean attachesTo(BlockState blockState, Direction direction) {
        return blockState.m_60734_() == this && blockState.m_61143_((Property)FACING) == direction;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, SHAPE});
    }
}

