/*
 * Decompiled with CFR 0.152.
 */
package com.conquest.hearthfire.world.level.block;

import com.conquest.hearthfire.util.Util;
import com.conquest.hearthfire.world.level.block.HorizontalDirectionalBlock;
import com.conquest.hearthfire.world.level.block.entity.StorageBlockEntity;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractStorageBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    public static final SoundEvent DEFAULT_SOUND = SoundEvents.f_12635_;

    protected AbstractStorageBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new StorageBlockEntity(blockPos, blockState, this.getCapacity());
    }

    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (blockEntity instanceof StorageBlockEntity) {
            StorageBlockEntity storageBlockEntity = (StorageBlockEntity)blockEntity;
            Optional<Tuple<Float, Float>> hitCoordinates = Util.getRelativeHitCoordinatesForBlockFace(blockHitResult, (Direction)blockState.m_61143_((Property)FACING), this.getRestrictedDirections());
            if (hitCoordinates.isEmpty()) {
                return InteractionResult.PASS;
            }
            Tuple<Float, Float> coordinates = hitCoordinates.get();
            int slot = this.calculateSlot((Float)coordinates.m_14418_(), (Float)coordinates.m_14419_());
            if (slot == Integer.MIN_VALUE || slot >= storageBlockEntity.getInventory().size() || slot < 0) {
                return InteractionResult.PASS;
            }
            if (!((ItemStack)storageBlockEntity.getInventory().get(slot)).m_41619_()) {
                this.removeItem(level, blockPos, player, storageBlockEntity, slot);
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            ItemStack heldItem = player.m_21120_(interactionHand);
            if (!heldItem.m_41619_() && this.isItemValidForSlot(heldItem)) {
                this.addItem(level, blockPos, player, storageBlockEntity, heldItem, slot);
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public void addItem(Level level, BlockPos blockPos, Player player, StorageBlockEntity blockEntity, ItemStack itemStack, int slot) {
        if (!level.f_46443_) {
            SoundEvent addSound = this.getAddSound(level, blockPos, player, slot);
            blockEntity.updateItem(slot, itemStack.m_41620_(1));
            level.m_5594_(null, blockPos, addSound, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (player.m_7500_()) {
                itemStack.m_41769_(1);
            }
            level.m_142346_((Entity)player, GameEvent.f_157792_, blockPos);
        }
    }

    public void removeItem(Level level, BlockPos blockPos, Player player, StorageBlockEntity potEntity, int slot) {
        if (!level.f_46443_) {
            ItemStack removedItem = potEntity.removeItem(slot);
            SoundEvent removeSound = this.getRemoveSound(level, blockPos, player, slot);
            level.m_5594_(null, blockPos, removeSound, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!player.m_150109_().m_36054_(removedItem)) {
                player.m_36176_(removedItem, false);
            }
            level.m_142346_((Entity)player, GameEvent.f_157792_, blockPos);
        }
    }

    public SoundEvent getRemoveSound(Level level, BlockPos blockPos, Player player, int slot) {
        return DEFAULT_SOUND;
    }

    public SoundEvent getAddSound(Level level, BlockPos blockPos, Player player, int slot) {
        return DEFAULT_SOUND;
    }

    public void m_6810_(BlockState blockState, Level level, BlockPos blockPos, BlockState blockState2, boolean bl) {
        if (!blockState.m_60713_(blockState2.m_60734_())) {
            BlockEntity blockEntity = level.m_7702_(blockPos);
            if (blockEntity instanceof StorageBlockEntity) {
                StorageBlockEntity potEntity = (StorageBlockEntity)blockEntity;
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    Containers.m_19010_((Level)serverLevel, (BlockPos)blockPos, potEntity.getInventory());
                }
                level.m_46717_(blockPos, (Block)this);
            }
            super.m_6810_(blockState, level, blockPos, blockState2, bl);
        }
    }

    @NotNull
    public RenderShape m_7514_(BlockState blockState) {
        return RenderShape.MODEL;
    }

    public abstract int getCapacity();

    public abstract ResourceLocation getBlockType();

    public abstract Direction[] getRestrictedDirections();

    public abstract boolean isItemValidForSlot(ItemStack var1);

    public abstract int calculateSlot(Float var1, Float var2);
}

