/*
 * Decompiled with CFR 0.152.
 */
package com.conquest.hearthfire.world.level.block;

import com.conquest.hearthfire.core.particles.ParticleTypes;
import com.conquest.hearthfire.world.level.block.HorizontalDirectionalBlock;
import com.conquest.hearthfire.world.level.block.state.properties.BlockStateProperties;
import com.conquest.hearthfire.world.level.block.state.properties.Part;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class BathtubBlock
extends HorizontalDirectionalBlock {
    public static final EnumProperty<Part> PART = BlockStateProperties.PART;
    public static final BooleanProperty EMPTY = BlockStateProperties.EMPTY;

    protected BathtubBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(PART, (Comparable)((Object)Part.FOOT))).m_61124_((Property)EMPTY, (Comparable)Boolean.TRUE));
    }

    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        ItemStack itemStack = player.m_21120_(interactionHand);
        Item item = itemStack.m_41720_();
        Part part = (Part)((Object)blockState.m_61143_(PART));
        BlockPos blockpos = blockPos.m_121945_(BathtubBlock.getNeighbourDirection(part, (Direction)blockState.m_61143_((Property)FACING)));
        BlockState state = level.m_8055_(blockpos);
        if (!((Boolean)blockState.m_61143_((Property)EMPTY)).booleanValue()) {
            if (!level.f_46443_ && item == Items.f_42446_) {
                player.m_21008_(interactionHand, ItemUtils.m_41813_((ItemStack)new ItemStack((ItemLike)Items.f_42446_), (Player)player, (ItemStack)new ItemStack((ItemLike)Items.f_42447_)));
                level.m_46597_(blockPos, (BlockState)((BlockState)((BlockState)blockState.m_61124_((Property)EMPTY, (Comparable)Boolean.TRUE)).m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING)))).m_61124_(PART, (Comparable)((Object)part)));
                level.m_5594_(null, blockPos, SoundEvents.f_11781_, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.m_142346_(null, GameEvent.f_157816_, blockPos);
            }
        } else if (!level.f_46443_ && item == Items.f_42447_) {
            player.m_21008_(interactionHand, ItemUtils.m_41813_((ItemStack)new ItemStack((ItemLike)Items.f_42447_), (Player)player, (ItemStack)new ItemStack((ItemLike)Items.f_42446_)));
            level.m_46597_(blockPos, (BlockState)((BlockState)((BlockState)blockState.m_61124_((Property)EMPTY, (Comparable)Boolean.FALSE)).m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING)))).m_61124_(PART, (Comparable)((Object)part)));
            level.m_5594_(null, blockPos, SoundEvents.f_11778_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_142346_(null, GameEvent.f_157769_, blockPos);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public void m_214162_(BlockState blockState, Level level, BlockPos blockPos, RandomSource source) {
        if (!((Boolean)blockState.m_61143_((Property)EMPTY)).booleanValue()) {
            double d0 = (double)blockPos.m_123341_() + 0.5 + source.m_188500_() / 4.0 * (double)(source.m_188499_() ? 1 : -1);
            double d1 = (double)blockPos.m_123342_() + 0.8;
            double d2 = (double)blockPos.m_123343_() + 0.5 + source.m_188500_() / 4.0 * (double)(source.m_188499_() ? 1 : -1);
            level.m_7106_((ParticleOptions)ParticleTypes.VAPOR_PARTICLE.get(), d0, d1, d2, 0.0, 0.005, 0.0);
        }
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction = context.m_8125_();
        BlockPos blockPos = context.m_8083_();
        BlockPos blockPos1 = blockPos.m_121945_(direction);
        Level level = context.m_43725_();
        if (level.m_8055_(blockPos1).m_60629_(context) && level.m_6857_().m_61937_(blockPos1)) {
            return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)direction);
        }
        return null;
    }

    public BlockState m_7417_(BlockState blockState, Direction direction, BlockState neighborState, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos neighborPos) {
        if (direction == BathtubBlock.getNeighbourDirection((Part)((Object)blockState.m_61143_(PART)), (Direction)blockState.m_61143_((Property)FACING))) {
            return neighborState.m_60713_((Block)this) && neighborState.m_61143_(PART) != blockState.m_61143_(PART) ? (BlockState)blockState.m_61124_((Property)EMPTY, (Comparable)((Boolean)neighborState.m_61143_((Property)EMPTY))) : Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(blockState, direction, neighborState, levelAccessor, blockPos, neighborPos);
    }

    public boolean m_7357_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, PathComputationType type) {
        return false;
    }

    private static Direction getNeighbourDirection(Part part, Direction direction) {
        return part == Part.FOOT ? direction : direction.m_122424_();
    }

    public void m_5707_(Level level, BlockPos blockPos, BlockState blockState, Player player) {
        BlockPos pos;
        BlockState state;
        Part part;
        if (!level.f_46443_ && player.m_7500_() && (part = (Part)((Object)blockState.m_61143_(PART))) == Part.FOOT && (state = level.m_8055_(pos = blockPos.m_121945_(BathtubBlock.getNeighbourDirection(part, (Direction)blockState.m_61143_((Property)FACING))))).m_60713_((Block)this) && state.m_61143_(PART) == Part.HEAD) {
            level.m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 35);
            level.m_5898_(player, 2001, blockPos, Block.m_49956_((BlockState)state));
        }
        super.m_5707_(level, blockPos, blockState, player);
    }

    public void m_6402_(Level level, BlockPos blockPos, BlockState blockState, @Nullable LivingEntity livingEntity, ItemStack itemStack) {
        super.m_6402_(level, blockPos, blockState, livingEntity, itemStack);
        if (!level.f_46443_) {
            BlockPos blockpos = blockPos.m_121945_((Direction)blockState.m_61143_((Property)FACING));
            level.m_7731_(blockpos, (BlockState)blockState.m_61124_(PART, (Comparable)((Object)Part.HEAD)), 3);
            level.m_6289_(blockPos, Blocks.f_50016_);
            blockState.m_60701_((LevelAccessor)level, blockPos, 3);
        }
    }

    public long m_7799_(BlockState blockState, BlockPos blockPos) {
        BlockPos blockPos2 = blockPos.m_5484_((Direction)blockState.m_61143_((Property)FACING), blockState.m_61143_(PART) == Part.HEAD ? 0 : 1);
        return Mth.m_14130_((int)blockPos2.m_123341_(), (int)blockPos.m_123342_(), (int)blockPos2.m_123343_());
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, PART, EMPTY});
    }
}

