/*
 * Decompiled with CFR 0.152.
 */
package com.conquest.hearthfire.world.level.block;

import com.conquest.hearthfire.world.level.block.BlockRegistry;
import com.conquest.hearthfire.world.level.block.ButterChurnExtensionBlock;
import com.conquest.hearthfire.world.level.block.entity.BlockEntityTypes;
import com.conquest.hearthfire.world.level.block.entity.ButterChurnBlockEntity;
import com.conquest.hearthfire.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ButterChurnBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    private final ButterChurnExtensionBlock upperBlock;
    protected static final VoxelShape SHAPE = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    protected static final VoxelShape NORTH_SOUTH = Block.m_49796_((double)0.0, (double)8.0, (double)4.0, (double)16.0, (double)32.0, (double)12.0);
    protected static final VoxelShape EAST_WEST = Block.m_49796_((double)4.0, (double)8.0, (double)0.0, (double)12.0, (double)32.0, (double)16.0);

    protected ButterChurnBlock(ButterChurnExtensionBlock upperBlock, BlockBehaviour.Properties properties) {
        super(properties);
        this.upperBlock = upperBlock;
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        if (blockState.m_60734_() == BlockRegistry.BUTTER_CHURN.get()) {
            return SHAPE;
        }
        return switch ((Direction)blockState.m_61143_((Property)FACING)) {
            default -> NORTH_SOUTH;
            case Direction.EAST, Direction.WEST -> EAST_WEST;
        };
    }

    public RenderShape m_7514_(BlockState blockState) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new ButterChurnBlockEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return level.f_46443_ ? null : ButterChurnBlock.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)BlockEntityTypes.BUTTER_CHURN.get()), ButterChurnBlockEntity::serverTick);
    }

    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (blockEntity instanceof ButterChurnBlockEntity) {
            player.m_5893_((MenuProvider)((ButterChurnBlockEntity)blockEntity));
        }
        return InteractionResult.CONSUME;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos blockPos = context.m_8083_();
        Level level = context.m_43725_();
        if (blockPos.m_123342_() < level.m_151558_() - 1 && level.m_8055_(blockPos.m_7494_()).m_60629_(context)) {
            return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
        }
        return null;
    }

    public BlockState m_7417_(BlockState blockState, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos blockPos, BlockPos neighborPos) {
        BlockState state1 = world.m_8055_(blockPos.m_7494_());
        boolean flag = blockState.m_60713_((Block)BlockRegistry.BUTTER_CHURN.get());
        boolean flag1 = blockState.m_60713_((Block)BlockRegistry.HANGING_BARREL.get());
        boolean flag2 = state1.m_60713_((Block)BlockRegistry.BUTTER_CHURN_EXTENSION.get());
        boolean flag3 = state1.m_60713_((Block)BlockRegistry.HANGING_BARREL_EXTENSION.get());
        return flag && flag2 || flag1 && flag3 ? super.m_7417_(blockState, direction, neighborState, world, blockPos, neighborPos) : Blocks.f_50016_.m_49966_();
    }

    public void m_6402_(Level level, BlockPos blockPos, BlockState blockState, @Nullable LivingEntity livingEntity, ItemStack itemStack) {
        BlockEntity blockEntity;
        if (itemStack.m_41788_() && (blockEntity = level.m_7702_(blockPos)) instanceof ButterChurnBlockEntity) {
            ((ButterChurnBlockEntity)blockEntity).m_58638_(itemStack.m_41786_());
        }
        level.m_7731_(blockPos.m_7494_(), this.upperBlock.m_49966_(), 3);
    }

    public void m_6810_(BlockState blockState, Level level, BlockPos blockPos, BlockState blockState2, boolean bl) {
        if (!blockState.m_60713_(blockState2.m_60734_())) {
            BlockEntity blockEntity = level.m_7702_(blockPos);
            if (blockEntity instanceof ButterChurnBlockEntity) {
                Containers.m_19002_((Level)level, (BlockPos)blockPos, (Container)((ButterChurnBlockEntity)blockEntity));
            }
            super.m_6810_(blockState, level, blockPos, blockState2, bl);
        }
    }

    public boolean m_7278_(BlockState blockState) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level level, BlockPos blockPos) {
        return AbstractContainerMenu.m_38918_((BlockEntity)level.m_7702_(blockPos));
    }

    public BlockState m_6843_(BlockState blockState, Rotation rotation) {
        return (BlockState)blockState.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)blockState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState blockState, Mirror mirror) {
        return blockState.m_60717_(mirror.m_54846_((Direction)blockState.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public boolean m_7357_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, PathComputationType pathComputationType) {
        return false;
    }
}

