/*
 * Decompiled with CFR 0.152.
 */
package com.conquest.hearthfire.world.level.block;

import com.conquest.hearthfire.tags.ItemTagRegistry;
import com.conquest.hearthfire.world.level.block.AbstractStorageBlock;
import com.conquest.hearthfire.world.level.block.entity.StorageBlockTypes;
import com.conquest.hearthfire.world.level.block.state.properties.BlockStateProperties;
import com.conquest.hearthfire.world.level.block.state.properties.HorizontalConnection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DryingRackBlock
extends AbstractStorageBlock {
    public static final EnumProperty<HorizontalConnection> SHAPE = BlockStateProperties.HORIZONTAL_CONNECTION;
    protected static final VoxelShape EAST_AABB = Block.m_49796_((double)1.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST_AABB = Block.m_49796_((double)12.0, (double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SOUTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0, (double)4.0);
    protected static final VoxelShape NORTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0, (double)15.0);

    protected DryingRackBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(SHAPE, (Comparable)((Object)HorizontalConnection.SINGLE)));
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext context) {
        return switch ((Direction)blockState.m_61143_((Property)FACING)) {
            default -> NORTH_AABB;
            case Direction.SOUTH -> SOUTH_AABB;
            case Direction.WEST -> WEST_AABB;
            case Direction.EAST -> EAST_AABB;
        };
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Level level = context.m_43725_();
        BlockPos blockPos = context.m_8083_();
        Direction facing = context.m_8125_().m_122424_();
        BlockState blockState = (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing);
        HorizontalConnection shape = this.determineShape(this.attachesTo(level.m_8055_(blockPos.m_121945_(facing.m_122428_())), facing), this.attachesTo(level.m_8055_(blockPos.m_121945_(facing.m_122427_())), facing));
        return (BlockState)blockState.m_61124_(SHAPE, (Comparable)((Object)shape));
    }

    public BlockState m_7417_(BlockState blockState, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (blockState.m_60734_() == this) {
            Direction facing = (Direction)blockState.m_61143_((Property)FACING);
            HorizontalConnection shape = this.determineShape(this.attachesTo(world.m_8055_(pos.m_121945_(facing.m_122428_())), facing), this.attachesTo(world.m_8055_(pos.m_121945_(facing.m_122427_())), facing));
            return (BlockState)blockState.m_61124_(SHAPE, (Comparable)((Object)shape));
        }
        return super.m_7417_(blockState, direction, neighborState, world, pos, neighborPos);
    }

    HorizontalConnection determineShape(boolean attachesToLeft, boolean attachesToRight) {
        if (attachesToLeft && attachesToRight) {
            return HorizontalConnection.MIDDLE;
        }
        if (attachesToLeft) {
            return HorizontalConnection.LEFT;
        }
        if (attachesToRight) {
            return HorizontalConnection.RIGHT;
        }
        return HorizontalConnection.SINGLE;
    }

    protected boolean attachesTo(BlockState blockState, Direction direction) {
        return blockState.m_60734_() == this && blockState.m_61143_((Property)FACING) == direction;
    }

    @Override
    @NotNull
    public RenderShape m_7514_(BlockState blockState) {
        return RenderShape.MODEL;
    }

    @Override
    public int getCapacity() {
        return 2;
    }

    @Override
    public ResourceLocation getBlockType() {
        return StorageBlockTypes.DRYING_RACK;
    }

    @Override
    public Direction[] getRestrictedDirections() {
        return new Direction[]{Direction.DOWN};
    }

    @Override
    public boolean isItemValidForSlot(ItemStack itemStack) {
        return itemStack.m_204117_(ItemTagRegistry.HANGABLE_ON_RACK);
    }

    @Override
    public int calculateSlot(Float x, Float y) {
        return x.floatValue() < 0.5f ? 0 : 1;
    }

    public void m_213897_(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
        if (!blockState.m_60710_((LevelReader)serverLevel, blockPos)) {
            serverLevel.m_46961_(blockPos, true);
        }
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, SHAPE});
    }
}

