/*
 * Decompiled with CFR 0.152.
 */
package com.conquest.hearthfire.world.level.block;

import com.conquest.hearthfire.world.level.block.HorizontalDirectionalBlock;
import com.conquest.hearthfire.world.level.block.state.properties.BlockStateProperties;
import com.conquest.hearthfire.world.level.block.state.properties.HorizontalConnection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class HangingRugBlock
extends HorizontalDirectionalBlock {
    public static final EnumProperty<HorizontalConnection> SHAPE = BlockStateProperties.HORIZONTAL_CONNECTION;
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.DOUBLE_BLOCK_HALF;
    protected static final VoxelShape EAST_AABB = Block.m_49796_((double)1.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST_AABB = Block.m_49796_((double)12.0, (double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SOUTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0, (double)4.0);
    protected static final VoxelShape NORTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0, (double)15.0);

    protected HangingRugBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(SHAPE, (Comparable)((Object)HorizontalConnection.SINGLE))).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext context) {
        return switch ((Direction)blockState.m_61143_((Property)FACING)) {
            default -> NORTH_AABB;
            case Direction.SOUTH -> SOUTH_AABB;
            case Direction.WEST -> WEST_AABB;
            case Direction.EAST -> EAST_AABB;
        };
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos = context.m_8083_();
        Level level = context.m_43725_();
        BlockState state = (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
        return pos.m_123342_() < level.m_151558_() - 1 && level.m_8055_(pos.m_7494_()).m_60629_(context) ? (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)this.determineShape(state, (LevelAccessor)level, pos))) : null;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        DoubleBlockHalf doubleBlockHalf = (DoubleBlockHalf)state.m_61143_(HALF);
        if (direction.m_122434_().m_122479_()) {
            return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)this.determineShape(state, level, pos)));
        }
        if (direction.m_122434_() != Direction.Axis.Y || doubleBlockHalf == DoubleBlockHalf.LOWER != (direction == Direction.UP)) {
            return doubleBlockHalf == DoubleBlockHalf.LOWER && direction == Direction.DOWN && !state.m_60710_((LevelReader)level, pos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, direction, neighborState, level, pos, neighborPos);
        }
        return neighborState.m_60713_((Block)this) && neighborState.m_61143_(HALF) != doubleBlockHalf ? (BlockState)state.m_61124_((Property)FACING, (Comparable)((Direction)neighborState.m_61143_((Property)FACING))) : Blocks.f_50016_.m_49966_();
    }

    private HorizontalConnection determineShape(BlockState state, LevelAccessor level, BlockPos pos) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        DoubleBlockHalf half = (DoubleBlockHalf)state.m_61143_(HALF);
        boolean left = HangingRugBlock.attachesTo(level.m_8055_(pos.m_121945_(facing.m_122428_())), facing, half);
        boolean right = HangingRugBlock.attachesTo(level.m_8055_(pos.m_121945_(facing.m_122427_())), facing, half);
        return left && right ? HorizontalConnection.MIDDLE : (left ? HorizontalConnection.LEFT : (right ? HorizontalConnection.RIGHT : HorizontalConnection.SINGLE));
    }

    protected static void preventCreativeDropFromBottomPart(Level level, BlockPos blockPos, BlockState blockState, Player player) {
        BlockPos blockPos2;
        BlockState blockState2;
        DoubleBlockHalf doubleBlockHalf = (DoubleBlockHalf)blockState.m_61143_(HALF);
        if (doubleBlockHalf == DoubleBlockHalf.UPPER && (blockState2 = level.m_8055_(blockPos2 = blockPos.m_7495_())).m_60713_(blockState.m_60734_()) && blockState2.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            BlockState blockState3 = blockState2.m_60819_().m_192917_((Fluid)Fluids.f_76193_) ? Blocks.f_49990_.m_49966_() : Blocks.f_50016_.m_49966_();
            level.m_7731_(blockPos2, blockState3, 35);
            level.m_5898_(player, 2001, blockPos2, Block.m_49956_((BlockState)blockState2));
        }
    }

    public void m_5707_(Level level, BlockPos blockPos, BlockState blockState, Player player) {
        if (!level.f_46443_ && player.m_7500_()) {
            HangingRugBlock.preventCreativeDropFromBottomPart(level, blockPos, blockState, player);
        }
        super.m_5707_(level, blockPos, blockState, player);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity livingEntity, ItemStack itemStack) {
        BlockPos blockPos = pos.m_7494_();
        level.m_7731_(blockPos, (BlockState)state.m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
    }

    public boolean m_7898_(BlockState blockState, LevelReader levelReader, BlockPos blockPos) {
        if (blockState.m_61143_(HALF) != DoubleBlockHalf.UPPER) {
            return super.m_7898_(blockState, levelReader, blockPos);
        }
        BlockState state = levelReader.m_8055_(blockPos.m_7495_());
        return state.m_60713_((Block)this) && state.m_61143_(HALF) == DoubleBlockHalf.LOWER;
    }

    public long m_7799_(BlockState blockState, BlockPos blockPos) {
        return Mth.m_14130_((int)blockPos.m_123341_(), (int)blockPos.m_6625_(blockState.m_61143_(HALF) == DoubleBlockHalf.LOWER ? 0 : 1).m_123342_(), (int)blockPos.m_123343_());
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, HALF, SHAPE});
    }

    private static boolean attachesTo(BlockState blockState, Direction direction, DoubleBlockHalf half) {
        return HangingRugBlock.isSameBlock(blockState) && blockState.m_61143_((Property)FACING) == direction && blockState.m_61143_(HALF) == half;
    }

    private static boolean isSameBlock(BlockState blockState) {
        return blockState.m_60734_() instanceof HangingRugBlock;
    }
}

