/*
 * Decompiled with CFR 0.152.
 */
package com.conquest.hearthfire.world.level.block;

import com.conquest.hearthfire.world.item.ItemRegistry;
import com.conquest.hearthfire.world.level.block.BlockRegistry;
import com.conquest.hearthfire.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LayeredBucketBlock
extends Block {
    public static final IntegerProperty LEVEL = BlockStateProperties.LEVEL_BUCKET;
    public static final VoxelShape BUCKET = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)10.0, (double)13.0);

    public LayeredBucketBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(1)));
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        Vec3 vec3 = blockState.m_60824_(blockGetter, blockPos);
        return BUCKET.m_83216_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
    }

    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        ItemStack itemStack = player.m_21120_(interactionHand);
        Item item = itemStack.m_41720_();
        if (!level.f_46443_) {
            if (blockState.m_60734_() == BlockRegistry.MILK_BUCKET.get()) {
                if (item == Items.f_42455_ && this.isEmpty(blockState)) {
                    LayeredBucketBlock.fillBucket(level, blockPos, player, interactionHand, itemStack, blockState);
                }
                if (item == Items.f_42446_) {
                    LayeredBucketBlock.emptyBucket(level, blockPos, player, interactionHand, itemStack, new ItemStack((ItemLike)Items.f_42455_), blockState);
                }
            }
            if (blockState.m_60734_() == BlockRegistry.WATER_BUCKET.get()) {
                if (item == Items.f_42447_ && this.isEmpty(blockState)) {
                    LayeredBucketBlock.fillBucket(level, blockPos, player, interactionHand, itemStack, blockState);
                }
                if (item == Items.f_42446_) {
                    LayeredBucketBlock.emptyBucket(level, blockPos, player, interactionHand, itemStack, new ItemStack((ItemLike)Items.f_42447_), blockState);
                }
            }
            if (blockState.m_60734_() == BlockRegistry.BUTTER_BUCKET.get()) {
                if (item == ItemRegistry.BUTTER.get() && this.isEmpty(blockState)) {
                    player.m_36220_(Stats.f_12943_);
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
                    level.m_46597_(blockPos, (BlockState)blockState.m_61122_((Property)LEVEL));
                    level.m_5594_(null, blockPos, SoundEvents.f_11967_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    level.m_142346_(null, GameEvent.f_157769_, blockPos);
                    itemStack.m_41774_(1);
                }
                if (item != ItemRegistry.BUTTER.get()) {
                    player.m_36220_(Stats.f_12944_);
                    LayeredBucketBlock.m_49840_((Level)level, (BlockPos)blockPos, (ItemStack)new ItemStack((ItemLike)ItemRegistry.BUTTER.get()));
                    LayeredBucketBlock.lowerFillLevel(blockState, level, blockPos);
                    level.m_5594_(null, blockPos, SoundEvents.f_11967_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    level.m_142346_(null, GameEvent.f_157816_, blockPos);
                }
            }
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public boolean isEmpty(BlockState blockState) {
        return (Integer)blockState.m_61143_((Property)LEVEL) != 4;
    }

    static void emptyBucket(Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, ItemStack itemStack, ItemStack result, BlockState blockState) {
        if (!level.f_46443_) {
            Item item = itemStack.m_41720_();
            player.m_21008_(interactionHand, ItemUtils.m_41813_((ItemStack)itemStack, (Player)player, (ItemStack)result));
            player.m_36220_(Stats.f_12944_);
            player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
            LayeredBucketBlock.lowerFillLevel(blockState, level, blockPos);
            level.m_5594_(null, blockPos, SoundEvents.f_11781_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_142346_(null, GameEvent.f_157816_, blockPos);
        }
    }

    static void fillBucket(Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, ItemStack itemStack, BlockState blockState) {
        if (!level.f_46443_) {
            Item item = itemStack.m_41720_();
            player.m_21008_(interactionHand, ItemUtils.m_41813_((ItemStack)itemStack, (Player)player, (ItemStack)new ItemStack((ItemLike)Items.f_42446_)));
            player.m_36220_(Stats.f_12943_);
            player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
            level.m_46597_(blockPos, (BlockState)blockState.m_61122_((Property)LEVEL));
            level.m_5594_(null, blockPos, SoundEvents.f_11778_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_142346_(null, GameEvent.f_157769_, blockPos);
        }
    }

    public static void lowerFillLevel(BlockState blockState, Level level, BlockPos blockPos) {
        int i = (Integer)blockState.m_61143_((Property)LEVEL) - 1;
        BlockState state = i == 0 ? ((Block)BlockRegistry.WOODEN_BUCKET.get()).m_49966_() : (BlockState)blockState.m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(i));
        level.m_46597_(blockPos, state);
        level.m_220407_(GameEvent.f_157792_, blockPos, GameEvent.Context.m_223722_((BlockState)state));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{LEVEL});
    }
}

