/*
 * Decompiled with CFR 0.152.
 */
package com.conquest.hearthfire.world.level.block;

import com.conquest.hearthfire.tags.ItemTagRegistry;
import com.conquest.hearthfire.world.level.block.AbstractStorageBlock;
import com.conquest.hearthfire.world.level.block.BlockRegistry;
import com.conquest.hearthfire.world.level.block.entity.StorageBlockTypes;
import com.conquest.hearthfire.world.level.block.state.properties.BlockStateProperties;
import com.conquest.hearthfire.world.level.block.state.properties.HorizontalConnection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WallShelfBlock
extends AbstractStorageBlock {
    public static final EnumProperty<HorizontalConnection> SHAPE = BlockStateProperties.HORIZONTAL_CONNECTION;
    public static final BooleanProperty UP = BlockStateProperties.UP;
    protected static final VoxelShape NORTH = Block.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape EAST = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SOUTH = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
    protected static final VoxelShape WEST = Block.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    protected WallShelfBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(SHAPE, (Comparable)((Object)HorizontalConnection.SINGLE))).m_61124_((Property)UP, (Comparable)Boolean.TRUE));
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext context) {
        return switch ((Direction)blockState.m_61143_((Property)FACING)) {
            default -> NORTH;
            case Direction.EAST -> EAST;
            case Direction.SOUTH -> SOUTH;
            case Direction.WEST -> WEST;
        };
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Level level = context.m_43725_();
        BlockPos blockPos = context.m_8083_();
        BlockPos blockPos1 = blockPos.m_7494_();
        Direction direction = context.m_8125_().m_122424_();
        BlockState blockState = (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)direction);
        BlockState blockState1 = level.m_8055_(blockPos1);
        boolean bl = blockState1.m_60734_() instanceof WallShelfBlock && blockState1.m_61143_((Property)FACING) == direction;
        HorizontalConnection shape = this.determineShape(this.attachesTo(level.m_8055_(blockPos.m_121945_(direction.m_122428_())), direction), this.attachesTo(level.m_8055_(blockPos.m_121945_(direction.m_122427_())), direction));
        return (BlockState)((BlockState)blockState.m_61124_(SHAPE, (Comparable)((Object)shape))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(!bl));
    }

    public BlockState m_7417_(BlockState blockState, Direction direction, BlockState neighborState, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos neighborPos) {
        if (blockState.m_60734_() == this) {
            Direction facing = (Direction)blockState.m_61143_((Property)FACING);
            HorizontalConnection shape = this.determineShape(this.attachesTo(levelAccessor.m_8055_(blockPos.m_121945_(facing.m_122428_())), facing), this.attachesTo(levelAccessor.m_8055_(blockPos.m_121945_(facing.m_122427_())), facing));
            boolean bl = levelAccessor.m_8055_(blockPos.m_7494_()).m_60734_() instanceof WallShelfBlock && levelAccessor.m_8055_(blockPos.m_7494_()).m_61143_((Property)FACING) == facing;
            return (BlockState)((BlockState)blockState.m_61124_(SHAPE, (Comparable)((Object)shape))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(!bl));
        }
        return super.m_7417_(blockState, direction, neighborState, levelAccessor, blockPos, neighborPos);
    }

    HorizontalConnection determineShape(boolean attachesToLeft, boolean attachesToRight) {
        if (attachesToLeft && attachesToRight) {
            return HorizontalConnection.MIDDLE;
        }
        if (attachesToLeft) {
            return HorizontalConnection.LEFT;
        }
        if (attachesToRight) {
            return HorizontalConnection.RIGHT;
        }
        return HorizontalConnection.SINGLE;
    }

    protected boolean attachesTo(BlockState blockState, Direction direction) {
        return blockState.m_60734_() == this && blockState.m_61143_((Property)FACING) == direction;
    }

    @Override
    @NotNull
    public RenderShape m_7514_(BlockState blockState) {
        return RenderShape.MODEL;
    }

    @Override
    public int getCapacity() {
        return 3;
    }

    @Override
    public ResourceLocation getBlockType() {
        return StorageBlockTypes.OLD_WOOD_WALL_SHELF;
    }

    @Override
    public Direction[] getRestrictedDirections() {
        return new Direction[]{Direction.DOWN};
    }

    @Override
    public boolean isItemValidForSlot(ItemStack itemStack) {
        return itemStack.m_204117_(ItemTagRegistry.JAM_JARS) || itemStack.m_204117_(ItemTagRegistry.BOTTLES) || itemStack.m_150930_(((Block)BlockRegistry.SACK.get()).m_5456_());
    }

    @Override
    public int calculateSlot(Float x, Float y) {
        if (x.floatValue() < 0.0f || x.floatValue() > 1.0f || y.floatValue() < 0.0f || y.floatValue() > 1.0f) {
            return Integer.MIN_VALUE;
        }
        float sectionWidth = 1.0f / (float)this.getCapacity();
        int slot = (int)(x.floatValue() / sectionWidth);
        return slot >= 0 && slot < this.getCapacity() ? slot : Integer.MIN_VALUE;
    }

    public void m_213897_(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
        if (!blockState.m_60710_((LevelReader)serverLevel, blockPos)) {
            serverLevel.m_46961_(blockPos, true);
        }
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, SHAPE, UP});
    }
}

