/*
 * Decompiled with CFR 0.152.
 */
package com.conquest.hearthfire.world.level.block;

import com.conquest.hearthfire.tags.ItemTagRegistry;
import com.conquest.hearthfire.world.level.block.AbstractStorageBlock;
import com.conquest.hearthfire.world.level.block.entity.StorageBlockTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class WindowPlanterBlock
extends AbstractStorageBlock {
    protected WindowPlanterBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return switch ((Direction)blockState.m_61143_((Property)FACING)) {
            default -> Block.m_49796_((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)14.0, (double)16.0);
            case Direction.EAST -> Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)10.0, (double)14.0, (double)16.0);
            case Direction.SOUTH -> Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)10.0);
            case Direction.WEST -> Block.m_49796_((double)6.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0);
        };
    }

    @Override
    @NotNull
    public RenderShape m_7514_(BlockState blockState) {
        return RenderShape.MODEL;
    }

    @Override
    public int getCapacity() {
        return 3;
    }

    @Override
    public ResourceLocation getBlockType() {
        return StorageBlockTypes.WINDOW_PLANTER;
    }

    @Override
    public Direction[] getRestrictedDirections() {
        return new Direction[]{Direction.DOWN};
    }

    @Override
    public boolean isItemValidForSlot(ItemStack itemStack) {
        return itemStack.m_204117_(ItemTagRegistry.SMALL_FLOWERS);
    }

    @Override
    public int calculateSlot(Float x, Float y) {
        if (x.floatValue() < 0.0f || x.floatValue() > 1.0f || y.floatValue() < 0.0f || y.floatValue() > 1.0f) {
            return Integer.MIN_VALUE;
        }
        float sectionWidth = 1.0f / (float)this.getCapacity();
        int slot = (int)(x.floatValue() / sectionWidth);
        return slot >= 0 && slot < this.getCapacity() ? slot : Integer.MIN_VALUE;
    }

    public void m_213897_(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
        if (!blockState.m_60710_((LevelReader)serverLevel, blockPos)) {
            serverLevel.m_46961_(blockPos, true);
        }
    }
}

