/*
 * Decompiled with CFR 0.152.
 */
package com.conquest.hearthfire.world.level.block.entity;

import com.conquest.hearthfire.world.inventory.ButterChurnMenu;
import com.conquest.hearthfire.world.item.ItemRegistry;
import com.conquest.hearthfire.world.level.block.entity.BlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class ButterChurnBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer {
    protected static final int SLOT_INPUT = 0;
    protected static final int SLOT_FUEL = 1;
    protected static final int SLOT_RESULT = 2;
    private static final int[] SLOTS_FOR_UP = new int[]{0};
    private static final int[] SLOTS_FOR_DOWN = new int[]{2};
    private static final int[] SLOTS_FOR_SIDES = new int[]{1};
    public static final int CHURN_TIME_STANDARD = 400;
    private NonNullList<ItemStack> items = NonNullList.m_122780_((int)3, (Object)ItemStack.f_41583_);
    int churningTime;
    protected final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int i) {
            if (i == 0) {
                return ButterChurnBlockEntity.this.churningTime;
            }
            return 0;
        }

        public void m_8050_(int i, int j) {
            if (i == 0) {
                ButterChurnBlockEntity.this.churningTime = j;
            }
        }

        public int m_6499_() {
            return 1;
        }
    };

    public ButterChurnBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)BlockEntityTypes.BUTTER_CHURN.get(), blockPos, blockState);
    }

    public void m_142466_(CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)compoundTag, this.items);
        this.churningTime = compoundTag.m_128448_("ChurningTime");
    }

    protected void m_183515_(CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        compoundTag.m_128376_("ChurningTime", (short)this.churningTime);
        ContainerHelper.m_18973_((CompoundTag)compoundTag, this.items);
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, ButterChurnBlockEntity butterChurnBlockEntity) {
        boolean bl = ButterChurnBlockEntity.canCraft(butterChurnBlockEntity.items);
        boolean bl2 = butterChurnBlockEntity.churningTime > 0;
        ItemStack itemStack = (ItemStack)butterChurnBlockEntity.items.get(0);
        if (bl2) {
            boolean bl3;
            --butterChurnBlockEntity.churningTime;
            boolean bl4 = bl3 = butterChurnBlockEntity.churningTime == 0;
            if (bl3 && bl) {
                ButterChurnBlockEntity.craft(level, blockPos, butterChurnBlockEntity.items);
                ButterChurnBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)blockState);
            } else if (!bl || !itemStack.m_150930_(Items.f_42455_)) {
                butterChurnBlockEntity.churningTime = 0;
                ButterChurnBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)blockState);
            }
        } else if (bl) {
            butterChurnBlockEntity.churningTime = 400;
            ButterChurnBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)blockState);
        }
    }

    private static boolean canCraft(NonNullList<ItemStack> nonNullList) {
        ItemStack itemStack = (ItemStack)nonNullList.get(0);
        ItemStack itemStack2 = (ItemStack)nonNullList.get(1);
        return itemStack.m_150930_(Items.f_42455_) && (itemStack2.m_150930_((Item)ItemRegistry.SALT.get()) || itemStack2.m_150930_((Item)ItemRegistry.PINK_SALT.get()));
    }

    private static void craft(Level level, BlockPos blockPos, NonNullList<ItemStack> nonNullList) {
        ItemStack itemStack = (ItemStack)nonNullList.get(0);
        ItemStack itemStack1 = (ItemStack)nonNullList.get(1);
        ItemStack itemStack2 = (ItemStack)nonNullList.get(2);
        if (itemStack2.m_41619_()) {
            nonNullList.set(2, (Object)new ItemStack((ItemLike)ItemRegistry.BUTTER.get()));
        } else if (itemStack2.m_150930_((Item)ItemRegistry.BUTTER.get())) {
            itemStack2.m_41769_(1);
        }
        itemStack.m_41774_(1);
        itemStack1.m_41774_(1);
        if (itemStack.m_41619_()) {
            nonNullList.set(0, (Object)new ItemStack((ItemLike)Items.f_42446_));
        }
        level.m_46796_(1500, blockPos, 0);
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"container.butter_churn");
    }

    protected AbstractContainerMenu m_6555_(int i, Inventory inventory) {
        return new ButterChurnMenu(i, inventory, (Container)this, this.dataAccess);
    }

    public boolean m_7013_(int i, ItemStack itemStack) {
        if (i == 2) {
            return false;
        }
        if (i == 1) {
            return itemStack.m_150930_((Item)ItemRegistry.SALT.get()) || itemStack.m_150930_((Item)ItemRegistry.PINK_SALT.get());
        }
        if (i == 0) {
            return itemStack.m_150930_(Items.f_42455_);
        }
        return false;
    }

    public int[] m_7071_(Direction direction) {
        if (direction == Direction.NORTH || direction == Direction.SOUTH) {
            return SLOTS_FOR_UP;
        }
        if (direction == Direction.EAST || direction == Direction.WEST) {
            return SLOTS_FOR_SIDES;
        }
        if (direction == Direction.DOWN) {
            return SLOTS_FOR_DOWN;
        }
        return new int[0];
    }

    public boolean m_7155_(int i, ItemStack itemStack, @Nullable Direction direction) {
        return this.m_7013_(i, itemStack);
    }

    public boolean m_7157_(int i, ItemStack itemStack, Direction direction) {
        return true;
    }

    public int m_6643_() {
        return this.items.size();
    }

    public boolean m_7983_() {
        for (ItemStack itemStack : this.items) {
            if (itemStack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int i) {
        return (ItemStack)this.items.get(i);
    }

    public ItemStack m_7407_(int i, int j) {
        return ContainerHelper.m_18969_(this.items, (int)i, (int)j);
    }

    public ItemStack m_8016_(int i) {
        return ContainerHelper.m_18966_(this.items, (int)i);
    }

    public void m_6836_(int i, ItemStack itemStack) {
        this.items.set(i, (Object)itemStack);
        if (itemStack.m_41613_() > this.m_6893_()) {
            itemStack.m_41764_(this.m_6893_());
        }
        this.m_6596_();
    }

    public boolean m_6542_(Player player) {
        return Container.m_272074_((BlockEntity)this, (Player)player);
    }

    public void m_6211_() {
        this.items.clear();
    }
}

