/*
 * Decompiled with CFR 0.152.
 */
package com.conquest.hearthfire.world.level.block.entity;

import com.conquest.hearthfire.util.Util;
import com.conquest.hearthfire.world.level.block.entity.BlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class StorageBlockEntity
extends BlockEntity {
    private int size;
    private NonNullList<ItemStack> inventory;

    public StorageBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)BlockEntityTypes.STORAGE.get(), blockPos, blockState);
    }

    public StorageBlockEntity(BlockPos blockPos, BlockState blockState, int size) {
        super((BlockEntityType)BlockEntityTypes.STORAGE.get(), blockPos, blockState);
        this.size = size;
        this.inventory = NonNullList.m_122780_((int)this.size, (Object)ItemStack.f_41583_);
    }

    public void m_6596_() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (!this.f_58857_.m_5776_()) {
                ClientboundBlockEntityDataPacket updatePacket = this.getUpdatePacket();
                for (ServerPlayer player : Util.getPlayersTrackingPosition(serverLevel, this.m_58899_())) {
                    player.f_8906_.m_9829_((Packet)updatePacket);
                }
            }
        }
        super.m_6596_();
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.size = nbt.m_128451_("size");
        this.inventory = NonNullList.m_122780_((int)this.size, (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)nbt, this.inventory);
    }

    protected void m_183515_(@NotNull CompoundTag nbt) {
        ContainerHelper.m_18973_((CompoundTag)nbt, this.inventory);
        nbt.m_128405_("size", this.size);
        super.m_183515_(nbt);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public ItemStack removeItem(int slot) {
        ItemStack removedItem = (ItemStack)this.inventory.set(slot, (Object)ItemStack.f_41583_);
        this.m_6596_();
        return removedItem;
    }

    public void updateItem(int slot, ItemStack itemStack) {
        this.inventory.set(slot, (Object)itemStack);
        this.m_6596_();
    }

    public void setInventory(NonNullList<ItemStack> inventory) {
        for (int i = 0; i < inventory.size(); ++i) {
            this.inventory.set(i, (Object)((ItemStack)inventory.get(i)));
        }
    }

    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }
}

