/*
 * Decompiled with CFR 0.152.
 */
package com.conquest.hearthfire.world.level.block.state;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.VoxelShape;

public class Shapes {
    public static final VoxelShape FULL_BLOCK = Shapes.box(15.5, 16.0, 15.5, 0.25, 0.0, 0.25);
    public static final VoxelShape FIFTEEN_SIXTEENTHS_BLOCK = Shapes.box(16.0, 15.0, 16.0, 0.0, 0.0, 0.0);
    public static final VoxelShape SEVEN_EIGHTHS_BLOCK = Shapes.box(16.0, 14.0, 16.0, 0.0, 0.0, 0.0);
    public static final VoxelShape THIRTEEN_SIXTEENTHS_BLOCK = Shapes.box(16.0, 13.0, 16.0, 0.0, 0.0, 0.0);
    public static final VoxelShape THREE_QUARTERS_BLOCK = Shapes.box(16.0, 12.0, 16.0, 0.0, 0.0, 0.0);
    public static final VoxelShape FIVE_EIGHTHS_BLOCK = Shapes.box(16.0, 10.0, 16.0, 0.0, 0.0, 0.0);
    public static final VoxelShape HALF_BLOCK = Shapes.box(16.0, 8.0, 16.0, 0.0, 0.0, 0.0);
    public static final VoxelShape THREE_EIGHTHS_BLOCK = Shapes.box(16.0, 6.0, 16.0, 0.0, 0.0, 0.0);
    public static final VoxelShape FIVE_SIXTEENTHS_BLOCK = Shapes.box(16.0, 5.0, 16.0, 0.0, 0.0, 0.0);
    public static final VoxelShape QUARTER_BLOCK = Shapes.box(16.0, 4.0, 16.0, 0.0, 0.0, 0.0);
    public static final VoxelShape EIGHTH_BLOCK = Shapes.box(16.0, 2.0, 16.0, 0.0, 0.0, 0.0);
    public static final VoxelShape ONE_INSET_BLOCK = Shapes.box(14.0, 16.0, 14.0, 0.0, 0.0, 0.0);
    public static final VoxelShape ONE_INSET_THREE_QUARTERS_BLOCK = Shapes.box(14.0, 12.0, 14.0, 0.0, 0.0, 0.0);
    public static final VoxelShape ONE_INSET_HALF_BLOCK = Shapes.box(14.0, 8.0, 14.0, 0.0, 0.0, 0.0);
    public static final VoxelShape ONE_INSET_THREE_EIGHTHS_BLOCK = Shapes.box(14.0, 6.0, 14.0, 0.0, 0.0, 0.0);
    public static final VoxelShape ONE_INSET_QUARTER_BLOCK = Shapes.box(14.0, 4.0, 14.0, 0.0, 0.0, 0.0);
    public static final VoxelShape ONE_INSET_EIGHTH_BLOCK = Shapes.box(14.0, 2.0, 14.0, 0.0, 0.0, 0.0);
    public static final VoxelShape TWO_INSET_BLOCK = Shapes.box(12.0, 16.0, 12.0, 0.0, 0.0, 0.0);
    public static final VoxelShape TWO_INSET_THREE_QUARTERS_BLOCK = Shapes.box(12.0, 12.0, 12.0, 0.0, 0.0, 0.0);
    public static final VoxelShape TWO_INSET_QUARTER_BLOCK = Shapes.box(12.0, 4.0, 12.0, 0.0, 0.0, 0.0);
    public static final VoxelShape SIDE_TABLE = Shapes.createSideTableShape();
    public static final VoxelShape BOWL = Shapes.box(8.0, 2.0, 8.0, 0.0, 0.0, 0.0);
    public static final VoxelShape SACK = Shapes.box(7.0, 8.0, 7.0, 0.0, 0.0, 0.0);
    public static final VoxelShape NAILS = Shapes.box(4.0, 6.0, 4.0, 0.0, 0.0, 0.0);
    public static final VoxelShape CUT_CHEESE = Shapes.box(15.0, 4.5, 13.0, 0.0, 0.0, 0.0);
    public static final VoxelShape CUT_AGED_CHEESE = Shapes.box(15.0, 6.5, 14.0, 0.0, 0.0, 0.0);
    public static final VoxelShape LARGE_BOTTLE = Shapes.box(10.0, 12.0, 10.0, 0.0, 0.0, 0.0);
    public static final VoxelShape MOROCCAN_ROUND_TABLE = Shapes.or(Shapes.box(12.0, 15.0, 12.0, 0.0, 0.0, 0.0), Shapes.box(14.0, 1.0, 14.0, 0.0, 15.0, 0.0));
    public static final VoxelShape ARABIC_ROUND_TABLE = Shapes.or(Shapes.box(14.5, 15.0, 14.5, 0.0, 0.0, 0.0), Shapes.box(16.0, 1.0, 16.0, 0.0, 15.0, 0.0));
    public static final VoxelShape STAKE_ANVIL = Shapes.or(TWO_INSET_THREE_QUARTERS_BLOCK, Shapes.box(3.0, 4.0, 7.0, 0.0, 12.0, 0.0));
    public static final VoxelShape FOOTWEAR = Shapes.box(8.0, 4.0, 8.0, 0.0, 0.0, 0.0);
    public static final List<VoxelShape> HAY_BUNDLE = List.of(ONE_INSET_HALF_BLOCK, ONE_INSET_THREE_QUARTERS_BLOCK, ONE_INSET_THREE_QUARTERS_BLOCK, ONE_INSET_BLOCK);
    public static final List<VoxelShape> SMALL_BARREL = List.of(Shapes.box(10.0, 13.0, 10.0, 0.0, 0.0, 0.0), THIRTEEN_SIXTEENTHS_BLOCK, THIRTEEN_SIXTEENTHS_BLOCK, THIRTEEN_SIXTEENTHS_BLOCK);
    public static final List<VoxelShape> CHEESE = List.of(TWO_INSET_QUARTER_BLOCK, Shapes.box(12.0, 8.0, 12.0, 0.0, 0.0, 0.0), TWO_INSET_THREE_QUARTERS_BLOCK, TWO_INSET_BLOCK);
    public static final List<VoxelShape> AGED_CHEESE = List.of(ONE_INSET_THREE_EIGHTHS_BLOCK, ONE_INSET_THREE_QUARTERS_BLOCK, Shapes.box(14.0, 18.0, 14.0, 0.0, 0.0, 0.0), Shapes.box(14.0, 24.0, 14.0, 0.0, 0.0, 0.0));
    public static final List<VoxelShape> BOTTLE = List.of(Shapes.box(4.0, 12.0, 4.0, 0.0, 0.0, 0.0), Shapes.box(8.0, 12.0, 8.0, 0.0, 0.0, 0.0), Shapes.box(8.0, 12.0, 8.0, 0.0, 0.0, 0.0), TWO_INSET_THREE_QUARTERS_BLOCK);
    public static final List<VoxelShape> SCROLL_PILE = List.of(QUARTER_BLOCK, QUARTER_BLOCK, THREE_EIGHTHS_BLOCK, THREE_EIGHTHS_BLOCK);
    public static final Map<Direction, VoxelShape> VERTICAL_HALF_BLOCK = Shapes.directionalShapes(16.0, 16.0, 8.0, 4.0, 0.0, 4.0);
    public static final Map<Direction, VoxelShape> CABINET = Shapes.directionalShapes(16.0, 16.0, 10.0, 3.0, 0.0, 3.0);
    public static final Map<Direction, VoxelShape> DRESSER = Shapes.directionalShapes(16.0, 16.0, 12.5, 1.75, 0.0, 1.75);
    public static final Map<Direction, VoxelShape> SOFA = Shapes.createSeatShapes(16.0, 10.0, 2.5, 6.75, 8.5, 6.75);
    public static final Map<Direction, VoxelShape> DAYBED = Shapes.createSeatShapes(16.0, 11.0, 1.5, 7.25, 11.0, 7.25);
    public static final Map<Direction, VoxelShape> BENCH = Shapes.createSeatShapes(16.0, 13.0, 2.0, 7.0, 11.0, 7.0);
    public static final Map<Direction, VoxelShape> WOODEN_CHAMBER_POT = Shapes.directionalShapes(12.5, 16.0, 16.0, 0.0, 0.0, 0.0);
    public static final Map<Direction, VoxelShape> MIRROR = Shapes.directionalShapes(16.0, 16.0, 1.0, 7.5, 0.0, 7.5);
    public static final Map<Direction, VoxelShape> TAILOR_MIRROR = Shapes.directionalShapes(16.0, 16.0, 8.0, 0.0, 0.0, 0.0);
    public static final Map<Direction, VoxelShape> BURLAP_SACK = Shapes.directionalShapes(16.0, 13.5, 12.0, 0.0, 0.0, 0.0);
    public static final Map<Direction, VoxelShape> WOODEN_TOOLBOX = Shapes.directionalShapes(14.0, 16.0, 9.0, 0.0, 0.0, 0.0);
    public static final Map<Direction, VoxelShape> WOOD_TROUGH = Shapes.directionalShapes(16.0, 9.5, 14.0, 0.0, 0.0, 1.0);
    public static final Map<Direction, VoxelShape> BASKET_FEEDER = Shapes.directionalShapes(16.0, 12.0, 13.0, 0.0, 0.0, 1.5);
    public static final Map<Direction, VoxelShape> OLD_WOOD_CHAIR = Shapes.combinedDirectionalShapes(13.0, 9.5, 12.0, 1.0, 0.0, 1.0, 13.0, 12.5, 2.0, 6.0, 9.5, 6.0);
    public static final Map<Direction, VoxelShape> OAK_CHAIR = Shapes.combinedDirectionalShapes(13.0, 10.0, 13.5, 1.25, 0.0, 1.25, 13.0, 16.0, 1.5, 7.25, 10.0, 7.25);
    public static final Map<Direction, VoxelShape> SPRUCE_CHAIR = Shapes.combinedDirectionalShapes(13.0, 10.5, 13.5, 0.0, 0.0, 0.0, 13.0, 14.5, 2.0, 5.75, 10.5, 5.75);
    public static final Map<Direction, VoxelShape> THREE_LEGGED_CHAIR = Shapes.combinedDirectionalShapes(16.0, 10.0, 13.0, 1.5, 0.0, 1.5, 16.0, 6.0, 1.5, 7.25, 10.0, 7.25);
    public static final Map<Direction, VoxelShape> OLD_WOOD_TABLE = Shapes.combinedDirectionalShapes(16.0, 15.0, 14.0, 1.0, 0.0, 1.0, 16.0, 1.0, 16.0, 0.0, 15.0, 0.0);
    public static final Map<Direction, VoxelShape> WOODEN_LATRINE = Shapes.combinedDirectionalShapes(16.0, 10.0, 16.0, 0.0, 0.0, 0.0, 14.0, 14.0, 1.0, 7.5, 10.0, 7.5);
    public static final Map<Direction, VoxelShape> ROPE_ON_THE_WALL = Shapes.directionalShapes(16.0, 16.0, 2.0, 7.0, 0.0, 7.0);
    public static final Map<Direction, VoxelShape> WHEEL = Shapes.directionalShapes(10.0, 16.0, 3.0, 7.0, 0.0, 7.0);
    public static final Map<Direction, VoxelShape> HAND_PLANER = Shapes.directionalShapes(14.0, 7.0, 5.0, 0.0, 0.0, 0.0);
    public static final Map<Direction, VoxelShape> MALLET = Shapes.directionalShapes(6.0, 4.0, 12.0, 0.0, 0.0, 0.0);

    public static VoxelShape box(double width, double height, double depth, double offsetX, double offsetY, double offsetZ) {
        double minX = 8.0 - width / 2.0 + offsetX;
        double minY = offsetY;
        double minZ = 8.0 - depth / 2.0 + offsetZ;
        double maxX = 8.0 + width / 2.0 + offsetX;
        double maxY = offsetY + height;
        double maxZ = 8.0 + depth / 2.0 + offsetZ;
        return Block.m_49796_((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
    }

    private static Map<Direction, VoxelShape> directionalShapes(double width, double height, double depth, double offsetX, double offsetY, double offsetZ) {
        return Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Shapes.box(width, height, depth, 0.0, offsetY, offsetZ), (Object)Direction.EAST, (Object)Shapes.box(depth, height, width, -offsetX, offsetY, 0.0), (Object)Direction.SOUTH, (Object)Shapes.box(width, height, depth, 0.0, offsetY, -offsetZ), (Object)Direction.WEST, (Object)Shapes.box(depth, height, width, offsetX, offsetY, 0.0)));
    }

    private static Map<Direction, VoxelShape> combinedDirectionalShapes(double width1, double height1, double depth1, double offsetX1, double offsetY1, double offsetZ1, double width2, double height2, double depth2, double offsetX2, double offsetY2, double offsetZ2) {
        Map<Direction, VoxelShape> directionalShapes1 = Shapes.directionalShapes(width1, height1, depth1, offsetX1, offsetY1, offsetZ1);
        Map<Direction, VoxelShape> directionalShapes2 = Shapes.directionalShapes(width2, height2, depth2, offsetX2, offsetY2, offsetZ2);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            builder.put((Object)direction, (Object)Shapes.or(directionalShapes1.get(direction), directionalShapes2.get(direction)));
        }
        return builder.build();
    }

    private static Map<Direction, VoxelShape> createSeatShapes(double width, double height, double depth, double offsetX, double offsetY, double offsetZ) {
        return Shapes.combinedDirectionalShapes(16.0, offsetY, 16.0, 0.0, 0.0, 0.0, width, height, depth, offsetX, offsetY, offsetZ);
    }

    private static VoxelShape createSideTableShape() {
        return net.minecraft.world.phys.shapes.Shapes.m_83113_((VoxelShape)Shapes.or(Shapes.box(14.0, 1.0, 14.0, 0.0, 15.0, 0.0), Shapes.box(13.0, 15.0, 13.0, 0.0, 0.0, 0.0)), (VoxelShape)Shapes.or(Shapes.box(13.0, 10.5, 10.0, 0.0, 0.0, 0.0), Shapes.box(10.0, 10.5, 13.0, 0.0, 0.0, 0.0)), (BooleanOp)BooleanOp.f_82685_);
    }

    public static VoxelShape or(VoxelShape voxelShape, VoxelShape voxelShape2) {
        return net.minecraft.world.phys.shapes.Shapes.m_83113_((VoxelShape)voxelShape, (VoxelShape)voxelShape2, (BooleanOp)BooleanOp.f_82695_);
    }

    public static VoxelShape empty() {
        return net.minecraft.world.phys.shapes.Shapes.m_83040_();
    }
}

