/*
 * Decompiled with CFR 0.152.
 */
package me.RareHyperIon.ChatGames;

import java.util.Objects;
import me.RareHyperIon.ChatGames.commands.ChatGameCommand;
import me.RareHyperIon.ChatGames.commands.InternalCommand;
import me.RareHyperIon.ChatGames.handlers.GameHandler;
import me.RareHyperIon.ChatGames.handlers.LanguageHandler;
import me.RareHyperIon.ChatGames.listeners.PlayerListener;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class ChatGames
extends JavaPlugin {
    private LanguageHandler languageHandler;
    private GameHandler gameHandler;

    public void onLoad() {
        this.saveDefaultConfig();
    }

    public void onEnable() {
        this.languageHandler = new LanguageHandler(this);
        this.gameHandler = new GameHandler(this, this.languageHandler);
        this.languageHandler.load();
        this.gameHandler.load();
        ChatGameCommand commandExecutor = new ChatGameCommand(this);
        Objects.requireNonNull(this.getCommand("chatgames")).setExecutor((CommandExecutor)commandExecutor);
        Objects.requireNonNull(this.getCommand("chatgames")).setTabCompleter((TabCompleter)commandExecutor);
        Objects.requireNonNull(this.getCommand("chatgames-internal-win")).setExecutor((CommandExecutor)new InternalCommand(this));
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerListener(this.gameHandler), (Plugin)this);
        this.getSLF4JLogger().info("ChatGames has been enabled!");
    }

    public void onDisable() {
        if (this.gameHandler != null) {
            this.gameHandler.shutdown();
        }
        this.getSLF4JLogger().info("ChatGames has been disabled!");
    }

    public void reload() {
        this.getSLF4JLogger().info("Reloading ChatGames...");
        this.reloadConfig();
        this.languageHandler.load();
        this.gameHandler.reload();
        this.getSLF4JLogger().info("ChatGames reloaded successfully!");
    }

    public boolean logFull() {
        return Objects.equals(this.getConfig().getString("LOG_TYPE"), "FULL");
    }

    public GameHandler getGameHandler() {
        return this.gameHandler;
    }

    public LanguageHandler getLanguageHandler() {
        return this.languageHandler;
    }
}

