/*
 * Decompiled with CFR 0.152.
 */
package me.RareHyperIon.ChatGames.commands;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import me.RareHyperIon.ChatGames.ChatGames;
import me.RareHyperIon.ChatGames.commands.SubCommand;
import me.RareHyperIon.ChatGames.games.GameConfig;
import me.RareHyperIon.ChatGames.handlers.GameHandler;
import me.RareHyperIon.ChatGames.utility.Utility;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChatGameCommand
implements CommandExecutor,
TabCompleter {
    private final ChatGames plugin;

    public ChatGameCommand(ChatGames plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String label, @NotNull String[] args) {
        String prefix = this.plugin.getLanguageHandler().get("Prefix");
        if (args.length == 0) {
            sender.sendMessage(Utility.color(prefix + " &cUsage: /cg <subcommand>"));
            return true;
        }
        SubCommand subCommand = SubCommand.fromString(args[0]);
        if (subCommand == null) {
            sender.sendMessage(Utility.color(prefix + " &cUnknown subcommand. Usage: /cg <subcommand>"));
            return true;
        }
        if (!subCommand.hasPermission(sender)) {
            sender.sendMessage(Utility.color(prefix + " &cYou don't have permission to use this command."));
            return true;
        }
        GameHandler gameHandler = this.plugin.getGameHandler();
        switch (subCommand) {
            case RELOAD: {
                this.plugin.reload();
                sender.sendMessage(Utility.color(prefix + " &aSuccessfully reloaded ChatGames."));
                break;
            }
            case START: {
                if (args.length < 2) {
                    sender.sendMessage(Utility.color(prefix + " &cUsage: /cg start <game>"));
                    return true;
                }
                String gameName = String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length));
                GameConfig gameConfig = gameHandler.getGames().stream().filter(game -> game.name.equalsIgnoreCase(gameName)).findFirst().orElse(null);
                if (gameConfig == null) {
                    sender.sendMessage(Utility.color(prefix + " &cUnknown game: " + gameName));
                    return true;
                }
                gameHandler.startGame(gameConfig);
                break;
            }
            case STOP: {
                gameHandler.stopGame();
                sender.sendMessage(Utility.color(prefix + " &aGame stopped."));
                break;
            }
            case LIST: {
                sender.sendMessage(Utility.color(prefix + " &b&lAvailable games:"));
                for (GameConfig game2 : gameHandler.getGames()) {
                    sender.sendMessage(Utility.color("&e- &a" + game2.name));
                }
                break;
            }
            case INFO: {
                sender.sendMessage(Utility.color(prefix + " &aChatGames v" + this.plugin.getDescription().getVersion()));
                break;
            }
            case TOGGLE: {
                boolean automaticGames = !this.plugin.getConfig().getBoolean("AutomaticGames");
                this.plugin.getConfig().set("AutomaticGames", (Object)automaticGames);
                this.plugin.saveConfig();
                gameHandler.setAutomaticGames(automaticGames);
                sender.sendMessage(Utility.color(prefix + " &aAutomatic games have been " + (automaticGames ? "enabled" : "disabled") + "."));
            }
        }
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String label, @NotNull String[] args) {
        if (args.length == 1) {
            return Stream.of(SubCommand.values()).filter(subCmd -> subCmd.hasPermission(sender)).map(SubCommand::getName).filter(name -> name.toLowerCase().startsWith(args[0].toLowerCase())).toList();
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("start")) {
            return this.plugin.getGameHandler().getGames().stream().map(game -> game.name).filter(name -> name.toLowerCase().startsWith(args[1].toLowerCase())).toList();
        }
        return List.of();
    }
}

